/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinProperties {
    public static final String TITLE = "title";
    public static final String AUTHOR = "author";
    public static final String USERNAME = "username";
    public static final String COMPANY = "company";
    public static final String VERSION = "version";
    public static final String CREATION_DATE = "creationDate";
    public static final String LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String DESCRIPTION = "description";
    public static final String HOME_PAGE = "homePage";
    public static final String SUPPORT_FORUM = "supportForum";
    public static final String REQUIRED_JALBUM_VERSION = "requiredJalbumVersion";
    public static final String REQUIRED_JAVA_VERSION = "requiredJavaVersion";
    public static final String AUTO_WIDGET_INJECTION = "autoWidgetInjection";
    public static final String ENABLE_THUMBNAIL_LAYOUT = "enableThumbnailLayout";
    public static final String TRUE_ORIGINAL_PATH = "trueOriginalPath";
    public static final String COMPATIBILITY_MODE = "compatibilityMode";
    public static final String FULL_SITE_SUPPORT = "fullSiteSupport";
    public static final String PREVENT_COPY = "preventCopy";
    public static final String FULL_VIDEO_SUPPORT = "fullVideoSupport";
    private Map<String, String> localProps = new HashMap<String, String>();
    private RepositoryProperties repositoryProps;
    private File file;

    public SkinProperties(File skinDir) {
        this.file = new File(skinDir, "skin.properties");
        if (this.file.exists()) {
            try {
                this.localProps = IO.readMapFile(this.file);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void save() throws IOException {
        IO.writeMapFile(this.localProps, this.file);
    }

    public String getProperty(String key) {
        return this.localProps.get(key);
    }

    public String getProperty(String key, String def) {
        String value = this.localProps.get(key);
        return value != null ? value : def;
    }

    public Map<String, String> getProperties() {
        return this.localProps;
    }

    RepositoryProperties getRepositoryProperties() throws IOException {
        if (this.repositoryProps == null) {
            try {
                String skinName = this.file.getParentFile().getName();
                String skinInfoURL = JAlbumSite.getInstance().getSkinInfoUrl();
                if (skinInfoURL == null) {
                    throw new IOException("Can't read skin info url");
                }
                URL u = new URL(IO.combinePaths(skinInfoURL, IO.urlEncode(skinName)));
                Debug.log("Calling URL " + u);
                URLConnection conn = u.openConnection();
                conn.setConnectTimeout(5000);
                InputStream is = conn.getInputStream();
                InputSource input = new InputSource(is);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node skin = (Node)xpath.evaluate("//skin", input, XPathConstants.NODE);
                if (skin != null) {
                    String version = xpath.evaluate("current-version", skin);
                    String skinPage = xpath.evaluate("url", skin);
                    String lu = xpath.evaluate("last-updated", skin);
                    GregorianCalendar lastUpdated = new GregorianCalendar();
                    lastUpdated.setTime(DateFormat.getDateInstance(3, new Locale("sv")).parse(lu));
                    if (version != null) {
                        VersionNumber currentVersion = new VersionNumber(version);
                        this.repositoryProps = new RepositoryProperties(currentVersion, lastUpdated, skinPage);
                    }
                }
                is.close();
                if (this.repositoryProps == null) {
                    throw new IOException("Skin not registered with repository");
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            catch (XPathExpressionException ex) {
                throw new RuntimeException(ex);
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.repositoryProps;
    }

    public void setProperty(String key, String value) {
        this.localProps.put(key, value);
    }

    public boolean isCompatibilityMode() {
        String s = this.localProps.get(COMPATIBILITY_MODE);
        return "true".equals(s);
    }

    public boolean isAutoWidgetInjection() {
        String s = this.localProps.get(AUTO_WIDGET_INJECTION);
        return !"false".equals(s);
    }

    public boolean isEnableThumbnailLayout() {
        String s = this.localProps.get(ENABLE_THUMBNAIL_LAYOUT);
        return !"false".equals(s);
    }

    public boolean isTrueOriginalPath() {
        String s = this.localProps.get(TRUE_ORIGINAL_PATH);
        return "true".equals(s);
    }

    public VersionNumber getVersion() {
        return new VersionNumber(this.getProperty(VERSION, "0"));
    }

    public static class RepositoryProperties {
        private VersionNumber currentVersion;
        private Calendar lastUpdated;
        private String skinPage;

        public RepositoryProperties(VersionNumber currentVersion, Calendar lastUpdated, String skinPage) {
            this.currentVersion = currentVersion;
            this.lastUpdated = lastUpdated;
            this.skinPage = skinPage;
        }

        public VersionNumber getCurrentVersion() {
            return this.currentVersion;
        }

        public Calendar getLastUpdated() {
            return this.lastUpdated;
        }

        public String getFormattedLastUpdated() {
            return DateFormat.getDateInstance(1).format(this.lastUpdated.getTime());
        }

        public String getSkinPage() {
            return this.skinPage;
        }

        public String toString() {
            return "Version:" + this.currentVersion + " Last updated:" + this.getFormattedLastUpdated() + " skinPage: " + this.getSkinPage();
        }
    }
}

