/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.IO;

public class RecoveryTool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLifeboat(JAlbumContext context, AlbumObject root, OutputStream out) throws IOException {
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(-1);
        try {
            File projectFile = context.getFrame().projectChooser.getSelectedFile();
            RecoveryTool.writeZipEntry(projectFile.getName(), new FileInputStream(projectFile), zout);
            RecoveryTool.fillLifeboat(root, zout);
            zout.finish();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            zout.close();
            throw throwable;
        }
        zout.close();
    }

    private static void fillLifeboat(AlbumObject folder, ZipOutputStream zout) throws IOException {
        File dir = folder.getFile();
        File commentsFile = new File(dir, "comments.properties");
        File albumfilesFile = new File(dir, "albumfiles.txt");
        File metaFile = new File(dir, "meta.properties");
        File jalbumDir = new File(dir, ".jalbum");
        String pathFromRoot = folder.getPathFromRoot();
        if (!"".equals(pathFromRoot)) {
            ZipEntry e = new ZipEntry(pathFromRoot + "/");
            zout.putNextEntry(e);
        }
        if (commentsFile.exists()) {
            RecoveryTool.writeZipEntry(IO.combinePaths(pathFromRoot, commentsFile.getName()), new FileInputStream(commentsFile), zout);
        }
        if (albumfilesFile.exists()) {
            RecoveryTool.writeZipEntry(IO.combinePaths(pathFromRoot, albumfilesFile.getName()), new FileInputStream(albumfilesFile), zout);
        }
        if (metaFile.exists()) {
            RecoveryTool.writeZipEntry(IO.combinePaths(pathFromRoot, metaFile.getName()), new FileInputStream(metaFile), zout);
        }
        if (jalbumDir.exists()) {
            String jalbumPath = IO.combinePaths(pathFromRoot, ".jalbum");
            ZipEntry e = new ZipEntry(jalbumPath + "/");
            zout.putNextEntry(e);
            for (File f : jalbumDir.listFiles()) {
                if (!f.isFile()) continue;
                RecoveryTool.writeZipEntry(IO.combinePaths(jalbumPath, f.getName()), new FileInputStream(f), zout);
            }
        }
        for (AlbumObject ao : folder.getChildren()) {
            if (ao.isFolder()) {
                RecoveryTool.fillLifeboat(ao, zout);
                continue;
            }
            if (ao.getCategory() != Category.webPage) continue;
            RecoveryTool.writeZipEntry(IO.combinePaths(pathFromRoot, ao.getName()), new FileInputStream(ao.getFile()), zout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipEntry(String path, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        out.putNextEntry(ze);
        try {
            byte[] b = new byte[32768];
            int bytesRead = 0;
            while (bytesRead >= 0) {
                bytesRead = in.read(b);
                if (bytesRead <= 0) continue;
                out.write(b, 0, bytesRead);
            }
            out.closeEntry();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }
}

