/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import net.jalbum.resty.web.XMLResource;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.StateMonitor;
import se.datadosen.component.errorreporting.ErrorReporter;
import se.datadosen.component.errorreporting.Failable;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JHyperTextDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Debug;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.IO;

public class JSignUpDialog
extends JSmartDialog {
    JLabel logo = new JLabel(Icons.getIcon("decorations.dorlogo"));
    JLabel nameLabel = new JLabel(Msg.get("ui.fullName"));
    @Failable(value="name")
    JTextField name = new JTextField(12);
    JLabel usernameLabel = new JLabel(Msg.get("ui.userName"));
    @Failable(value="userName")
    JTextField userName = new JTextField(12);
    JLabel passwordLabel = new JLabel(Msg.get("ui.password"));
    @Failable(value="password")
    JPasswordField password = new JPasswordField(12);
    JLabel emailLabel = new JLabel(Msg.get("ui.email"));
    @Failable(value="email")
    JTextField email = new JTextField(15);
    JCheckBox newsletter = new JCheckBox(Msg.get("ui.newsletter"), true);
    JCheckBox terms = new JCheckBox();
    JLinkLabel termsLabel = new JLinkLabel(JAlbumSite.getInstance().getTermsURL(), Msg.get("ui.termsAndConditions"));
    private static final String SALT = "InvalidUserInputException";
    ErrorReporter errorReporter = new ErrorReporter(this);
    private boolean signupOk = false;
    private final JAlbumFrame parent;
    private Action cancelAction = new AbstractAction(Msg.get("cancel")){

        public void actionPerformed(ActionEvent e) {
            JSignUpDialog.this.errorReporter.resetAll();
            JSignUpDialog.this.setVisible(false);
        }
    };
    private Action signUpAction = new AbstractAction(Msg.get("ui.signUp")){

        public void actionPerformed(ActionEvent e) {
            JSignUpDialog.this.errorReporter.resetAll();
            JSignUpDialog.this.signUpAction.setEnabled(false);
            JSignUpDialog.this.cancelAction.setEnabled(this.enabled);
            JSignUpDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            new SwingWorker<XMLResource, Object>(){

                protected XMLResource doInBackground() throws Exception {
                    RobustResty resty = new RobustResty();
                    HashMap<Object, Object> data = new HashMap<Object, Object>();
                    data.put("userName", JSignUpDialog.this.userName.getText());
                    data.put("password", new String(JSignUpDialog.this.password.getPassword()));
                    data.put("name", JSignUpDialog.this.name.getText());
                    data.put("email", JSignUpDialog.this.email.getText());
                    data.put("newsletter", "" + JSignUpDialog.this.newsletter.isSelected());
                    data.put("hash", DigestUtil.md5(JSignUpDialog.SALT + JSignUpDialog.this.userName.getText().toLowerCase() + JSignUpDialog.SALT));
                    data.put("lang", Config.getConfig().getInterpretedLanguage());
                    data.put("test", "false");
                    try {
                        File signupFile = new File(Config.getConfig().progDir, "system/signup.properties");
                        if (signupFile.exists()) {
                            Properties extra = IO.readPropertyFile(signupFile);
                            data.putAll(extra);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                    System.out.println("Data to post: " + data);
                    return resty.xml(JAlbumSite.getInstance().getSignUpAPIUrl(), (AbstractContent)RobustResty.form(data));
                }

                protected void done() {
                    JSignUpDialog.this.signUpAction.setEnabled(true);
                    JSignUpDialog.this.cancelAction.setEnabled(true);
                    JSignUpDialog.this.setCursor(Cursor.getDefaultCursor());
                    try {
                        XMLResource xmlRes = (XMLResource)this.get();
                        try {
                            String result = (String)xmlRes.get("/reply/result", String.class);
                            String htmlMessage = (String)xmlRes.get("//htmlMessage", String.class);
                            if ("ok".equals(result.toLowerCase())) {
                                JSignUpDialog.this.signupOk = true;
                                Tracer.getInstance().trace("signup", "userName:" + JSignUpDialog.this.userName.getText());
                                if (htmlMessage != null && htmlMessage.length() > 0) {
                                    JHyperTextDialog dialog = new JHyperTextDialog(JSignUpDialog.this, Msg.get("ui.signUpTitle"), htmlMessage, 1);
                                    dialog.setVisible(true);
                                }
                                JSignUpDialog.this.setVisible(false);
                                return;
                            }
                            Component failable = null;
                            NodeList nl = (NodeList)xmlRes.get("//errors/error", NodeList.class);
                            XPath xpath = XPathFactory.newInstance().newXPath();
                            for (int i = 0; i < nl.getLength(); ++i) {
                                Node n = nl.item(i);
                                String field = (String)xpath.evaluate("@field", n, XPathConstants.STRING);
                                String message = (String)xpath.evaluate("@message", n, XPathConstants.STRING);
                                JSignUpDialog.this.errorReporter.putFailed(field, message);
                                if (failable != null) continue;
                                failable = JSignUpDialog.this.errorReporter.getFailable(field);
                            }
                            if (failable != null) {
                                failable.requestFocusInWindow();
                            }
                            if (htmlMessage != null && nl.getLength() == 0) {
                                throw new ExecutionException(new Exception(htmlMessage));
                            }
                        }
                        catch (ExecutionException ex2) {
                            throw ex2;
                        }
                        catch (Exception ex2) {
                            throw new RuntimeException(ex2);
                        }
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (ExecutionException ex1) {
                        Debug.showErrorDialog(JSignUpDialog.this, ex1.getCause());
                    }
                }
            }.execute();
        }
    };

    public JSignUpDialog(JAlbumFrame parent) throws HeadlessException {
        super(parent, Msg.get("ui.signUpTitle"), true);
        this.parent = parent;
        this.init();
    }

    public boolean isSignupOk() {
        return this.signupOk;
    }

    private void init() {
        AccountManager.AccountStatus as;
        this.setResizable(false);
        this.nameLabel.setLabelFor(this.name);
        this.usernameLabel.setLabelFor(this.userName);
        this.passwordLabel.setLabelFor(this.password);
        this.emailLabel.setLabelFor(this.email);
        JPanel logoPanel = new JPanel();
        logoPanel.setBorder(BorderFactory.createEmptyBorder(18, 18, 0, 8));
        logoPanel.add(this.logo);
        this.add((Component)logoPanel, "West");
        new StateMonitor(){

            public void onChange() {
                JSignUpDialog.this.signUpAction.setEnabled(JSignUpDialog.this.terms.isSelected());
            }
        }.add(this.terms).done();
        this.newsletter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                if (!JSignUpDialog.this.newsletter.isSelected() && (answer = JOptionPane.showConfirmDialog(JSignUpDialog.this, new JLabel("<html>" + Msg.get("ui.newsletterInfo") + "</html>"), "", 0, 2)) != 0) {
                    JSignUpDialog.this.newsletter.setSelected(true);
                }
            }
        });
        if (this.userName.getText().length() == 0 && (as = SignInManager.getInstance().getAccountStatus()) != null) {
            this.userName.setText(as.get("username", ""));
            this.email.setText(as.get("email", ""));
        }
        ControlPanel form = new ControlPanel();
        form.add("p", this.nameLabel);
        form.add("tab", this.name);
        form.add("br", this.usernameLabel);
        form.add("tab", this.userName);
        form.add("br", this.passwordLabel);
        form.add("tab", this.password);
        form.add("br", this.emailLabel);
        form.add("tab", this.email);
        form.add("br", new JLabel(""));
        form.add("br", this.newsletter);
        JPanel termsPanel = new JPanel(new FlowLayout(3, 0, 0));
        termsPanel.add(this.terms);
        termsPanel.add(this.termsLabel);
        form.add("br", termsPanel);
        this.add((Component)form, "East");
        this.registerActions(this.signUpAction, this.cancelAction);
        this.pack();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.signupOk = false;
            this.name.requestFocusInWindow();
        }
        super.setVisible(visible);
    }
}

