/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.concurrent.atomic.AtomicInteger;
import se.datadosen.jalbum.Category;

public class CategoryCounters {
    private AtomicInteger[] counters = new AtomicInteger[Category.values().length];

    public CategoryCounters() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new AtomicInteger();
        }
    }

    public CategoryCounters increase(Category category) {
        this.counters[category.ordinal()].incrementAndGet();
        return this;
    }

    public CategoryCounters add(Category category, int value) {
        this.counters[category.ordinal()].addAndGet(value);
        return this;
    }

    public CategoryCounters add(CategoryCounters cnt) {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].addAndGet(cnt.counters[i].intValue());
        }
        return this;
    }

    public int getCount(Category category) {
        return this.counters[category.ordinal()].intValue();
    }

    public int getFileCount() {
        int total = this.getTotalCount();
        return total - this.getCount(Category.folder);
    }

    public int getTotalCount() {
        int total = 0;
        for (int i = 0; i < this.counters.length; ++i) {
            total += this.counters[i].intValue();
        }
        return total;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CategoryCounters { ");
        for (Category cat : Category.values()) {
            buf.append((Object)cat);
            buf.append("=");
            buf.append(this.getCount(cat));
            buf.append(" ");
        }
        buf.append("}");
        return buf.toString();
    }
}

