/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import se.datadosen.io.CachedFile;

class CachedFileSupport {
    CachedFileSupport() {
    }

    static CachedFile[] listFiles(File file) throws IOException {
        Path start = file.toPath();
        final ArrayList files = new ArrayList();
        Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                CachedFile cf = new CachedFile(p.toFile(), attrs.isDirectory(), attrs.lastModifiedTime().toMillis(), attrs.size());
                files.add(cf);
                return FileVisitResult.CONTINUE;
            }
        });
        return files.toArray(new CachedFile[files.size()]);
    }
}

