/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.ResizableObjectPanel;

public class ResizableCircle
extends ResizableObject {
    private static final long serialVersionUID = 4723593839833176721L;
    protected double Radius = 0.1;
    protected double Radius2 = 0.2;
    protected double RadiusOut = 0.1;
    protected double Radius2Out = 0.2;
    protected boolean showRadius2 = false;
    protected static final int RESIZE_NW_2 = 11;
    protected static final int RESIZE_NE_2 = 12;
    protected static final int RESIZE_SE_2 = 13;
    protected static final int RESIZE_SW_2 = 14;
    protected static final int RESIZE_N_2 = 15;
    protected static final int RESIZE_E_2 = 16;
    protected static final int RESIZE_S_2 = 17;
    protected static final int RESIZE_W_2 = 18;
    protected int crossSize = 20;

    public ResizableCircle() {
    }

    public ResizableCircle(int width, int height) {
        super(width, height);
        this.X1 = 0.5;
        this.Y1 = 0.5;
    }

    public ResizableCircle(int width, int height, ResizableObjectPanel parentPanel) {
        this(width, height);
        this.setParentPanel(parentPanel);
    }

    public void paint(Graphics g) {
        if (!this.initial) {
            this.checkDimensions(false);
            g.setColor(this.color);
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intRadius1 = (int)(this.RadiusOut * (double)(this.width - 1));
            int intRadius2 = (int)(this.Radius2Out * (double)(this.width - 1));
            g.drawOval(intX1 - intRadius1, intY1 - intRadius1, 2 * intRadius1, 2 * intRadius1);
            if (this.showRadius2) {
                g.drawOval(intX1 - intRadius2, intY1 - intRadius2, 2 * intRadius2, 2 * intRadius2);
            }
            g.drawLine(intX1, intY1 - this.crossSize / 2, intX1, intY1 + this.crossSize / 2);
            g.drawLine(intX1 - this.crossSize / 2, intY1, intX1 + this.crossSize / 2, intY1);
            if (this.position == 1 || this.position == 2 || this.position == 3 || this.position == 4 || this.position == 5 || this.position == 6 || this.position == 7 || this.position == 8 || this.position == 9) {
                this.paintHandles(g);
            }
            if (this.showRadius2 && (this.position == 1 || this.position == 11 || this.position == 12 || this.position == 13 || this.position == 14 || this.position == 15 || this.position == 16 || this.position == 17 || this.position == 18)) {
                this.paintHandles2(g);
            }
        }
    }

    protected void paintHandles(Graphics g) {
        if (this.position == 1 || this.position == 2 || this.position == 3 || this.position == 4 || this.position == 5 || this.position == 6 || this.position == 7 || this.position == 8 || this.position == 9) {
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intRadius1 = (int)(this.RadiusOut * (double)(this.width - 1));
            g.setColor(Color.WHITE);
            g.fillRect(intX1 + intRadius1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - intRadius1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - this.handlesize / 2, intY1 + intRadius1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - this.handlesize / 2, intY1 - intRadius1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.setColor(Color.BLACK);
            g.drawRect(intX1 + intRadius1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - intRadius1 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - this.handlesize / 2, intY1 + intRadius1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - this.handlesize / 2, intY1 - intRadius1 - this.handlesize / 2, this.handlesize, this.handlesize);
        }
    }

    protected void paintHandles2(Graphics g) {
        if (this.showRadius2 && (this.position == 1 || this.position == 11 || this.position == 12 || this.position == 13 || this.position == 14 || this.position == 15 || this.position == 16 || this.position == 17 || this.position == 18)) {
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intRadius2 = (int)(this.Radius2Out * (double)(this.width - 1));
            g.setColor(Color.WHITE);
            g.fillRect(intX1 + intRadius2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - intRadius2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - this.handlesize / 2, intY1 + intRadius2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.fillRect(intX1 - this.handlesize / 2, intY1 - intRadius2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.setColor(Color.BLACK);
            g.drawRect(intX1 + intRadius2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - intRadius2 - this.handlesize / 2, intY1 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - this.handlesize / 2, intY1 + intRadius2 - this.handlesize / 2, this.handlesize, this.handlesize);
            g.drawRect(intX1 - this.handlesize / 2, intY1 - intRadius2 - this.handlesize / 2, this.handlesize, this.handlesize);
        }
    }

    protected int checkState(int xIn, int yIn) {
        this.checkDimensions(false);
        int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
        int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
        int intRadius1 = (int)(this.RadiusOut * (double)(this.width - 1));
        int intRadius2 = (int)(this.Radius2Out * (double)(this.width - 1));
        double dist = (xIn - intX1) * (xIn - intX1) + (yIn - intY1) * (yIn - intY1);
        if (this.initial) {
            return 0;
        }
        if (dist < (double)((intRadius1 + 5) * (intRadius1 + 5)) && dist > (double)((intRadius1 - 5) * (intRadius1 - 5))) {
            if (xIn < intX1 - intRadius1 + 10 && xIn > intX1 - intRadius1 - 10 && yIn < intY1 + intRadius1 / 2 && yIn > intY1 - intRadius1 / 2) {
                return 9;
            }
            if (xIn < intX1 + intRadius1 + 10 && xIn > intX1 + intRadius1 - 10 && yIn < intY1 + intRadius1 / 2 && yIn > intY1 - intRadius1 / 2) {
                return 7;
            }
            if (yIn < intY1 - intRadius1 + 10 && yIn > intY1 - intRadius1 - 10 && xIn < intX1 + intRadius1 / 2 && xIn > intX1 - intRadius1 / 2) {
                return 6;
            }
            if (yIn < intY1 + intRadius1 + 10 && yIn > intY1 + intRadius1 - 10 && xIn < intX1 + intRadius1 / 2 && xIn > intX1 - intRadius1 / 2) {
                return 8;
            }
            if (xIn < intX1 && yIn < intY1) {
                return 2;
            }
            if (xIn >= intX1 && yIn < intY1) {
                return 3;
            }
            if (xIn < intX1 && yIn >= intY1) {
                return 5;
            }
            return 4;
        }
        if (dist < (double)((intRadius2 + 5) * (intRadius2 + 5)) && dist > (double)((intRadius2 - 5) * (intRadius2 - 5)) && this.showRadius2) {
            if (xIn < intX1 - intRadius2 + 10 && xIn > intX1 - intRadius2 - 10 && yIn < intY1 + intRadius2 / 2 && yIn > intY1 - intRadius2 / 2) {
                return 18;
            }
            if (xIn < intX1 + intRadius2 + 10 && xIn > intX1 + intRadius2 - 10 && yIn < intY1 + intRadius2 / 2 && yIn > intY1 - intRadius2 / 2) {
                return 16;
            }
            if (yIn < intY1 - intRadius2 + 10 && yIn > intY1 - intRadius2 - 10 && xIn < intX1 + intRadius2 / 2 && xIn > intX1 - intRadius2 / 2) {
                return 15;
            }
            if (yIn < intY1 + intRadius2 + 10 && yIn > intY1 + intRadius2 - 10 && xIn < intX1 + intRadius2 / 2 && xIn > intX1 - intRadius2 / 2) {
                return 17;
            }
            if (xIn < intX1 && yIn < intY1) {
                return 11;
            }
            if (xIn >= intX1 && yIn < intY1) {
                return 12;
            }
            if (xIn < intX1 && yIn >= intY1) {
                return 14;
            }
            return 13;
        }
        if (dist < (double)((intRadius1 - 5) * (intRadius1 - 5))) {
            return 1;
        }
        return 10;
    }

    public void checkDimensions(boolean changeOriginal) {
        double xTemp = this.X1;
        if (this.X1 > 1.0) {
            xTemp = 1.0;
        } else if (this.X1 < 0.0) {
            xTemp = 0.0;
        }
        this.OutX1 = xTemp;
        double yTemp = this.Y1;
        if (this.Y1 > 1.0) {
            yTemp = 1.0;
        } else if (this.Y1 < 0.0) {
            yTemp = 0.0;
        }
        this.OutY1 = yTemp;
        double radiusTemp = this.Radius;
        if (radiusTemp > 1.0 && radiusTemp > (double)this.height / (double)(this.width - 1)) {
            radiusTemp = Math.max(1.0, (double)this.height / (double)(this.width - 1));
        }
        this.RadiusOut = radiusTemp;
        double radius2Temp = this.Radius2;
        if (radius2Temp >= this.Radius) {
            radius2Temp = this.Radius - 1.0 / (double)(this.width - 1);
        }
        this.Radius2Out = radius2Temp;
        if (changeOriginal) {
            this.X1 = xTemp;
            this.Y1 = yTemp;
            this.Radius = radiusTemp;
            this.Radius2 = radius2Temp;
        }
    }

    protected void changeMousePosition(MouseEvent arg0) {
        double inputX = (double)arg0.getX() / (double)(this.width - 1);
        double inputY = (double)arg0.getY() / (double)(this.height - 1);
        if (this.state == 2 || this.state == 5 || this.state == 3 || this.state == 4 || this.state == 6 || this.state == 8 || this.state == 7 || this.state == 9) {
            this.Radius = Math.sqrt((inputX - this.X1) * (inputX - this.X1) + (inputY - this.Y1) * (inputY - this.Y1));
        } else if (this.state == 11 || this.state == 14 || this.state == 12 || this.state == 13 || this.state == 15 || this.state == 17 || this.state == 16 || this.state == 18) {
            this.Radius2 = Math.sqrt((inputX - this.X1) * (inputX - this.X1) + (inputY - this.Y1) * (inputY - this.Y1));
        } else {
            super.changeMousePosition(arg0);
        }
    }

    protected void setMouseCursor(MouseEvent arg0) {
        this.position = this.checkState(arg0.getX(), arg0.getY());
        Cursor oldCursor = this.parentPanel.getCursor();
        if (this.position == 0) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(1));
        } else if (this.position == 1) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(13));
        } else if (this.position == 2 || this.position == 11) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(6));
        } else if (this.position == 3 || this.position == 12) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(7));
        } else if (this.position == 4 || this.position == 13) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(5));
        } else if (this.position == 5 || this.position == 14) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(4));
        } else if (this.position == 6 || this.position == 15) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.position == 7 || this.position == 16) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(11));
        } else if (this.position == 8 || this.position == 17) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.position == 9 || this.position == 18) {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(10));
        } else {
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (oldCursor != this.parentPanel.getCursor()) {
            this.parentPanel.renderPreview();
        }
    }

    public void updateParent() {
        this.parentPanel.updateController(this.OutX1, this.OutY1, this.RadiusOut, this.Radius2Out);
    }

    public void update(double x, double y, double radius, double radius2) {
        this.X1 = x;
        this.Y1 = y;
        this.Radius = radius;
        this.Radius2 = radius2;
        this.checkDimensions(true);
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 521) {
            this.Radius += 1.0 / (double)(this.width - 1);
            this.updateParent();
        } else if (arg0.getKeyCode() == 45) {
            this.Radius -= 1.0 / (double)(this.width - 1);
            this.updateParent();
        } else {
            super.keyPressed(arg0);
        }
    }

    public double getRadius() {
        return this.Radius;
    }

    public void setRadius(double radius) {
        this.Radius = radius;
    }

    public double getRadius2() {
        return this.Radius2;
    }

    public void setRadius2(double radius2) {
        this.Radius2 = radius2;
    }

    public double getRadiusOut() {
        return this.RadiusOut;
    }

    public void setRadiusOut(double radiusOut) {
        this.RadiusOut = radiusOut;
    }

    public double getRadius2Out() {
        return this.Radius2Out;
    }

    public void setRadius2Out(double radius2Out) {
        this.Radius2Out = radius2Out;
    }

    public boolean isShowRadius2() {
        return this.showRadius2;
    }

    public void setShowRadius2(boolean showRadius2) {
        this.showRadius2 = showRadius2;
    }

    public double getObjectWidth() {
        return this.RadiusOut * 2.0;
    }

    public double getObjectHeight() {
        return this.RadiusOut * 2.0 / (double)(this.width - 1) * (double)(this.height - 1);
    }

    public int getCrossSize() {
        return this.crossSize;
    }

    public void setCrossSize(int crossSize) {
        this.crossSize = crossSize;
    }
}

