/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.jalbum.filters.MultipleResizableCircleControl;
import net.jalbum.filters.MultipleResizableObjectPanel;
import net.jalbum.filters.ResizableCircle;
import net.jalbum.filters.ResizableObject;

public class MultipleResizableCirclePanel
extends MultipleResizableObjectPanel {
    private static final long serialVersionUID = -1065478330671173810L;
    protected MultipleResizableCircleControl multipleResizableCircleControl;
    protected ResizableCircle resizableCircle;
    protected boolean showRadius2 = true;
    protected double initalX = 0.0;
    protected double initalY = 0.0;
    protected double initalRadius1 = 0.2;
    protected double initalRadius2 = 0.1;

    public MultipleResizableCirclePanel() {
        this.name = "MultipleResizableCirclePanel";
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = "This is just for inheriting for other filters. This is not applieable.";
        this.prescale = true;
        this.postscale = false;
        this.resizableCircle = new ResizableCircle();
        this.resizableCircle.setName(this.namePrefix + this.counter);
        this.resizableCircle.setParentPanel(this);
        this.resizableCircle.setShowRadius2(this.showRadius2);
        this.resizableCircle.setX1(this.initalX);
        this.resizableCircle.setY1(this.initalY);
        this.resizableCircle.setRadius(this.initalRadius1);
        this.resizableCircle.setRadius2(this.initalRadius2);
        this.objectVector.clear();
        this.hoveredOverObject = this.resizableObject = this.resizableCircle;
        this.multipleResizableCircleControl = new MultipleResizableCircleControl(this);
    }

    public JPanel getControls() {
        return this.multipleResizableCircleControl;
    }

    public void addObject() {
        if (!this.resizableObject.isInitial()) {
            this.resizableObject.setState(10);
            this.resizableCircle = new ResizableCircle(this.width, this.height);
            this.resizableCircle.setParentPanel(this);
            this.resizableCircle.setShowRadius2(this.showRadius2);
            this.objectVector.add(0, this.resizableCircle);
            this.resizableCircle.setName(this.namePrefix + this.counter);
            this.resizableObject = this.resizableCircle;
            ++this.counter;
        }
    }

    protected void paintOutline(Graphics g) {
        g.setColor(new Color(255, 255, 127, 127));
        this.resizableCircle = (ResizableCircle)this.resizableObject;
        int intX1 = (int)(this.resizableCircle.getOutX1() * (double)(this.width - 1));
        int intY1 = (int)(this.resizableCircle.getOutY1() * (double)(this.height - 1));
        int intRadius1 = (int)(this.resizableCircle.getRadiusOut() * (double)(this.width - 1));
        g.drawOval(intX1 - intRadius1, intY1 - intRadius1, 2 * intRadius1, 2 * intRadius1);
    }

    public void updateCircle(double x, double y, double radius, double radius2) {
        ((ResizableCircle)this.resizableObject).update(x, y, radius, radius2);
        this.resizableObject.setInitial(false);
        this.renderPreview();
    }

    public void mouseMoved(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (this.resizableObject != null) {
            if (this.resizableObject.isInitial() || (double)x >= (this.resizableObject.getOutX1() - this.resizableObject.getObjectWidth() / 2.0) * (double)(this.width - 1) - 5.0 && (double)x <= (this.resizableObject.getOutX1() + this.resizableObject.getObjectWidth() / 2.0) * (double)(this.width - 1) + 5.0 && (double)y >= (this.resizableObject.getOutY1() + this.resizableObject.getObjectHeight() / 2.0) * (double)(this.height - 1) - 5.0 && (double)y <= (this.resizableObject.getOutY1() + this.resizableObject.getObjectHeight() / 2.0) * (double)(this.height - 1) + 5.0) {
                this.hoveredOverObject.setState(10);
                this.hoveredOverObject = this.resizableObject;
                this.resizableObject.mouseMoved(event);
            } else {
                for (int i = 0; i < this.objectVector.size(); ++i) {
                    if (!((double)x >= (((ResizableObject)this.objectVector.get(i)).getOutX1() - ((ResizableObject)this.objectVector.get(i)).getObjectWidth() / 2.0) * (double)(this.width - 1) - 5.0) || !((double)x <= (((ResizableObject)this.objectVector.get(i)).getOutX1() + ((ResizableObject)this.objectVector.get(i)).getObjectWidth() / 2.0) * (double)(this.width - 1) + 5.0) || !((double)y >= (((ResizableObject)this.objectVector.get(i)).getOutY1() - ((ResizableObject)this.objectVector.get(i)).getObjectHeight() / 2.0) * (double)(this.height - 1) - 5.0) || !((double)y <= (((ResizableObject)this.objectVector.get(i)).getOutY1() + ((ResizableObject)this.objectVector.get(i)).getObjectHeight()) * (double)(this.height - 1) + 5.0)) continue;
                    this.hoveredOverObject.setState(10);
                    this.hoveredOverObject = (ResizableObject)this.objectVector.get(i);
                    this.hoveredOverObject.mouseMoved(event);
                    return;
                }
                this.hoveredOverObject.setState(10);
                this.hoveredOverObject = this.resizableObject;
                this.resizableObject.mouseMoved(event);
            }
        }
    }

    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (this.resizableObject != null) {
            if (this.resizableObject.isInitial() || (double)x >= (this.resizableObject.getOutX1() - this.resizableObject.getObjectWidth() / 2.0) * (double)(this.width - 1) - 5.0 && (double)x <= (this.resizableObject.getOutX1() - this.resizableObject.getObjectWidth() / 2.0) * (double)(this.width - 1) + 5.0 && (double)y >= (this.resizableObject.getOutY1() + this.resizableObject.getObjectHeight() / 2.0) * (double)(this.height - 1) - 5.0 && (double)y <= (this.resizableObject.getOutY1() + this.resizableObject.getObjectHeight() / 2.0) * (double)(this.height - 1) + 5.0) {
                this.resizableObject.mousePressed(event);
            } else {
                for (int i = 0; i < this.objectVector.size(); ++i) {
                    if (!((double)x >= (((ResizableObject)this.objectVector.get(i)).getOutX1() - ((ResizableObject)this.objectVector.get(i)).getObjectWidth() / 2.0) * (double)(this.width - 1) - 5.0) || !((double)x <= (((ResizableObject)this.objectVector.get(i)).getOutX1() + ((ResizableObject)this.objectVector.get(i)).getObjectWidth() / 2.0) * (double)(this.width - 1) + 5.0) || !((double)y >= (((ResizableObject)this.objectVector.get(i)).getOutY1() - ((ResizableObject)this.objectVector.get(i)).getObjectHeight() / 2.0) * (double)(this.height - 1) - 5.0) || !((double)y <= (((ResizableObject)this.objectVector.get(i)).getOutY1() + ((ResizableObject)this.objectVector.get(i)).getObjectHeight()) * (double)(this.height - 1) + 5.0)) continue;
                    this.selectObject(i);
                    this.resizableObject.mousePressed(event);
                    return;
                }
                if (this.emptyClickCreatesNewObject) {
                    this.addObject();
                    this.mousePressed(event);
                    this.multipleResizableObjectControl.checkButtons();
                    this.renderPreview();
                } else {
                    this.resizableObject.mousePressed(event);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.resizableCircle = null;
    }

    public ResizableCircle getResizableCircle() {
        return (ResizableCircle)this.resizableObject;
    }

    public boolean isShowRadius2() {
        return this.showRadius2;
    }

    public void setShowRadius2(boolean showRadius2) {
        this.showRadius2 = showRadius2;
    }

    public double getInitalX() {
        return this.initalX;
    }

    public void setInitalX(double initalX) {
        this.initalX = initalX;
    }

    public double getInitalY() {
        return this.initalY;
    }

    public void setInitalY(double initalY) {
        this.initalY = initalY;
    }

    public double getInitalRadius1() {
        return this.initalRadius1;
    }

    public void setInitalRadius1(double initalRadius1) {
        this.initalRadius1 = initalRadius1;
    }

    public double getInitalRadius2() {
        return this.initalRadius2;
    }

    public void setInitalRadius2(double initalRadius2) {
        this.initalRadius2 = initalRadius2;
    }

    public MultipleResizableCircleControl getMultipleResizableCircleControl() {
        return this.multipleResizableCircleControl;
    }

    public void setResizableCircle(ResizableCircle resizableCircle) {
        this.resizableCircle = resizableCircle;
    }
}

