/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ZBounds
extends Rectangle2D.Double
implements Serializable {
    private boolean empty = true;

    public ZBounds() {
    }

    public ZBounds(double x, double y, double w, double h) {
        super(x, y, w, h);
        this.empty = false;
    }

    public ZBounds(Rectangle2D rect) {
        super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        this.empty = false;
    }

    public ZBounds(ZBounds bounds) {
        super(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.empty = bounds.isEmpty();
    }

    public Object clone() {
        ZBounds bounds = new ZBounds();
        bounds.add(this);
        return bounds;
    }

    public void reset() {
        this.empty = true;
    }

    public void transform(AffineTransform tf) {
        if (this.isEmpty()) {
            return;
        }
        double[] pts = new double[]{this.x, this.y, this.x + this.width, this.y, this.x + this.width, this.y + this.height, this.x, this.y + this.height};
        tf.transform(pts, 0, pts, 0, 4);
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        int i = 1;
        while (i < 4) {
            if (pts[2 * i] < minX) {
                minX = pts[2 * i];
            }
            if (pts[2 * i + 1] < minY) {
                minY = pts[2 * i + 1];
            }
            if (pts[2 * i] > maxX) {
                maxX = pts[2 * i];
            }
            if (pts[2 * i + 1] > maxY) {
                maxY = pts[2 * i + 1];
            }
            ++i;
        }
        this.setRect(minX, minY, maxX - minX, maxY - minY);
    }

    public Point2D getCenter2D() {
        return new Point2D.Double(this.x + 0.5 * this.width, this.y + 0.5 * this.height);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setRect(double x, double y, double w, double h) {
        super.setRect(x, y, w, h);
        this.empty = false;
    }

    public void setRect(Rectangle2D r) {
        super.setRect(r);
        this.empty = false;
    }

    public void add(double newx, double newy) {
        if (this.empty) {
            this.setRect(newx, newy, 0.0, 0.0);
            this.empty = false;
        } else {
            super.add(newx, newy);
        }
    }

    public void add(Rectangle2D r) {
        if (r.isEmpty()) {
            return;
        }
        if (this.empty) {
            this.setRect(r);
            this.empty = false;
        } else {
            super.add(r);
        }
    }

    public void add(ZBounds r) {
        if (r.isEmpty()) {
            return;
        }
        if (this.empty) {
            this.setRect(r);
            this.empty = false;
        } else {
            super.add(r);
        }
    }

    public void inset(double dx, double dy) {
        this.setRect(this.x + dx, this.y + dy, this.width - dx * 2.0, this.height - dy * 2.0);
    }

    public String toString() {
        String str = this.isEmpty() ? "jazz.util.ZBounds[Empty]" : super.toString();
        return str;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.getX());
        out.writeDouble(this.getY());
        out.writeDouble(this.getWidth());
        out.writeDouble(this.getHeight());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        if (!this.isEmpty()) {
            this.setRect(x, y, w, h);
        }
    }
}

