/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.AffineTransform;

public class ZoomToEventHandler
extends ZFilteredEventHandler {
    private static final double DEFAULT_ZOOM_SCALE = 1.0;
    private static final double DEFAULT_ZOOM_SPACING = 50.0;
    private static final int DEFAULT_ZOOM_TIME = 500;
    private static final int ZOOM_TO_SCALE = 0;
    private static final int ZOOM_TO_SCREEN = 1;
    private ZNode fDefaultZoomToNode;
    private int fZoomMode = 1;
    private double fZoomScale = 1.0;
    private double fZoomSpacing = 50.0;
    private int fZoomTime = 500;

    public ZoomToEventHandler(ZSceneGraphObject aFilteredMouseEventSource) {
        super(aFilteredMouseEventSource);
    }

    public ZoomToEventHandler(ZSceneGraphObject aFilteredMouseEventSource, ZNode aDefaultZoomToNode) {
        this(aFilteredMouseEventSource);
        this.setDefaultZoomToNode(aDefaultZoomToNode);
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(16);
        }
        return this.fMouseFilter;
    }

    public void filteredMousePressed(ZMouseEvent e) {
        this.zoomTo(e);
    }

    protected void zoomTo(ZMouseEvent e) {
        ZCamera aCamera = this.getInteractionCamera();
        ZNode aNode = this.getNodeToZoomTo(e);
        if (aNode == null) {
            return;
        }
        switch (this.fZoomMode) {
            case 0: {
                this.zoomToScaleWith(aCamera, aNode);
                break;
            }
            case 1: {
                this.zoomToScreenWith(aCamera, aNode);
            }
        }
    }

    protected ZNode getNodeToZoomTo(ZMouseEvent aEvent) {
        ZNode result = this.fDefaultZoomToNode;
        ZSceneGraphPath aPath = aEvent.getPath();
        if (aPath.getObject() != null) {
            result = aPath.getNode();
        }
        return result;
    }

    public int getZoomTime() {
        return this.fZoomTime;
    }

    public int setZoomTime(int aTime) {
        this.fZoomTime = aTime;
        return this.fZoomTime;
    }

    public void setDefaultZoomToNode(ZNode aDefaultZoomToNode) {
        this.fDefaultZoomToNode = aDefaultZoomToNode;
    }

    public void setZoomToScale(double aScale) {
        this.fZoomMode = 0;
        this.fZoomScale = aScale;
    }

    public void setZoomToScreen(double aSpacing) {
        this.fZoomMode = 1;
        this.fZoomSpacing = aSpacing;
    }

    protected void zoomToScaleWith(ZCamera aCamera, ZNode aNode) {
        ZBounds nodeBounds = aNode.getGlobalBounds();
        ZBounds cameraBounds = aCamera.getBoundsReference();
        AffineTransform at = new AffineTransform();
        double scale = ZTransformGroup.computeScale(aNode.getGlobalToLocalTransform()) * (this.fZoomScale / 1.0);
        double ctrX = 0.5 * cameraBounds.getWidth();
        double ctrY = 0.5 * cameraBounds.getHeight();
        double nodeBoundsX = nodeBounds.getX() + 0.5 * nodeBounds.getWidth();
        double nodeBoundsY = nodeBounds.getY() + 0.5 * nodeBounds.getHeight();
        at.translate(ctrX + -nodeBoundsX * scale, ctrY + -nodeBoundsY * scale);
        at.scale(scale, scale);
        aCamera.animate(at, this.getZoomTime(), aCamera.getDrawingSurface());
    }

    protected void zoomToScreenWith(ZCamera aCamera, ZNode aNode) {
        ZBounds cameraBounds = aCamera.getBounds();
        cameraBounds.x += this.fZoomSpacing;
        cameraBounds.y += this.fZoomSpacing;
        cameraBounds.width -= this.fZoomSpacing * 2.0;
        cameraBounds.height -= this.fZoomSpacing * 2.0;
        aCamera.center(aNode.getGlobalBounds(), cameraBounds, this.getZoomTime(), aCamera.getDrawingSurface());
    }

    static {
        DEFAULT_ZOOM_SCALE = 1.0;
        DEFAULT_ZOOM_SPACING = 50.0;
        DEFAULT_ZOOM_TIME = 500;
        ZOOM_TO_SCALE = 0;
        ZOOM_TO_SCREEN = 1;
    }
}

