/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZSelectionDeleteHandler;
import edu.umd.cs.jazz.event.ZSelectionModifyHandler;
import edu.umd.cs.jazz.event.ZSelectionMoveHandler;
import edu.umd.cs.jazz.event.ZSelectionResizeHandler;
import edu.umd.cs.jazz.event.ZSelectionScaleHandler;
import edu.umd.cs.jazz.util.ZCanvas;
import java.io.Serializable;

public class ZCompositeSelectionHandler
implements ZEventHandler,
Serializable {
    public static final int MODIFY = 1;
    public static final int MOVE = 2;
    public static final int SCALE = 4;
    public static final int DELETE = 8;
    public static final int RESIZE = 16;
    public static final int ALL_AVAILABLE = 31;
    private int enabledFlag = 0;
    protected boolean active = false;
    protected ZNode node = null;
    protected ZCanvas canvas = null;
    protected ZLayerGroup layer = null;
    private ZSelectionModifyHandler modifyHandler = null;
    private ZSelectionMoveHandler moveHandler = null;
    private ZSelectionScaleHandler scaleHandler = null;
    private ZSelectionDeleteHandler deleteHandler = null;
    private ZSelectionResizeHandler resizeHandler = null;

    public ZCompositeSelectionHandler(ZNode node, ZCanvas canvas, ZLayerGroup marqueeLayer) {
        this(node, canvas, marqueeLayer, 31);
    }

    public ZCompositeSelectionHandler(ZNode node, ZCanvas canvas, ZLayerGroup marqueeLayer, int flags) {
        this.node = node;
        this.canvas = canvas;
        this.layer = marqueeLayer;
        this.setEnabled(flags, true);
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            if (this.moveHandler != null) {
                this.moveHandler.setActive(false);
            }
            if (this.resizeHandler != null) {
                this.resizeHandler.setActive(false);
            }
            if (this.modifyHandler != null) {
                this.modifyHandler.setActive(false);
            }
            if (this.scaleHandler != null) {
                this.scaleHandler.setActive(false);
            }
            if (this.deleteHandler != null) {
                this.deleteHandler.setActive(false);
            }
            this.active = false;
        } else if (!this.active && active) {
            if (this.moveHandler != null) {
                this.moveHandler.setActive(true);
            }
            if (this.resizeHandler != null) {
                this.resizeHandler.setActive(true);
            }
            if (this.modifyHandler != null) {
                this.modifyHandler.setActive(true);
            }
            if (this.scaleHandler != null) {
                this.scaleHandler.setActive(true);
            }
            if (this.deleteHandler != null) {
                this.deleteHandler.setActive(true);
            }
            this.active = true;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public ZLayerGroup getMarqueeLayer() {
        return this.layer;
    }

    public void setMarqueeLayer(ZLayerGroup layer) {
        this.layer = layer;
        if (this.modifyHandler != null && this.modifyHandler instanceof ZSelectionModifyHandler) {
            this.modifyHandler.setMarqueeLayer(layer);
        }
    }

    public void setEnabled(int flags, boolean enable) {
        if (enable) {
            if ((flags & 2) == 2 && this.moveHandler == null) {
                this.moveHandler = this.createSelectionMoveHandler();
                if (this.active && this.modifyHandler != null && this.resizeHandler != null) {
                    this.resizeHandler.setActive(false);
                    this.modifyHandler.setActive(false);
                    this.moveHandler.setActive(true);
                    this.resizeHandler.setActive(true);
                    this.modifyHandler.setActive(true);
                } else if (this.active && this.resizeHandler != null) {
                    this.resizeHandler.setActive(false);
                    this.moveHandler.setActive(true);
                    this.resizeHandler.setActive(true);
                } else if (this.active && this.modifyHandler != null) {
                    this.modifyHandler.setActive(false);
                    this.moveHandler.setActive(true);
                    this.modifyHandler.setActive(true);
                } else if (this.active) {
                    this.moveHandler.setActive(true);
                }
            }
            if ((flags & 0x10) == 16 && this.resizeHandler == null) {
                this.resizeHandler = this.createSelectionResizeHandler();
                if (this.active && this.modifyHandler != null) {
                    this.modifyHandler.setActive(false);
                    this.resizeHandler.setActive(true);
                    this.modifyHandler.setActive(true);
                } else if (this.active) {
                    this.resizeHandler.setActive(true);
                }
            }
            if ((flags & 1) == 1 && this.modifyHandler == null) {
                this.modifyHandler = this.createSelectionModifyHandler();
                if (this.active) {
                    this.modifyHandler.setActive(true);
                }
            }
            if ((flags & 4) == 4 && this.scaleHandler == null) {
                this.scaleHandler = this.createSelectionScaleHandler();
                if (this.active) {
                    this.scaleHandler.setActive(true);
                }
            }
            if ((flags & 8) == 8 && this.deleteHandler == null) {
                this.deleteHandler = this.createSelectionDeleteHandler();
                if (this.active) {
                    this.deleteHandler.setActive(true);
                }
            }
        } else {
            if ((flags & 2) == 2 && this.moveHandler != null) {
                if (this.active) {
                    this.moveHandler.setActive(false);
                }
                this.moveHandler = null;
            }
            if ((flags & 1) == 1 && this.modifyHandler != null) {
                if (this.active) {
                    this.modifyHandler.setActive(false);
                }
                this.modifyHandler = null;
            }
            if ((flags & 4) == 4 && this.scaleHandler != null) {
                if (this.active) {
                    this.scaleHandler.setActive(false);
                }
                this.scaleHandler = null;
            }
            if ((flags & 8) == 8 && this.deleteHandler != null) {
                if (this.active) {
                    this.deleteHandler.setActive(false);
                }
                this.deleteHandler = null;
            }
        }
    }

    public ZSelectionModifyHandler getSelectionModifyHandler() {
        return this.modifyHandler;
    }

    public ZSelectionMoveHandler getSelectionMoveHandler() {
        return this.moveHandler;
    }

    public ZSelectionScaleHandler getSelectionScaleHandler() {
        return this.scaleHandler;
    }

    public ZSelectionDeleteHandler getSelectionDeleteHandler() {
        return this.deleteHandler;
    }

    public ZSelectionResizeHandler getSelectionResizeHandler() {
        return this.resizeHandler;
    }

    protected ZSelectionMoveHandler createSelectionMoveHandler() {
        return new ZSelectionMoveHandler(this.node, this.canvas);
    }

    protected ZSelectionResizeHandler createSelectionResizeHandler() {
        return new ZSelectionResizeHandler(this.node);
    }

    protected ZSelectionModifyHandler createSelectionModifyHandler() {
        return new ZSelectionModifyHandler((ZSceneGraphObject)this.node, this.layer);
    }

    protected ZSelectionScaleHandler createSelectionScaleHandler() {
        return new ZSelectionScaleHandler(this.canvas);
    }

    protected ZSelectionDeleteHandler createSelectionDeleteHandler() {
        return new ZSelectionDeleteHandler(this.canvas);
    }

    static {
        MODIFY = 1;
        MOVE = 2;
        SCALE = 4;
        DELETE = 8;
        RESIZE = 16;
        ALL_AVAILABLE = 31;
    }
}

