/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.Shape;
import java.awt.geom.QuadCurve2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZQuadCurve
extends ZShape {
    protected transient QuadCurve2D quadCurve;

    public ZQuadCurve() {
    }

    public ZQuadCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.setCurve(x1, y1, ctrlx, ctrly, x2, y2);
    }

    protected Object duplicateObject() {
        ZQuadCurve newCurve = (ZQuadCurve)super.duplicateObject();
        newCurve.quadCurve = (QuadCurve2D)this.getQuadCurve().clone();
        return newCurve;
    }

    public QuadCurve2D getQuadCurve() {
        if (this.quadCurve == null) {
            this.quadCurve = new QuadCurve2D.Double();
        }
        return this.quadCurve;
    }

    public Shape getShape() {
        return this.getQuadCurve();
    }

    public void setCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.getQuadCurve().setCurve(x1, y1, ctrlx, ctrly, x2, y2);
        this.reshape();
    }

    public void setCurve(QuadCurve2D c) {
        this.getQuadCurve().setCurve(c);
        this.reshape();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        QuadCurve2D quad = this.getQuadCurve();
        Vector<Double> dimensions = new Vector<Double>();
        dimensions.add(new Double(quad.getX1()));
        dimensions.add(new Double(quad.getY1()));
        dimensions.add(new Double(quad.getCtrlX()));
        dimensions.add(new Double(quad.getCtrlY()));
        dimensions.add(new Double(quad.getX2()));
        dimensions.add(new Double(quad.getY2()));
        out.writeState("quadCurve", "curve", dimensions);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("curve") == 0) {
            Vector dim = (Vector)fieldValue;
            double x1 = (Double)dim.get(0);
            double y1 = (Double)dim.get(1);
            double ctrlx = (Double)dim.get(2);
            double ctrly = (Double)dim.get(3);
            double x2 = (Double)dim.get(4);
            double y2 = (Double)dim.get(5);
            this.setCurve(x1, y1, ctrlx, ctrly, x2, y2);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        QuadCurve2D quad = this.getQuadCurve();
        out.writeDouble(quad.getX1());
        out.writeDouble(quad.getY1());
        out.writeDouble(quad.getCtrlX());
        out.writeDouble(quad.getCtrlY());
        out.writeDouble(quad.getX2());
        out.writeDouble(quad.getY2());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x1 = in.readDouble();
        double y1 = in.readDouble();
        double ctrlx = in.readDouble();
        double ctrly = in.readDouble();
        double x2 = in.readDouble();
        double y2 = in.readDouble();
        this.getQuadCurve().setCurve(x1, y1, ctrlx, ctrly, x2, y2);
    }
}

