/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ZComboBox
extends JComboBox
implements Serializable {
    ZMouseEvent currentEvent;

    public ZComboBox(ComboBoxModel model) {
        super(model);
        this.init();
    }

    public ZComboBox(Object[] items) {
        super(items);
        this.init();
    }

    public ZComboBox(Vector items) {
        super(items);
        this.init();
    }

    public ZComboBox() {
        this.init();
    }

    private void init() {
        this.setUI(new ZBasicComboBoxUI());
    }

    private void setCurrentEvent(ZMouseEvent me) {
        this.currentEvent = me;
    }

    private ZMouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    class EventGrabber
    extends MouseAdapter {
        EventGrabber() {
        }

        public void mousePressed(MouseEvent me) {
            if (me instanceof ZMouseEvent) {
                ZComboBox.this.setCurrentEvent((ZMouseEvent)me);
            }
        }
    }

    class ZBasicComboPopup
    extends BasicComboPopup {
        public ZBasicComboPopup(JComboBox combo) {
            super(combo);
        }

        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            if (ZComboBox.this.currentEvent != null) {
                Rectangle absBounds;
                Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.comboBox.getBounds().width, this.comboBox.getBounds().height);
                ZComboBox.this.currentEvent.getPath().getCamera().localToCamera(bounds, ZComboBox.this.currentEvent.getNode());
                py = (int)(((RectangularShape)bounds).getHeight() + 0.5);
                Rectangle r = new Rectangle(px, py, pw, ph);
                boolean inModalDialog = this.inModalDialog();
                if (inModalDialog) {
                    Point p;
                    Dialog dlg = this.getDialog();
                    if (dlg instanceof JDialog) {
                        JRootPane rp = ((JDialog)dlg).getRootPane();
                        p = rp.getLocationOnScreen();
                        absBounds = rp.getBounds();
                        absBounds.x = p.x;
                        absBounds.y = p.y;
                    } else {
                        absBounds = dlg.getBounds();
                    }
                    p = new Point(absBounds.x, absBounds.y);
                    SwingUtilities.convertPointFromScreen(p, this.comboBox);
                    absBounds.x = p.x;
                    absBounds.y = p.y;
                } else {
                    Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                    absBounds = new Rectangle();
                    Point p = this.getComboLocationOnScreen();
                    absBounds.x = -p.x;
                    absBounds.y = -p.y;
                    absBounds.width = scrSize.width;
                    absBounds.height = scrSize.height;
                }
                Point offset = this.getJazzComboOffset();
                if (SwingUtilities.isRectangleContainingRectangle(absBounds, r)) {
                    r.x += offset.x;
                    r.y += offset.y;
                    return r;
                }
                Rectangle r2 = new Rectangle(0, -r.height, r.width, r.height);
                if (SwingUtilities.isRectangleContainingRectangle(absBounds, r2)) {
                    r2.x = offset.x;
                    r2.y = offset.y + r2.y;
                    return r2;
                }
                if (inModalDialog) {
                    SwingUtilities.computeIntersection(absBounds.x, absBounds.y, absBounds.width, absBounds.height, r);
                    SwingUtilities.computeIntersection(absBounds.x, absBounds.y, absBounds.width, absBounds.height, r2);
                    if (r.height > r2.height) {
                        r.x += offset.x;
                        r.y += offset.y;
                        return r;
                    }
                    r2.x = offset.x;
                    r2.y = offset.y + r2.y;
                    return r2;
                }
                r2.x = offset.x;
                r2.y = offset.y + r2.y;
                return r2;
            }
            return super.computePopupBounds(px, py, pw, ph);
        }

        private Point getComboLocationOnScreen() {
            Point position = null;
            if (this.comboBox.isShowing()) {
                Point2D.Double pt = new Point2D.Double(0.0, 0.0);
                Container c = this.comboBox;
                while (!(c.getParent().getParent() instanceof ZCanvas)) {
                    Point location = c.getLocation();
                    ((Point2D)pt).setLocation(((Point2D)pt).getX() + location.getX(), ((Point2D)pt).getY() + location.getY());
                    c = c.getParent();
                }
                ZCamera camera = ZComboBox.this.currentEvent.getPath().getTopCamera();
                camera.localToCamera(pt, ZComboBox.this.currentEvent.getNode());
                position = new Point((int)(((Point2D)pt).getX() + 0.5), (int)(((Point2D)pt).getY() + 0.5));
                Point canvasOffset = c.getParent().getLocationOnScreen();
                position.setLocation(position.getX() + canvasOffset.getX(), position.getY() + canvasOffset.getY());
            }
            return position;
        }

        private Point getJazzComboOffset() {
            Point swing = this.comboBox.getLocationOnScreen();
            Point jazz = this.getComboLocationOnScreen();
            jazz.setLocation(jazz.getLocation().getX() - swing.getLocation().getX(), jazz.getLocation().getY() - swing.getLocation().getY());
            return jazz;
        }

        private Dialog getDialog() {
            Container parent = this.comboBox.getParent();
            while (parent != null && !(parent instanceof Dialog) && !(parent instanceof Window)) {
                parent = parent.getParent();
            }
            if (parent instanceof Dialog) {
                return (Dialog)parent;
            }
            return null;
        }

        private boolean inModalDialog() {
            return this.getDialog() != null;
        }
    }

    class ZBasicComboBoxUI
    extends BasicComboBoxUI {
        EventGrabber eg;

        ZBasicComboBoxUI() {
            this.eg = new EventGrabber();
        }

        public void configureArrowButton() {
            this.arrowButton.addMouseListener(this.eg);
            super.configureArrowButton();
        }

        protected void installListeners() {
            this.comboBox.addMouseListener(this.eg);
            super.installListeners();
        }

        protected ComboPopup createPopup() {
            ZBasicComboPopup popup = new ZBasicComboPopup(this.comboBox);
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

