/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class ZArc
extends ZShape {
    protected transient Arc2D arc;

    public ZArc() {
    }

    public ZArc(Arc2D aArch) {
        this.setArc(aArch);
    }

    public ZArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        this.setArc(x, y, w, h, angSt, angExt, closure);
    }

    protected Object duplicateObject() {
        ZArc newArc = (ZArc)super.duplicateObject();
        newArc.arc = (Arc2D)this.getArc().clone();
        return newArc;
    }

    public Arc2D getArc() {
        if (this.arc == null) {
            this.arc = new Arc2D.Double();
        }
        return this.arc;
    }

    public Shape getShape() {
        return this.arc;
    }

    public void setArc(Arc2D a) {
        this.getArc().setArc(a);
        this.reshape();
    }

    public void setArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        this.getArc().setArc(x, y, w, h, angSt, angExt, closure);
        this.reshape();
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("arc") == 0) {
            Vector dim = (Vector)fieldValue;
            double x = (Double)dim.get(0);
            double y = (Double)dim.get(1);
            double w = (Double)dim.get(2);
            double h = (Double)dim.get(3);
            double angSt = (Double)dim.get(4);
            double angExt = (Double)dim.get(5);
            int closure = (Integer)dim.get(6);
            this.setArc(x, y, w, h, angSt, angExt, closure);
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        Arc2D arc = this.getArc();
        Vector<Number> dimensions = new Vector<Number>();
        dimensions.add(new Double(arc.getX()));
        dimensions.add(new Double(arc.getY()));
        dimensions.add(new Double(arc.getWidth()));
        dimensions.add(new Double(arc.getHeight()));
        dimensions.add(new Double(arc.getAngleStart()));
        dimensions.add(new Double(arc.getAngleExtent()));
        dimensions.add(new Integer(arc.getArcType()));
        out.writeState("arc", "arc", dimensions);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double x = in.readDouble();
        double y = in.readDouble();
        double w = in.readDouble();
        double h = in.readDouble();
        double angSt = in.readDouble();
        double angExt = in.readDouble();
        int closure = in.readInt();
        this.getArc().setArc(x, y, w, h, angSt, angExt, closure);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Arc2D arc = this.getArc();
        out.writeDouble(arc.getX());
        out.writeDouble(arc.getY());
        out.writeDouble(arc.getWidth());
        out.writeDouble(arc.getHeight());
        out.writeDouble(arc.getAngleStart());
        out.writeDouble(arc.getAngleExtent());
        out.writeInt(arc.getArcType());
    }
}

