/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.ZTransformable;
import edu.umd.cs.jazz.animation.ZAnimation;
import java.awt.geom.AffineTransform;

public class ZTransformAnimation
extends ZAnimation {
    private double[] fSource;
    private double[] fDestination;
    private ZTransformable fTransformTarget;

    public ZTransformAnimation(double[] aSource, double[] aDestination) {
        this.setSourceTransform(aSource);
        this.setDestinationTransform(aDestination);
    }

    public ZTransformAnimation(AffineTransform aSource, AffineTransform aDestination) {
        this.fSource = new double[6];
        this.fDestination = new double[6];
        aSource.getMatrix(this.fSource);
        aDestination.getMatrix(this.fDestination);
    }

    public double[] getSourceTransform() {
        return this.fSource;
    }

    public void setSourceTransform(double[] aSource) {
        this.fSource = aSource;
    }

    public double[] getDestinationTransform() {
        return this.fDestination;
    }

    public void setDestinationTransform(double[] aDestination) {
        this.fDestination = aDestination;
    }

    public ZTransformable getTransformTarget() {
        return this.fTransformTarget;
    }

    public void setTransformTarget(ZTransformable aTarget) {
        this.fTransformTarget = aTarget;
    }

    protected void animateFrameForTime(long aTime) {
        super.animateFrameForTime(aTime);
        float ratio = this.getAlpha().value(aTime);
        if (this.fTransformTarget != null) {
            this.fTransformTarget.setTransform(this.fSource[0] + (double)ratio * (this.fDestination[0] - this.fSource[0]), this.fSource[1] + (double)ratio * (this.fDestination[1] - this.fSource[1]), this.fSource[2] + (double)ratio * (this.fDestination[2] - this.fSource[2]), this.fSource[3] + (double)ratio * (this.fDestination[3] - this.fSource[3]), this.fSource[4] + (double)ratio * (this.fDestination[4] - this.fSource[4]), this.fSource[5] + (double)ratio * (this.fDestination[5] - this.fSource[5]));
        }
    }
}

