/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

public class ZAlpha {
    public static final int ALPHA_INCREASING = 1;
    public static final int ALPHA_DECREASING = 2;
    public static final int ALPHA_INCREASING_AND_DECREASING = 3;
    private int fLoopCount = -1;
    private int fMode = 1;
    private long fTriggerTime = System.currentTimeMillis();
    private long fPhaseDelayDuration = 0L;
    private long fIncreasingAlphaDuration = 0L;
    private long fIncreasingAlphaRampDuration = 0L;
    private long fAlphaAtOneDuration = 0L;
    private long fDecreasingAlphaDuration = 0L;
    private long fDecreasingAlphaRampDuration = 0L;
    private long fAlphaAtZeroDuration = 0L;
    private long fStopTime;

    public static ZAlpha createStandardAlpha(long aIncreasingAlphaDuration) {
        return new ZAlpha(1, aIncreasingAlphaDuration);
    }

    public static ZAlpha createStandardSlowInSlowOutAlpha(long aIncreasingAlphaDuration) {
        return new ZAlpha(1, System.currentTimeMillis(), 0L, aIncreasingAlphaDuration, aIncreasingAlphaDuration / 2L, 0L);
    }

    public ZAlpha() {
        this.updateStopTime();
    }

    public ZAlpha(int aLoopCount, long aIncreasingAlphaDuration) {
        this();
        this.fLoopCount = aLoopCount;
        this.fIncreasingAlphaDuration = aIncreasingAlphaDuration;
        this.updateStopTime();
    }

    public ZAlpha(int aLoopCount, long aTriggerTime, long aPhaseDelayDuration, long aIncreasingAlphaDuration) {
        this(aLoopCount, aIncreasingAlphaDuration);
        this.fTriggerTime = aTriggerTime;
        this.fPhaseDelayDuration = aPhaseDelayDuration;
        this.updateStopTime();
    }

    public ZAlpha(int aLoopCount, long aTriggerTime, long aPhaseDelayDuration, long aIncreasingAlphaDuration, long aIncreasingAlphaRampDuration, long aAlphaAtOneDuration) {
        this(aLoopCount, aTriggerTime, aPhaseDelayDuration, aIncreasingAlphaDuration);
        this.fIncreasingAlphaRampDuration = aIncreasingAlphaRampDuration;
        this.fAlphaAtOneDuration = aAlphaAtOneDuration;
        this.updateStopTime();
    }

    public ZAlpha(int aLoopCount, int aMode, long aTriggerTime, long aPhaseDelayDuration, long aIncreasingAlphaDuration, long aIncreasingAlphaRampDuration, long aAlphaAtOneDuration, long aDecreasingAlphaDuration, long aDecreasingAlphaRampDuration, long aAlphaAtZeroDuration) {
        this(aLoopCount, aTriggerTime, aPhaseDelayDuration, aIncreasingAlphaDuration, aIncreasingAlphaRampDuration, aAlphaAtOneDuration);
        this.fMode = aMode;
        this.fDecreasingAlphaDuration = aDecreasingAlphaDuration;
        this.fDecreasingAlphaRampDuration = aDecreasingAlphaRampDuration;
        this.fAlphaAtZeroDuration = aAlphaAtZeroDuration;
        this.updateStopTime();
    }

    public int getLoopCount() {
        return this.fLoopCount;
    }

    public void setLoopCount(int aLoopCount) {
        this.fLoopCount = aLoopCount;
        if (this.fLoopCount >= 0) {
            this.updateStopTime();
        }
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int aMode) {
        this.fMode = aMode;
        this.updateStopTime();
    }

    public long getTriggerTime() {
        return this.fTriggerTime;
    }

    public void setTriggerTime(long aTriggerTime) {
        this.fTriggerTime = aTriggerTime;
        this.updateStopTime();
    }

    public long getPhaseDelayDuration() {
        return this.fPhaseDelayDuration;
    }

    public void setPhaseDelayDuration(long aPhaseDelayDuration) {
        this.fPhaseDelayDuration = aPhaseDelayDuration;
        this.updateStopTime();
    }

    public long getIncreasingAlphaDuration() {
        return this.fIncreasingAlphaDuration;
    }

    public void setIncreasingAlphaDuration(long aIncreasingAlphaDuration) {
        this.fIncreasingAlphaDuration = aIncreasingAlphaDuration;
        this.updateStopTime();
    }

    public long getIncreasingAlphaRampDuration() {
        return this.fIncreasingAlphaRampDuration;
    }

    public void setIncreasingAlphaRampDuration(long aIncreasingAlphaRampDuration) {
        this.fIncreasingAlphaRampDuration = aIncreasingAlphaRampDuration;
        long halfIncreasingAlphaDuration = this.fIncreasingAlphaDuration / 2L;
        if (this.fIncreasingAlphaRampDuration > halfIncreasingAlphaDuration) {
            this.fIncreasingAlphaRampDuration = halfIncreasingAlphaDuration;
        }
    }

    public long getAlphaAtOneDuration() {
        return this.fAlphaAtOneDuration;
    }

    public void setAlphaAtOneDuration(long aAlphaAtOneDuration) {
        this.fAlphaAtOneDuration = aAlphaAtOneDuration;
        this.updateStopTime();
    }

    public long getDecreasingAlphaDuration() {
        return this.fDecreasingAlphaDuration;
    }

    public void setDecreasingAlphaDuration(long aDecreasingAlphaDuration) {
        this.fDecreasingAlphaDuration = aDecreasingAlphaDuration;
        this.updateStopTime();
    }

    public long getDecreasingAlphaRampDuration() {
        return this.fDecreasingAlphaRampDuration;
    }

    public void setDecreasingAlphaRampDuration(long aDecreasingAlphaRampDuration) {
        this.fDecreasingAlphaRampDuration = aDecreasingAlphaRampDuration;
        long halfDecreasingAlphaDuration = this.fDecreasingAlphaDuration / 2L;
        if (this.fDecreasingAlphaRampDuration > halfDecreasingAlphaDuration) {
            this.fDecreasingAlphaRampDuration = halfDecreasingAlphaDuration;
        }
    }

    public long getAlphaAtZeroDuration() {
        return this.fAlphaAtZeroDuration;
    }

    public void setAlphaAtZeroDuration(long aAlphaAtZeroDuration) {
        this.fAlphaAtZeroDuration = aAlphaAtZeroDuration;
        this.updateStopTime();
    }

    public boolean isStarted(long aTime) {
        return aTime >= this.fTriggerTime + this.fPhaseDelayDuration;
    }

    public boolean isFinished(long aTime) {
        if (this.getLoopCount() == -1) {
            return false;
        }
        return aTime > this.getStopTime();
    }

    public long getStopTime() {
        return this.fStopTime;
    }

    private void updateStopTime() {
        this.fStopTime = this.fTriggerTime + this.fPhaseDelayDuration;
        switch (this.fMode) {
            case 1: {
                this.fStopTime += (long)this.fLoopCount * (this.fIncreasingAlphaDuration + this.fAlphaAtOneDuration);
                break;
            }
            case 2: {
                this.fStopTime += (long)this.fLoopCount * (this.fDecreasingAlphaDuration + this.fAlphaAtZeroDuration);
                break;
            }
            case 3: {
                this.fStopTime += (long)this.fLoopCount * (this.fIncreasingAlphaDuration + this.fAlphaAtOneDuration + this.fDecreasingAlphaDuration + this.fAlphaAtZeroDuration);
            }
        }
    }

    protected float lerp(long currentTime, long totalTime) {
        return (float)currentTime / (float)totalTime;
    }

    protected float sisoLerp(long aTotalTime, long aCurrentTime, long aRampTime) {
        float result = 0.0f;
        float currentTime = this.lerp(aCurrentTime, aTotalTime);
        float accelerationTime = this.lerp(aRampTime, aTotalTime);
        float acceleration = 1.0f / (accelerationTime - accelerationTime * accelerationTime);
        if (currentTime < accelerationTime) {
            result = acceleration * currentTime * currentTime / 2.0f;
        } else if (currentTime < 1.0f - accelerationTime) {
            float valueForAccelerationPhase = acceleration * accelerationTime * accelerationTime / 2.0f;
            float velocityAtEndOfAccelerationPhase = acceleration * accelerationTime;
            float timeAtConstantVelocity = currentTime - accelerationTime;
            result = valueForAccelerationPhase + velocityAtEndOfAccelerationPhase * timeAtConstantVelocity;
        } else {
            float valueForAccelerationPhase = acceleration * accelerationTime * accelerationTime / 2.0f;
            float velocityAtEndOfAccelerationPhase = acceleration * accelerationTime;
            float timeAtConstantVelocity = currentTime - accelerationTime;
            float valueForConstantVelocityPhase = valueForAccelerationPhase + velocityAtEndOfAccelerationPhase * timeAtConstantVelocity;
            float timeInDeceleration = currentTime - (1.0f - accelerationTime);
            result = valueForConstantVelocityPhase + -acceleration * timeInDeceleration * timeInDeceleration / 2.0f;
        }
        return result;
    }

    public float value(long aCurrentTime) {
        long aWaveDelay = this.fPhaseDelayDuration;
        long aWaveLength = this.getWaveLength();
        long aWaveRelativeTime = ((aCurrentTime -= this.fTriggerTime) - aWaveDelay) % aWaveLength;
        if (aCurrentTime < aWaveDelay) {
            aWaveRelativeTime = Long.MIN_VALUE;
        }
        if (this.fLoopCount != -1 && this.fTriggerTime + aCurrentTime >= this.fStopTime) {
            aWaveRelativeTime = Long.MAX_VALUE;
        }
        switch (this.fMode) {
            case 1: {
                return this.valueAlphaIncreasing(aWaveRelativeTime);
            }
            case 2: {
                return this.valueAlphaDecreasing(aWaveRelativeTime);
            }
            case 3: {
                return this.valueAlphaIncreasingAndDecreasing(aWaveRelativeTime);
            }
        }
        return 0.0f;
    }

    protected float valueAlphaIncreasing(long aWaveRelativeTime) {
        if (aWaveRelativeTime <= 0L) {
            return 0.0f;
        }
        if (aWaveRelativeTime >= this.fIncreasingAlphaDuration) {
            return 1.0f;
        }
        if (this.fIncreasingAlphaRampDuration == 0L) {
            return this.lerp(aWaveRelativeTime, this.fIncreasingAlphaDuration);
        }
        return this.sisoLerp(this.fIncreasingAlphaDuration, aWaveRelativeTime, this.fIncreasingAlphaRampDuration);
    }

    protected float valueAlphaDecreasing(long aWaveRelativeTime) {
        if (aWaveRelativeTime <= 0L) {
            return 1.0f;
        }
        if (aWaveRelativeTime >= this.fDecreasingAlphaDuration) {
            return 0.0f;
        }
        if (this.fDecreasingAlphaRampDuration == 0L) {
            return 1.0f - this.lerp(aWaveRelativeTime, this.fDecreasingAlphaDuration);
        }
        return 1.0f - this.sisoLerp(this.fDecreasingAlphaDuration, aWaveRelativeTime, this.fDecreasingAlphaRampDuration);
    }

    protected float valueAlphaIncreasingAndDecreasing(long aWaveRelativeTime) {
        long aIncreasingWaveLength = this.fIncreasingAlphaDuration + this.fAlphaAtOneDuration;
        long aDecreasingWaveLength = this.fDecreasingAlphaDuration + this.fAlphaAtZeroDuration;
        if (aWaveRelativeTime <= 0L) {
            return 0.0f;
        }
        if (aWaveRelativeTime >= aIncreasingWaveLength + aDecreasingWaveLength) {
            return 0.0f;
        }
        if (aWaveRelativeTime <= aIncreasingWaveLength) {
            return this.valueAlphaIncreasing(aWaveRelativeTime);
        }
        return this.valueAlphaDecreasing(aWaveRelativeTime - aIncreasingWaveLength);
    }

    protected long getWaveLength() {
        switch (this.fMode) {
            case 1: {
                return this.fIncreasingAlphaDuration + this.fAlphaAtOneDuration;
            }
            case 2: {
                return this.fDecreasingAlphaDuration + this.fAlphaAtZeroDuration;
            }
            case 3: {
                return this.fIncreasingAlphaDuration + this.fAlphaAtOneDuration + this.fDecreasingAlphaDuration + this.fAlphaAtZeroDuration;
            }
        }
        return 0L;
    }

    static {
        ALPHA_INCREASING = 1;
        ALPHA_DECREASING = 2;
        ALPHA_INCREASING_AND_DECREASING = 3;
    }
}

