/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionGroup;
import edu.umd.cs.jazz.ZSpatialIndex;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZGroupEvent;
import edu.umd.cs.jazz.event.ZGroupListener;
import edu.umd.cs.jazz.event.ZNodeEvent;
import edu.umd.cs.jazz.event.ZNodeListener;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZBoundsFindFilter;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class ZSpatialIndexGroup
extends ZGroup
implements ZGroupListener,
ZSerializable,
Serializable {
    private ZSpatialIndex rIndex;
    private Hashtable nodeListenerHT;
    private ArrayList queryResults = new ArrayList();

    public ZSpatialIndexGroup() {
        this.rIndex = new ZSpatialIndex();
        this.initialize();
    }

    public ZSpatialIndexGroup(ZCamera camera) {
        this.rIndex = new ZSpatialIndex(camera);
        this.initialize();
    }

    private void initialize() {
        this.rIndex.setGroupNodeTransform(this.getLocalToGlobalTransform());
        this.nodeListenerHT = new Hashtable();
        ZGroupListener indexGroupListener = new ZGroupListener(){

            public void nodeAdded(ZGroupEvent e) {
                ZSpatialIndexGroup.this.indexChildren((ZGroup)e.getChild());
            }

            public void nodeRemoved(ZGroupEvent e) {
                ZSpatialIndexGroup.this.unIndexChildren((ZGroup)e.getChild());
            }
        };
        this.addGroupListener(indexGroupListener);
        ZNodeListener nodeListener = new ZNodeListener(){

            public void boundsChanged(ZNodeEvent e) {
            }

            public void globalBoundsChanged(ZNodeEvent e) {
                ZNode pnode = e.getNode();
                ZSpatialIndexGroup.this.rIndex.setGroupNodeTransform(ZSpatialIndexGroup.this.getLocalToGlobalTransform());
            }
        };
        this.addNodeListener(nodeListener);
    }

    public ZSpatialIndexGroup(ZNode child, ZCamera camera) {
        this.rIndex = new ZSpatialIndex(camera);
        this.rIndex.setGroupNodeTransform(this.getLocalToGlobalTransform());
        this.insertAbove(child);
    }

    public void displayTree(String treeName) {
        this.rIndex.displayTree(treeName);
    }

    private boolean indexNode(ZNode node) {
        if (this.getNumChildren() == 0) {
            return false;
        }
        if (!this.rIndex.getStatus()) {
            return false;
        }
        if (node instanceof ZGroup && ((ZGroup)node).hasOneChild()) {
            return false;
        }
        if (node instanceof ZSelectionGroup) {
            return false;
        }
        if (node.editor().getTop().getParent() == this.getChild(0)) {
            this.rIndex.removeNode(node);
            this.rIndex.addNode(node);
            if (node.editor().hasTransformGroup()) {
                ZTransformGroup tg = node.editor().getTransformGroup();
                this.addListener(tg);
            }
            return true;
        }
        return false;
    }

    public void addListener(ZTransformGroup tg) {
        if (!this.nodeListenerHT.containsKey(tg)) {
            ZNodeListener nodeListener = new ZNodeListener(){

                public void boundsChanged(ZNodeEvent e) {
                    ZTransformGroup ptg;
                    ZNode pnode = e.getNode();
                    if (pnode instanceof ZTransformGroup && (ptg = (ZTransformGroup)pnode).getNumChildren() > 0) {
                        ZNode primary = pnode.editor().getNode();
                        ZSpatialIndexGroup.this.indexNode(primary);
                    }
                }

                public void globalBoundsChanged(ZNodeEvent e) {
                }
            };
            tg.addNodeListener(nodeListener);
            this.nodeListenerHT.put(tg, nodeListener);
        }
    }

    private boolean unIndexNode(ZNode node) {
        if (this.getNumChildren() == 0) {
            return false;
        }
        if (!this.rIndex.getStatus()) {
            return false;
        }
        if (this.rIndex.removeNode(node)) {
            if (node.editor().hasTransformGroup()) {
                ZTransformGroup tg = node.editor().getTransformGroup();
                ZNodeListener nodeListener = (ZNodeListener)this.nodeListenerHT.get(tg);
                if (nodeListener != null) {
                    node.removeNodeListener(nodeListener);
                }
                this.nodeListenerHT.remove(node);
            }
            return true;
        }
        return false;
    }

    public void nodeAdded(ZGroupEvent e) {
        ZNode node = e.getChild().editor().getNode();
        this.indexNode(node);
    }

    public void nodeRemoved(ZGroupEvent e) {
        ZNode node = e.getChild().editor().getNode();
        this.unIndexNode(node);
    }

    public void unregisterAllListeners(ZGroup group) {
        int i = 0;
        while (i < group.getNumChildren()) {
            ZNode node = group.getChild(i).editor().getNode();
            ZNodeListener nodeListener = (ZNodeListener)this.nodeListenerHT.get(node);
            if (nodeListener != null) {
                node.removeNodeListener(nodeListener);
            }
            this.nodeListenerHT.remove(node);
            ++i;
        }
    }

    public void unregisterAllListeners() {
        ZGroup group = (ZGroup)this.editor().getNode();
        this.unregisterAllListeners(group);
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        boolean picked = false;
        if (this.isPickable()) {
            path.push(this);
            if (this.rIndex.getStatus()) {
                this.queryResults.clear();
                this.rIndex.queryWindow(this.queryResults, rect);
                Object[] result = this.queryResults.toArray();
                int i = result.length - 1;
                while (i >= 0) {
                    if (((ZNode)result[i]).editor().getTop().getParent().pick(rect, path)) {
                        if (!this.getChildrenPickable()) {
                            path.pop(this);
                            path.setObject(this);
                        }
                        return true;
                    }
                    --i;
                }
                path.pop(this);
            } else {
                return super.pick(rect, path);
            }
        }
        return false;
    }

    public void render(ZRenderContext renderContext) {
        if (this.children.size() == 0) {
            return;
        }
        if (this.rIndex.getStatus()) {
            ZCamera camera = renderContext.getRenderingCamera();
            ZBounds viewBounds = camera.getViewBounds();
            this.rIndex.queryWindow(this.queryResults, camera.getViewBounds());
            Object[] result = this.queryResults.toArray();
            if (ZDebug.debugSpatialIndexing) {
                System.out.println("ZSpatialIndexGroup: Number of objects rendered: " + result.length);
            }
            int i = 0;
            while (i < result.length) {
                ((ZNode)result[i]).editor().getTop().render(renderContext);
                ++i;
            }
        } else {
            super.render(renderContext);
        }
    }

    public void removeChild(ZNode child) {
        super.removeChild(child);
        this.unregisterAllListeners((ZGroup)child);
        this.rIndex = new ZSpatialIndex();
    }

    private void indexChildren(ZGroup group) {
        ZNode[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            ZNode node = children[i].editor().getNode();
            this.indexNode(node);
            ++i;
        }
    }

    private void unIndexChildren(ZGroup group) {
        ZNode[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            ZNode node = children[i].editor().getNode();
            this.unIndexNode(node);
            ++i;
        }
    }

    protected boolean childrenFindable(ZNode node, ZBounds bounds) {
        ZBounds nodeBounds = node.getGlobalBounds();
        return nodeBounds.intersects(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private int find(ZFindFilter filter, ZBounds bounds, ArrayList nodes) {
        int nodesSearched;
        block6: {
            block7: {
                nodesSearched = 1;
                if (!this.isFindable()) break block6;
                if (!this.rIndex.getStatus()) break block7;
                this.queryResults.clear();
                this.rIndex.queryWindow(this.queryResults, bounds);
                Object[] result = this.queryResults.toArray();
                int i = 0;
                while (i < result.length) {
                    if (this == (ZNode)result[i]) {
                        nodes.add(this);
                        break;
                    }
                    ++i;
                }
                if (!this.getChildrenFindable() || !this.childrenFindable(this, bounds)) break block6;
                ZNode[] childrenRef = this.getChildrenReference();
                int i2 = 0;
                while (i2 < this.children.size()) {
                    nodesSearched += childrenRef[i2].findNodes(filter, nodes);
                    ++i2;
                }
                break block6;
            }
            if (filter.accept(this)) {
                nodes.add(this);
            }
            if (this.getChildrenFindable() && filter.childrenFindable(this)) {
                ZNode[] childrenRef = this.getChildrenReference();
                int i = 0;
                while (i < this.children.size()) {
                    nodesSearched += childrenRef[i].findNodes(filter, nodes);
                    ++i;
                }
            }
        }
        return nodesSearched;
    }

    public int findNodes(ZFindFilter filter, ArrayList nodes) {
        if (filter instanceof ZBoundsFindFilter) {
            ZBounds bounds = ((ZBoundsFindFilter)filter).getBounds();
            return this.find(filter, bounds, nodes);
        }
        return super.findNodes(filter, nodes);
    }
}

