/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.Serializable;

public class ZFadeGroup
extends ZGroup
implements ZSerializable,
Serializable {
    public static final short CAMERA_MAG = 0;
    public static final short COMPOSITE_MAG = 1;
    public static final short ABSOLUTE_SCREEN_SIZE = 2;
    public static final short PERCENT_OF_CAMERA = 3;
    public static final short fadeType_DEFAULT = 0;
    public static final double alpha_DEFAULT = 1.0;
    public static final double minMag_DEFAULT = 0.0;
    public static final double maxMag_DEFAULT = 1000.0;
    public static final double fadeRange_DEFAULT = (double)0.3f;
    private static final int NUM_ALPHA_LEVELS = 16;
    private static Composite[] alphas;
    private short fadeType = 0;
    private double alpha = 1.0;
    private double minMag = 0.0;
    private double maxMag = 1000.0;
    private double fadeRange = 0.3f;
    private AffineTransform tmpTransform = new AffineTransform();

    public ZFadeGroup() {
    }

    public ZFadeGroup(ZNode child) {
        super(child);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        if (this.alpha != alpha) {
            if (alpha < 0.0) {
                alpha = 0.0;
            } else if (alpha > 1.0) {
                alpha = 1.0;
            }
            this.alpha = alpha;
            this.repaint();
        }
    }

    public double getMinMag() {
        return this.minMag;
    }

    public void setMinMag(double minMag) {
        if (minMag < 0.0) {
            minMag = 0.0;
        }
        this.minMag = minMag;
        this.repaint();
    }

    public double getMaxMag() {
        return this.maxMag;
    }

    public void setMaxMag(double maxMag) {
        this.maxMag = maxMag;
        this.repaint();
    }

    public void setFadeRange(double fadeRange) {
        if (fadeRange < 0.0) {
            fadeRange = 0.0;
        }
        if (fadeRange > 1.0) {
            fadeRange = 1.0;
        }
        this.fadeRange = fadeRange;
    }

    public double getFadeRange() {
        return this.fadeRange;
    }

    public void setFadeType(short aFadeType) {
        if (aFadeType != 0 && aFadeType != 1 && aFadeType != 2 && aFadeType != 3) {
            throw new Error("Fade type must be: CAMERA_MAG, COMPOSITE_MAG, ABSOLUTE_SCREEN_SIZE or PERCENT_OF_CAMERA");
        }
        this.fadeType = aFadeType;
    }

    public int getFadeType() {
        return this.fadeType;
    }

    private double getCompositeMag(ZSceneGraphPath path) {
        this.tmpTransform.setToIdentity();
        int n = path.getNumParents();
        int i = 0;
        while (i < n) {
            ZSceneGraphObject obj = path.getParent(i);
            if (obj instanceof ZCamera) {
                this.tmpTransform.concatenate(((ZCamera)obj).getViewTransform());
            } else if (obj instanceof ZTransformGroup) {
                this.tmpTransform.concatenate(((ZTransformGroup)obj).getTransformReference());
            }
            ++i;
        }
        return ZTransformGroup.computeScale(this.tmpTransform);
    }

    public boolean isVisible(ZSceneGraphPath path) {
        double currentMag;
        if (path == null) {
            return false;
        }
        ZCamera camera = path.getCamera();
        double metric = currentMag = camera.getMagnification();
        switch (this.fadeType) {
            case 0: {
                metric = currentMag;
                break;
            }
            case 1: {
                metric = this.getCompositeMag(path);
                break;
            }
            case 2: {
                double objSize = Math.max(this.getBounds().getWidth(), this.getBounds().getHeight());
                metric = objSize * this.getCompositeMag(path);
                break;
            }
            case 3: {
                ZBounds cameraView = camera.getViewBounds();
                ZBounds nodeBounds = this.editor().getNode().getGlobalBounds();
                double objWidth = ((RectangularShape)nodeBounds).getWidth();
                double objHeight = ((RectangularShape)nodeBounds).getHeight();
                metric = objWidth > objHeight ? objWidth / ((RectangularShape)cameraView).getWidth() : objHeight / ((RectangularShape)cameraView).getHeight();
            }
        }
        return this.isVisible(metric);
    }

    public boolean isVisible(double metric) {
        boolean visible = !(this.alpha == 0.0 || metric < this.minMag || this.maxMag >= 0.0 && metric > this.maxMag);
        return visible;
    }

    protected Composite getComposite(Composite currentComposite, double metric) {
        double d;
        double newAlpha = this.alpha;
        if (this.maxMag >= 0.0) {
            double d2;
            double maxMagFadeStart = this.maxMag * (1.0 - this.fadeRange);
            if (metric > d2) {
                newAlpha *= (this.maxMag - metric) / (this.maxMag - maxMagFadeStart);
            }
        }
        double minMagFadeStart = this.minMag * (1.0 + this.fadeRange);
        if (metric < d) {
            newAlpha *= (metric - this.minMag) / (minMagFadeStart - this.minMag);
        }
        if (currentComposite != null && currentComposite instanceof AlphaComposite) {
            newAlpha *= (double)((AlphaComposite)currentComposite).getAlpha();
        }
        if (newAlpha == 1.0) {
            return currentComposite;
        }
        return alphas[(int)(newAlpha * 16.0)];
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        Composite saveComposite = null;
        double metric = 1.0;
        switch (this.fadeType) {
            case 0: {
                metric = renderContext.getCameraMagnification();
                break;
            }
            case 1: {
                metric = renderContext.getCompositeMagnification();
                break;
            }
            case 2: {
                double objSize = Math.max(this.getBounds().getWidth(), this.getBounds().getHeight());
                metric = objSize * renderContext.getCompositeMagnification();
                break;
            }
            case 3: {
                ZBounds cameraView = renderContext.getRenderingCamera().getViewBounds();
                ZBounds nodeBounds = this.editor().getNode().getGlobalBounds();
                double objWidth = ((RectangularShape)nodeBounds).getWidth();
                double objHeight = ((RectangularShape)nodeBounds).getHeight();
                metric = objWidth > objHeight ? objWidth / ((RectangularShape)cameraView).getWidth() : objHeight / ((RectangularShape)cameraView).getHeight();
            }
        }
        if (!this.isVisible(metric)) {
            return;
        }
        if (this.fadeRange > 0.0) {
            saveComposite = g2.getComposite();
            g2.setComposite(this.getComposite(saveComposite, metric));
        }
        super.render(renderContext);
        if (this.fadeRange > 0.0) {
            g2.setComposite(saveComposite);
        }
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (!this.isVisible(path)) {
            return false;
        }
        return super.pick(rect, path);
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.alpha != 1.0) {
            out.writeState("double", "alpha", this.alpha);
        }
        if (this.minMag != 0.0) {
            out.writeState("double", "minMag", this.minMag);
        }
        if (this.maxMag != 1000.0) {
            out.writeState("double", "maxMag", this.maxMag);
        }
        if (this.fadeRange != (double)0.3f) {
            out.writeState("double", "fadeRange", this.fadeRange);
        }
        if (this.fadeType != 0) {
            out.writeState("short", "fadeType", this.fadeType);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("alpha") == 0) {
            this.alpha = (Double)fieldValue;
        } else if (fieldName.compareTo("minMag") == 0) {
            this.minMag = (Double)fieldValue;
        } else if (fieldName.compareTo("maxMag") == 0) {
            this.maxMag = (Double)fieldValue;
        } else if (fieldName.compareTo("fadeRange") == 0) {
            this.fadeRange = (Double)fieldValue;
        } else if (fieldName.compareTo("fadeType") == 0) {
            this.fadeType = (Short)fieldValue;
        }
    }

    static {
        CAMERA_MAG = 0;
        COMPOSITE_MAG = 1;
        ABSOLUTE_SCREEN_SIZE = (short)2;
        PERCENT_OF_CAMERA = (short)3;
        fadeType_DEFAULT = 0;
        alpha_DEFAULT = 1.0;
        minMag_DEFAULT = 0.0;
        maxMag_DEFAULT = 1000.0;
        fadeRange_DEFAULT = 0.3f;
        NUM_ALPHA_LEVELS = 16;
        alphas = null;
        alphas = new Composite[16];
        int i = 0;
        while (i < 16) {
            double value = (double)i / 15.0;
            ZFadeGroup.alphas[i] = AlphaComposite.getInstance(3, (float)value);
            ++i;
        }
    }
}

