/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

class MarqueeRectangle
extends ZRectangle {
    float[] dash = new float[]{1.0f, 1.0f};
    boolean drawing = false;

    MarqueeRectangle() {
    }

    public void setDrawing() {
        this.penWidth = 3.0;
        this.absPenWidth = true;
        this.drawing = true;
    }

    public void unsetDrawing() {
        this.drawing = false;
        this.repaint();
    }

    public void render(ZRenderContext zRenderContext) {
        if (this.drawing) {
            Graphics2D graphics2D = zRenderContext.getGraphics2D();
            double d = this.penWidth / zRenderContext.getCompositeMagnification();
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = this.getStrokeTransformForAbsPenWidth(d);
            double d2 = affineTransform2.getScaleX();
            if (d2 <= 0.0) {
                graphics2D.setPaint(this.penPaint);
                graphics2D.fill(this.getBoundsReference());
                return;
            }
            graphics2D.transform(affineTransform2);
            BasicStroke basicStroke = new BasicStroke((float)(d *= 1.0 / d2), 0, 0, 1.0f, this.dash, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setPaint(this.penPaint);
            graphics2D.draw(this.getShape());
            graphics2D.setTransform(affineTransform);
        }
    }
}

