/*
 * Decompiled with CFR 0.152.
 */
package pm.utilities;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public class PM_XML_Utils
implements PM_Interface {
    public static Document getDocumentFromXMLfile(File file, String string, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if ((n & 0xFFFFFFFD) == 0) {
            bl = true;
        }
        if ((n & 0xFFFFFFFB) == 0) {
            bl2 = true;
        }
        Document document = null;
        if (bl2 && file != null && (!file.exists() || file.length() == 0L)) {
            if (!file.isDirectory()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                PM_Utils.writeErrorExit("Fehler beim Anlegen der Datei " + file.getPath() + ". " + iOException);
            }
            document = DocumentHelper.createDocument();
            document.addElement(string);
            PM_XML_Utils.writeOutDocument(document, file);
            return document;
        }
        if (!file.isFile()) {
            PM_Utils.writeErrorExit(file.getPath() + "  keine Datei");
        }
        if (!file.canRead()) {
            PM_Utils.writeErrorExit(file.getPath() + "  nicht lesbar");
        }
        if (bl && !file.canWrite()) {
            PM_Utils.writeErrorExit(file.getPath() + "  nicht schreibbar");
        }
        SAXReader sAXReader = new SAXReader();
        try {
            document = sAXReader.read(file);
        }
        catch (DocumentException documentException) {
            String string2 = "ERROR: Datei >>" + file.getPath() + "<< nigefu oder ungueltig" + documentException;
            PM_Utils.writeErrorExit(string2);
        }
        return document;
    }

    public static String getAttribute(Element element, String string) {
        Attribute attribute = element.attribute(string);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public static int getAttributeInt(Element element, String string) {
        Attribute attribute = element.attribute(string);
        int n = 0;
        if (attribute == null) {
            return n;
        }
        try {
            n = Integer.parseInt(attribute.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return n;
    }

    public static double getAttributeDouble(Element element, String string) {
        Attribute attribute = element.attribute(string);
        double d = 0.0;
        if (attribute == null) {
            return d;
        }
        try {
            d = Double.parseDouble(attribute.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
        return d;
    }

    public static List getElementListe(Node node, String string) {
        XPath xPath = null;
        try {
            xPath = DocumentHelper.createXPath(string);
        }
        catch (InvalidXPathException invalidXPathException) {
            return new ArrayList();
        }
        return xPath.selectNodes(node);
    }

    public static void writeOutDocument(Document document, File file) {
        Object object;
        XMLWriter xMLWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = OutputFormat.createPrettyPrint();
            ((OutputFormat)object).setEncoding("ISO-8859-1");
            xMLWriter = new XMLWriter(byteArrayOutputStream, (OutputFormat)object);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("ERROR: write: UnsupportedEncodingException" + unsupportedEncodingException);
        }
        try {
            xMLWriter.write(document);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: write: IOException" + iOException);
        }
        object = null;
        try {
            object = new FileWriter(file);
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Open output File >" + file.getPath() + "< gescheitert");
        }
        try {
            ((Writer)object).write(byteArrayOutputStream.toString());
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Fehler beim Schreiben in Datei " + iOException);
        }
    }
}

