/*
 * Decompiled with CFR 0.152.
 */
package pm.utilities;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import pm.gui.PM_IndexView;
import pm.gui.PM_WindowMain;
import pm.gui.PM_WindowRightTabbedPane;
import pm.picture.PM_Picture;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

public class PM_UtilsGrafik
implements PM_Interface {
    public static Image rotate(Image image, int n) {
        switch (n) {
            case 0: {
                return image;
            }
            case 90: {
                return PM_UtilsGrafik.RotateRight(PM_UtilsGrafik.getBufferedImage(image));
            }
            case 180: {
                return PM_UtilsGrafik.RotateDown(PM_UtilsGrafik.getBufferedImage(image));
            }
            case 270: {
                return PM_UtilsGrafik.RotateLeft(PM_UtilsGrafik.getBufferedImage(image));
            }
        }
        return image;
    }

    public static Image spiegeln(Image image) {
        return PM_UtilsGrafik.Spiegeln(PM_UtilsGrafik.getBufferedImage(image));
    }

    public static BufferedImage getBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        return bufferedImage;
    }

    private static BufferedImage RotateLeft(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(270.0));
        affineTransform.translate(bufferedImage.getWidth() * -1, 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    private static BufferedImage RotateDown(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(180.0));
        affineTransform.translate(bufferedImage.getWidth() * -1, bufferedImage.getHeight() * -1);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    private static BufferedImage RotateRight(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(90.0));
        affineTransform.translate(0.0, bufferedImage.getHeight() * -1);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    private static BufferedImage Spiegeln(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(95.0));
        affineTransform.translate(0.0, bufferedImage.getHeight() * -1);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public static Rectangle getImageRectangle(Image image) {
        return new Rectangle(PM_UtilsGrafik.getImageSize(image));
    }

    public static double getRatio(Dimension dimension) {
        return dimension.getWidth() / dimension.getHeight();
    }

    public static double getRatio(Rectangle rectangle) {
        return rectangle.getWidth() / rectangle.getHeight();
    }

    public static double getRatio(Image image) {
        return (double)image.getWidth(null) / (double)image.getHeight(null);
    }

    public static Rectangle rectangle2DToRectangle(Rectangle2D rectangle2D) {
        int n = (int)Math.round(rectangle2D.getX());
        int n2 = (int)Math.round(rectangle2D.getY());
        int n3 = (int)Math.round(rectangle2D.getWidth());
        int n4 = (int)Math.round(rectangle2D.getHeight());
        return new Rectangle(n, n2, n3, n4);
    }

    public static Rectangle getInset(Rectangle rectangle, double d) {
        double d2 = PM_UtilsGrafik.getRatio(rectangle);
        int n = 0;
        int n2 = 0;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        if (d2 < d) {
            n = rectangle.width;
            n2 = (int)((double)n / d);
            n4 += (int)(((double)rectangle.height - (double)n2) / 2.0);
        } else {
            n2 = rectangle.height;
            n = (int)((double)n2 * d);
            n3 += (int)(((double)rectangle.width - (double)n) / 2.0);
        }
        Rectangle rectangle2 = new Rectangle(n3, n4, n, n2);
        return rectangle2;
    }

    public static Rectangle rectangleEinpassen(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.contains(rectangle2)) {
            return rectangle2;
        }
        Point point = PM_UtilsGrafik.getMiddlePoint(rectangle2);
        if (!rectangle.contains(point)) {
            return rectangle2;
        }
        return rectangle2;
    }

    public static Point getMiddlePoint(Rectangle rectangle) {
        return new Point(rectangle.x + (int)(rectangle.getWidth() / 2.0), rectangle.y + (int)(rectangle.getHeight() / 2.0));
    }

    public static Rectangle2D grow(Rectangle2D rectangle2D, Point2D point2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        return new Rectangle2D.Double(d -= point2D.getX(), d2 -= point2D.getY(), d3 += point2D.getX() * 2.0, d4 += point2D.getY() * 2.0);
    }

    public static Rectangle2D rotateRoundMiddlePoint(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = new Rectangle2D.Double();
        ((Rectangle2D)rectangle2D2).setRect(rectangle2D);
        double d = ((RectangularShape)rectangle2D2).getWidth() / 2.0;
        double d2 = ((RectangularShape)rectangle2D2).getHeight() / 2.0;
        rectangle2D2 = PM_UtilsGrafik.grow(rectangle2D2, new Point2D.Double(-d, -d2));
        rectangle2D2 = PM_UtilsGrafik.grow(rectangle2D2, new Point2D.Double(d2, d));
        return rectangle2D2;
    }

    public static boolean istSelbeDarstellung(double d, Rectangle rectangle) {
        return PM_UtilsGrafik.istSelbeDarstellung(d, PM_UtilsGrafik.getRatio(rectangle));
    }

    public static boolean istSelbeDarstellung(Rectangle rectangle, double d) {
        return PM_UtilsGrafik.istSelbeDarstellung(PM_UtilsGrafik.getRatio(rectangle), d);
    }

    public static boolean istSelbeDarstellung(double d, double d2) {
        return d >= 1.0 && d2 >= 1.0 || d < 1.0 && d2 < 1.0;
    }

    public static boolean istSelbeDarstellung(Rectangle rectangle, Rectangle rectangle2) {
        return PM_UtilsGrafik.istSelbeDarstellung(PM_UtilsGrafik.getRatio(rectangle), PM_UtilsGrafik.getRatio(rectangle2));
    }

    public static boolean istSelbeDarstellung(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D.getWidth() / rectangle2D.getHeight();
        double d2 = rectangle2D2.getWidth() / rectangle2D2.getHeight();
        return PM_UtilsGrafik.istSelbeDarstellung(d, d2);
    }

    public static Rectangle2D rotateRectangle(Rectangle2D rectangle2D) {
        rectangle2D.setRect(rectangle2D.getY(), rectangle2D.getX(), rectangle2D.getHeight(), rectangle2D.getWidth());
        return rectangle2D;
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, Rectangle rectangle2, int n) {
        int n2 = 0;
        n2 = n == 90 ? (int)(rectangle.getWidth() / 2.0) : (int)(rectangle.getHeight() / 2.0);
        return PM_UtilsGrafik.rotateRectangle(rectangle2, new Point(n2, n2), n);
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, Point point, int n) {
        int n2 = 0;
        int n3 = 0;
        if (n == 270) {
            n2 = point.x + (rectangle.y - point.y);
            n3 = point.y + (point.x - rectangle.x - rectangle.width);
        } else {
            n2 = point.x + (point.y - rectangle.y - rectangle.height);
            n3 = point.y - (point.x - rectangle.x);
        }
        return new Rectangle(n2, n3, rectangle.height, rectangle.width);
    }

    public static Rectangle changeRatio(Rectangle rectangle, Rectangle rectangle2, double d) {
        Rectangle rectangle3 = new Rectangle(rectangle);
        int n = (int)(rectangle.getHeight() / 2.0);
        double d2 = PM_UtilsGrafik.getRatio(rectangle) / d;
        rectangle3.grow(0, -n);
        rectangle3.grow(0, (int)((double)n * d2));
        Rectangle rectangle4 = new Rectangle(rectangle);
        int n2 = (int)(rectangle.getWidth() / 2.0);
        rectangle4.grow(0, -n2);
        rectangle4.grow(0, (int)((double)n2 * d2));
        if (rectangle2.contains(rectangle3)) {
            return rectangle3;
        }
        return PM_Utils.getDestinationRectangle(rectangle3, rectangle);
    }

    public static Rectangle resizeRectangle(Rectangle rectangle, double d, double d2) {
        rectangle.setRect(rectangle.getX() * d2 / d, rectangle.getY() * d2 / d, rectangle.getWidth() * d2 / d, rectangle.getHeight() * d2 / d);
        return rectangle;
    }

    public static void writeThumbnail(File file, Image image) {
        int n = image.getHeight(null);
        int n2 = image.getWidth(null);
        File file2 = new File(file.getParent());
        try {
            file2.mkdir();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        bufferedImage = PM_UtilsGrafik.getBufferedImage(n2, n);
        graphics2D = PM_UtilsGrafik.getGraphics(bufferedImage);
        graphics2D.drawImage(image, 0, 0, n2, n, null);
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
        }
        catch (IOException iOException) {
            String string = "Fehler: beim Schreiben Thumbnail in Datei " + file.getName();
            System.out.println(string);
            return;
        }
        bufferedImage.flush();
    }

    public static BufferedImage getBufferedImage(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        return bufferedImage;
    }

    public static Graphics2D getGraphics(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        return graphics2D;
    }

    public static Image getBildAusschnitt(Image image, Rectangle rectangle) {
        Image image2 = null;
        CropImageFilter cropImageFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
        image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        try {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image2, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image2;
    }

    public static Rectangle rotateCutRectangle(int n, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = null;
        int n2 = rectangle2.height;
        int n3 = rectangle2.width;
        switch (n) {
            case 90: {
                rectangle3 = new Rectangle(n2 - rectangle.height - rectangle.y, rectangle.x, rectangle.height, rectangle.width);
                break;
            }
            case 270: {
                rectangle3 = new Rectangle(rectangle.y, n3 - rectangle.x - rectangle.width, rectangle.height, rectangle.width);
                break;
            }
            case 180: {
                rectangle3 = new Rectangle(n3 - rectangle.width - rectangle.x, n2 - rectangle.height - rectangle.y, rectangle.width, rectangle.height);
                break;
            }
            default: {
                rectangle3 = rectangle;
            }
        }
        return rectangle3;
    }

    public static Image getScaledImage(Image image, int n, int n2) {
        if (n == 0 || n2 == 0) {
            return image;
        }
        Image image2 = image.getScaledInstance(n, n2, 1);
        try {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image2, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return image2;
    }

    public static Image makeThumbnail(Image image) {
        double d = (double)image.getWidth(null) / (double)image.getHeight(null);
        int n = PM_UtilsGrafik.THUMBNAIL.width;
        int n2 = PM_UtilsGrafik.THUMBNAIL.height;
        if (d > 0.0) {
            n = (int)((double)n2 * d);
        } else {
            n2 = (int)((double)n * d);
        }
        return PM_UtilsGrafik.getScaledImage(image, n, n2);
    }

    public static void getRightPanelOverThumbs(JPanel jPanel) {
        JButton jButton = PM_Utils.getJButon("1leftarrow.png");
        jPanel.add(jButton);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_IndexView pM_IndexView = PM_WindowMain.getInstance().getIndexViewWindowRight();
                PM_IndexView pM_IndexView2 = PM_WindowMain.getInstance().getIndexViewThumbnails();
                if (pM_IndexView != null) {
                    if (pM_IndexView.sizeDargestellt() == 0) {
                        return;
                    }
                    List<PM_Picture> list = pM_IndexView.getPictureListDarstellen();
                    pM_IndexView2.setAndPaintPictureList(list);
                    pM_IndexView2.repaintViewport();
                }
            }
        };
        jButton.addActionListener(actionListener);
        JButton jButton2 = PM_Utils.getJButon("2leftarrow.png");
        jPanel.add(jButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_IndexView pM_IndexView = PM_WindowMain.getInstance().getIndexViewWindowRight();
                PM_IndexView pM_IndexView2 = PM_WindowMain.getInstance().getIndexViewThumbnails();
                if (pM_IndexView != null) {
                    if (pM_IndexView.sizeDargestellt() == 0) {
                        return;
                    }
                    List<PM_Picture> list = pM_IndexView.getPictureListDarstellen();
                    pM_IndexView2.appendPictureList(list);
                    pM_IndexView2.repaintViewport();
                }
            }
        };
        jButton2.addActionListener(actionListener2);
        JButton jButton3 = PM_Utils.getJButon("button_cancel.png");
        jPanel.add(jButton3);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowRightTabbedPane pM_WindowRightTabbedPane = PM_WindowMain.getInstance().getWindowRechts();
                pM_WindowRightTabbedPane.getWindowSelected().removeAllThumbs();
                PM_WindowMain.getInstance().getIndexViewThumbnails().repaintViewport();
            }
        };
        jButton3.addActionListener(actionListener3);
        JButton jButton4 = PM_Utils.getJButon("rebuild.png");
        jPanel.add(jButton4);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowRightTabbedPane pM_WindowRightTabbedPane = PM_WindowMain.getInstance().getWindowRechts();
                pM_WindowRightTabbedPane.getWindowSelected().rereadAllThumbs();
            }
        };
        jButton4.addActionListener(actionListener4);
    }

    public static BufferedImage getBufferedImage(Image image, Rectangle rectangle, Dimension dimension, double d) {
        BufferedImage bufferedImage = new BufferedImage((int)((double)image.getWidth(null) * d), (int)((double)image.getHeight(null) * d), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d);
        graphics2D.drawImage(image, affineTransform, null);
        if (rectangle == null) {
            return bufferedImage;
        }
        Graphics2D graphics2D2 = PM_UtilsGrafik.getGraphics(bufferedImage);
        double d2 = (double)image.getWidth(null) / dimension.getWidth();
        double d3 = (double)image.getHeight(null) / dimension.getHeight();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.scale(d2, d3);
        affineTransform2.scale(d, d);
        Color color = graphics2D2.getColor();
        graphics2D2.setTransform(affineTransform2);
        graphics2D2.setColor(Color.YELLOW);
        graphics2D2.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D2.setColor(color);
        return bufferedImage;
    }

    public static Point2D.Double getMovePoint(int n, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        switch (n) {
            case 90: {
                d3 = d2;
                break;
            }
            case 180: {
                d3 = d;
                d4 = d2;
                break;
            }
            case 270: {
                d4 = d;
            }
        }
        return new Point2D.Double(d3, d4);
    }
}

