/*
 * Decompiled with CFR 0.152.
 */
package pm.search;

import java.awt.Font;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureMetadaten;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;

public class PM_LuceneLists
implements PM_Interface {
    private static PM_LuceneLists luceneIndexInstance = null;
    private SortedSet<String> sortedIndex = new TreeSet<String>();
    private SortedSet<String> sortedOrt = new TreeSet<String>();
    private Vector<PM_Listener> alleListener = new Vector();
    private PM_Listener metadatenChangeListener = new PM_Listener(){

        public void actionPerformed(PM_Action pM_Action) {
            if (pM_Action.getObject() instanceof PM_Picture) {
                PM_Picture pM_Picture = (PM_Picture)pM_Action.getObject();
                int n = pM_Action.getType();
                if (n == 10) {
                    PM_LuceneLists.this.updateIndex(pM_Picture.meta.getIndex1());
                }
                if (n == 20) {
                    PM_LuceneLists.this.updateOrt(pM_Picture.meta.getIndex2());
                }
            }
        }
    };

    public static PM_LuceneLists getInstance() {
        if (luceneIndexInstance == null) {
            luceneIndexInstance = new PM_LuceneLists();
        }
        return luceneIndexInstance;
    }

    private PM_LuceneLists() {
        PM_PictureMetadaten.addChangeListener(this.metadatenChangeListener);
    }

    public void addIndex(String string) {
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortedIndex.add(" " + stringArray[i].trim().toLowerCase());
        }
    }

    public void addOrt(String string) {
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortedOrt.add(" " + stringArray[i].trim().toLowerCase());
        }
    }

    public String[] getSortedIndex() {
        return this.sortedIndex.toArray(new String[this.sortedIndex.size()]);
    }

    public String[] getSortedOrt() {
        return this.sortedOrt.toArray(new String[this.sortedOrt.size()]);
    }

    public void addListener(PM_Listener pM_Listener) {
        if (!this.alleListener.contains(pM_Listener)) {
            this.alleListener.add(pM_Listener);
        }
    }

    public Font getFont(Font font) {
        Font font2 = new Font("monospaced", 0, font.getSize() + 1);
        return font2;
    }

    public void fireAllListener() {
        this.fireListenerPrivate();
    }

    private void updateIndex(String string) {
        String[] stringArray = string.split(" ");
        int n = this.sortedIndex.size();
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortedIndex.add(" " + stringArray[i].trim());
        }
        if (n == this.sortedIndex.size()) {
            return;
        }
        this.fireListenerPrivate();
    }

    private void updateOrt(String string) {
        String[] stringArray = string.split(" ");
        int n = this.sortedOrt.size();
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortedOrt.add(" " + stringArray[i].trim());
        }
        if (n == this.sortedOrt.size()) {
            return;
        }
        this.fireListenerPrivate();
    }

    private void fireListenerPrivate() {
        for (int i = 0; i < this.alleListener.size(); ++i) {
            PM_Listener pM_Listener = this.alleListener.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(this.sortedIndex));
        }
    }
}

