/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowMain;
import pm.inout.PM_All_InitValues;
import pm.inout.PM_Export;
import pm.inout.PM_ExportChanged;
import pm.inout.PM_ExportDelete;
import pm.inout.PM_ExportUnchanged;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;
import pm.utilities.PM_UtilsGrafik;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowExport
extends PM_WindowBase
implements PM_Interface {
    private JPanel panelLeft = null;
    private JPanel panelRight = null;
    private PM_Configuration einstellungen = null;
    private JSplitPane splitPane = null;
    private final Color colorRight = Color.YELLOW;
    private Border border;
    private Vector<PM_Listener> exportDeleteListener = new Vector();
    private Vector<String> seitenVerhaeltnisse = new Vector();
    private Vector<String> resolutions = new Vector();
    private JSpinner overscanX = null;
    private JSpinner overscanY = null;
    private JCheckBox testOverscanColor = null;
    private JButton buttonDelete;
    private JButton buttonExport;
    private JRadioButton ausgabeNameUnveraendert = null;
    private JRadioButton ausgabeNameVeraendert = null;
    private JTextField ausgabeBildName = null;
    private JTextField lfdNummer = null;
    private JCheckBox mitMetadaten = null;
    private JLabel labelExportDirectory;
    private JLabel labelNewBaseName;
    private JLabel labelStartNumber;
    private int ident = 30;
    private JCheckBox checkBoxCut = null;
    private JCheckBox checkBoxRotateMirror = null;
    private JCheckBox checkBoxRatio = null;
    private JCheckBox checkBoxSolution = null;
    private JComboBox cbAufloesung = null;
    private JCheckBox checkBoxOverscan = null;
    private JCheckBox checkBoxPicText = null;
    private JCheckBox transparent = null;
    private JRadioButton eigenUnveraendert = null;
    private JRadioButton eigenVeraendert = null;
    private JComboBox cbSeite = null;
    private JButton buttonColorBG = null;
    private Color colorBG = Color.RED;
    private JButton buttonColorFG = null;
    private Color colorFG = Color.BLACK;
    private JLabel labelTestFgBg = null;
    private TitledBorder titleOutput;
    private TitledBorder titleProperties;
    private JLabel labelColorFG;
    private JLabel labelTransparent;
    private String neuerBildName = "";
    private String neueLfdNummer = "";

    public PM_WindowExport(PM_WindowMain pM_WindowMain, int n) {
        super(pM_WindowMain, n, true);
        this.border = BorderFactory.createLineBorder(Color.GRAY, 3);
        this.setLayout(new BorderLayout());
        this.einstellungen = PM_Configuration.getInstance();
        this.getIndexView().setAllowGetFromRight(true);
        this.getIndexView().setPopUpLoeschen(true);
        this.getIndexView().setPopUpLoeschenAufheben(true);
        this.getIndexView().setPopUpAendern(true);
        this.getIndexView().setPopUpDiaShow(true);
        this.getIndexView().setTextAufloesung(true);
        this.panelLeft = new JPanel();
        this.panelLeft.setLayout(new BorderLayout());
        JPanel jPanel = this.getPanelUpperLeft();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(21);
        this.panelLeft.add((Component)jScrollPane, "North");
        this.panelLeft.add((Component)this.indexViewScrollPane, "Center");
        this.panelLeft.add((Component)this.getIndexView().getSlider(), "South");
        this.panelRight = this.getPanelRight();
        this.panelRight.setBackground(this.colorRight);
        JScrollPane jScrollPane2 = new JScrollPane(this.panelRight);
        this.splitPane = new JSplitPane(1, this.panelLeft, jScrollPane2);
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "vertical-devider");
        if (n2 == 0) {
            n2 = 200;
        }
        this.splitPane.setDividerLocation(n2);
        this.add(this.splitPane);
        this.doEigenUnveraendert();
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowExport.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.buttonDelete.setText(PM_MSG.getMsg("winExpButtonDelete"));
        this.buttonExport.setText(PM_MSG.getMsg("winExpButtonExport"));
        this.titleOutput.setTitle(PM_MSG.getMsg("winExpTitleOutput"));
        this.labelExportDirectory.setText(PM_MSG.getMsg("winExpOutDir"));
        this.mitMetadaten.setText(PM_MSG.getMsg("winExpOutMeta"));
        this.ausgabeNameUnveraendert.setText(PM_MSG.getMsg("winExpOutUnchng"));
        this.ausgabeNameVeraendert.setText(PM_MSG.getMsg("winExpOutChng"));
        this.labelNewBaseName.setText(PM_MSG.getMsg("winExpOutBaseName"));
        this.labelStartNumber.setText(PM_MSG.getMsg("winExpOutStartNr"));
        this.titleProperties.setTitle(PM_MSG.getMsg("winExpTitleProperties"));
        this.eigenUnveraendert.setText(PM_MSG.getMsg("winExpCBnotChanged"));
        this.eigenVeraendert.setText(PM_MSG.getMsg("winExpCBchanged"));
        this.checkBoxCut.setText(PM_MSG.getMsg("winExpCBcut"));
        this.checkBoxRatio.setText(PM_MSG.getMsg("winExpCBratio"));
        this.checkBoxRotateMirror.setText(PM_MSG.getMsg("winExpCBrotate"));
        this.checkBoxSolution.setText(PM_MSG.getMsg("winExpCBsolution"));
        this.checkBoxPicText.setText(PM_MSG.getMsg("winExpCBtext"));
        this.labelColorFG.setText(PM_MSG.getMsg("winExpCBtextColor"));
        this.buttonColorFG.setText(PM_MSG.getMsg("winExpCBtextFG"));
        this.buttonColorBG.setText(PM_MSG.getMsg("winExpCBtextBG"));
        this.labelTestFgBg.setText(PM_MSG.getMsg("winExpCBtextFont"));
        this.labelTransparent.setText(PM_MSG.getMsg("winExpCBtextTrans"));
        this.checkBoxOverscan.setText(PM_MSG.getMsg("winExpCBoverscan"));
    }

    @Override
    public boolean requestToChange() {
        return true;
    }

    @Override
    public void close() {
        PM_All_InitValues.getInstance().putValueInt(this, "color-fg", this.colorFG.getRGB());
        PM_All_InitValues.getInstance().putValueInt(this, "color-bg", this.colorBG.getRGB());
        PM_All_InitValues.getInstance().putValueBoolean(this, "transparent", this.getTransparent());
        PM_All_InitValues.getInstance().putValueInt(this, "overscanX", this.getOverscanValueX());
        PM_All_InitValues.getInstance().putValueInt(this, "overscanY", this.getOverscanValueY());
        PM_All_InitValues.getInstance().putValueInt(this, "vertical-devider", this.splitPane.getDividerLocation());
    }

    public boolean getOverscan() {
        return this.checkBoxOverscan.isSelected();
    }

    public int getOverscanValueX() {
        Object object = this.overscanX.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public int getOverscanValueY() {
        Object object = this.overscanY.getValue();
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public double getResolution() {
        if (!this.checkBoxSolution.isSelected()) {
            return 0.0;
        }
        double d = 1000000.0;
        int n = this.cbAufloesung.getSelectedIndex();
        if (n <= 0) {
            return 0.0;
        }
        String string = this.resolutions.elementAt(n);
        if (string.indexOf("hoch") >= 0) {
            return 3.0 * d;
        }
        if (string.indexOf("mittel") >= 0) {
            return 1.0 * d;
        }
        if (string.indexOf("niedrig") >= 0) {
            return 0.4 * d;
        }
        return 0.0;
    }

    private Vector getAufloesungen() {
        this.resolutions = new Vector();
        this.resolutions.add("unver\u00e4ndert");
        this.resolutions.add("hoch    (3 MegaPixel");
        this.resolutions.add("mittel  (1 MegaPixel");
        this.resolutions.add("niedrig (0,4 MegaPixel");
        return this.resolutions;
    }

    public Color getForgroundColor() {
        return this.colorFG;
    }

    public Color getBackgroundColor() {
        return this.colorBG;
    }

    public boolean getTestOverscancolor() {
        return this.testOverscanColor.isSelected();
    }

    public boolean getRotate() {
        return this.checkBoxRotateMirror.isSelected();
    }

    public boolean getCut() {
        return this.checkBoxCut.isSelected();
    }

    public boolean getTransparent() {
        return this.transparent.isSelected();
    }

    public boolean getTextOnPicture() {
        return this.checkBoxPicText.isSelected();
    }

    public void addExportDeleteListener(PM_Listener pM_Listener) {
        if (!this.exportDeleteListener.contains(pM_Listener)) {
            this.exportDeleteListener.add(pM_Listener);
        }
    }

    public void fireExportDeleteListener() {
        for (int i = 0; i < this.exportDeleteListener.size(); ++i) {
            PM_Listener pM_Listener = this.exportDeleteListener.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(this));
        }
    }

    private JPanel getPanelUpperLeft() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.YELLOW);
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel.add(jPanel2);
        PM_UtilsGrafik.getRightPanelOverThumbs(jPanel2);
        this.buttonDelete = new JButton("Bilder L\u00f6schen");
        jPanel2.add(this.buttonDelete);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.doDeleteIrreversible();
            }
        };
        this.buttonDelete.addActionListener(actionListener);
        return jPanel;
    }

    private JPanel getPanelRight() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.colorRight);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Color.YELLOW);
        jPanel2.setLayout(new FlowLayout(0));
        this.buttonExport = new JButton("Bilder exportieren");
        jPanel2.add(this.buttonExport);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.doExport();
            }
        };
        this.buttonExport.addActionListener(actionListener);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.getGroupOutput());
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.getGroupProperties());
        return jPanel;
    }

    private JPanel getGroupOutput() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(this.colorRight);
        this.labelExportDirectory = new JLabel("Export-Verzeichnis:");
        jPanel.add(this.labelExportDirectory);
        JTextField jTextField = new JTextField(this.einstellungen.getFileHomeTemp().getPath());
        jTextField.setColumns(22);
        jPanel.add(jTextField);
        JButton jButton = new JButton("...");
        jButton.setEnabled(false);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.mitMetadaten = new JCheckBox("mit Metadaten");
        jPanel2.setBackground(this.colorRight);
        jPanel2.add(this.mitMetadaten);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setBackground(this.colorRight);
        this.ausgabeNameUnveraendert = new JRadioButton("Namen der Bilder (Filename) unver\u00e4ndert");
        this.ausgabeNameUnveraendert.setBackground(this.colorRight);
        this.ausgabeNameUnveraendert.setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.setPictureNamesChanged(false);
            }
        };
        this.ausgabeNameUnveraendert.addActionListener(actionListener);
        jPanel3.add(this.ausgabeNameUnveraendert);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.setBackground(this.colorRight);
        this.ausgabeNameVeraendert = new JRadioButton("Namen der Bilder (Filename) neu vergeben");
        this.ausgabeNameVeraendert.setBackground(this.colorRight);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.setPictureNamesChanged(true);
            }
        };
        this.ausgabeNameVeraendert.addActionListener(actionListener2);
        jPanel4.add(this.ausgabeNameVeraendert);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ausgabeNameUnveraendert);
        buttonGroup.add(this.ausgabeNameVeraendert);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(Box.createHorizontalStrut(30));
        jPanel5.setBackground(this.colorRight);
        this.labelNewBaseName = new JLabel("neuer (Basis-)Name:");
        jPanel5.add(this.labelNewBaseName);
        this.ausgabeBildName = new JTextField(" ");
        this.ausgabeBildName.setEnabled(false);
        this.ausgabeBildName.setBackground(Color.LIGHT_GRAY);
        jPanel5.add(Box.createHorizontalStrut(5));
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                PM_WindowExport.this.neuerBildName = PM_WindowExport.this.ausgabeBildName.getText();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        };
        this.ausgabeBildName.addKeyListener(keyListener);
        this.ausgabeBildName.setColumns(15);
        jPanel5.add(this.ausgabeBildName);
        this.labelStartNumber = new JLabel("+ lfd.Nummer");
        jPanel5.add(this.labelStartNumber);
        this.lfdNummer = new JTextField("001");
        this.lfdNummer.setColumns(5);
        this.lfdNummer.setEnabled(false);
        this.lfdNummer.setBackground(Color.LIGHT_GRAY);
        jPanel5.add(this.lfdNummer);
        KeyListener keyListener2 = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = PM_WindowExport.this.lfdNummer.getText().trim();
                if (string.length() == 0) {
                    PM_WindowExport.this.neueLfdNummer = "";
                    return;
                }
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    PM_WindowExport.this.lfdNummer.setText(PM_WindowExport.this.neueLfdNummer);
                    return;
                }
                PM_WindowExport.this.neueLfdNummer = PM_WindowExport.this.lfdNummer.getText();
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.lfdNummer.addKeyListener(keyListener2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBackground(this.colorRight);
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentY(0.0f);
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.titleOutput = BorderFactory.createTitledBorder(this.border, "Ausgabe");
        jPanel6.setBorder(this.titleOutput);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.setBackground(this.colorRight);
        jPanel7.add(jPanel6);
        return jPanel7;
    }

    private JPanel getGroupProperties() {
        int n = PM_All_InitValues.getInstance().getValueInt(this, "color-fg");
        int n2 = PM_All_InitValues.getInstance().getValueInt(this, "color-bg");
        if (n != 0) {
            this.colorFG = new Color(n);
        }
        if (n2 != 0) {
            this.colorBG = new Color(n2);
        }
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(this.colorRight);
        this.eigenUnveraendert = new JRadioButton("Bilder unver\u00e4ndert exportieren");
        this.eigenUnveraendert.setBackground(this.colorRight);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.doEigenUnveraendert();
            }
        };
        this.eigenUnveraendert.addActionListener(actionListener);
        jPanel.add(this.eigenUnveraendert);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBackground(this.colorRight);
        this.eigenVeraendert = new JRadioButton("Bilder in dieser Reihenfolge ver\u00e4ndern:");
        this.eigenVeraendert.setBackground(this.colorRight);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.doEigenVeraendert();
            }
        };
        this.eigenVeraendert.addActionListener(actionListener2);
        jPanel2.add(this.eigenVeraendert);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBackground(this.colorRight);
        jPanel3.add(Box.createHorizontalStrut(this.ident));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel3.add(jPanel4);
        jPanel4.setBackground(this.colorRight);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.setBackground(this.colorRight);
        jPanel5.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxCut = new JCheckBox("ausschneiden");
        this.checkBoxCut.setBackground(this.colorRight);
        jPanel5.add(this.checkBoxCut);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExport.this.eigenVeraendert.isSelected()) {
                    PM_WindowExport.this.doEigenVeraendert();
                }
            }
        };
        this.checkBoxCut.addActionListener(actionListener3);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.setBackground(this.colorRight);
        jPanel6.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxRatio = new JCheckBox("Seitenverh\u00e4ltnis:");
        jPanel6.add(this.checkBoxRatio);
        this.checkBoxRatio.setEnabled(false);
        jPanel6.setBackground(this.colorRight);
        this.cbSeite = new JComboBox<String>(this.getSeitenVerhaeltnisse());
        ComboBoxListener comboBoxListener = new ComboBoxListener();
        this.cbSeite.addActionListener(comboBoxListener);
        this.cbSeite.setEnabled(false);
        jPanel6.add(this.cbSeite);
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.setBackground(this.colorRight);
        jPanel7.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxRotateMirror = new JCheckBox("drehen/spiegeln");
        this.checkBoxRotateMirror.setBackground(this.colorRight);
        jPanel7.add(this.checkBoxRotateMirror);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExport.this.eigenVeraendert.isSelected()) {
                    PM_WindowExport.this.doEigenVeraendert();
                }
            }
        };
        this.checkBoxRotateMirror.addActionListener(actionListener4);
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        jPanel8.setBackground(this.colorRight);
        jPanel8.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxSolution = new JCheckBox("Aufl\u00f6sung:");
        jPanel8.add(this.checkBoxSolution);
        this.cbAufloesung = new JComboBox(this.getAufloesungen());
        this.cbAufloesung.setEnabled(false);
        jPanel8.add(this.cbAufloesung);
        int n3 = this.ident + 30;
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        jPanel9.setBackground(this.colorRight);
        jPanel9.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxPicText = new JCheckBox("Bildunterschrift:");
        this.checkBoxPicText.setBackground(this.colorRight);
        jPanel9.add(this.checkBoxPicText);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        jPanel10.setBackground(this.colorRight);
        jPanel10.add(Box.createHorizontalStrut(n3));
        this.labelColorFG = new JLabel("Textfarben: ");
        jPanel10.add(this.labelColorFG);
        this.buttonColorFG = new JButton("Schrift");
        jPanel10.add(this.buttonColorFG);
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "W\u00e4hle Schriftfarbe", PM_WindowExport.this.colorFG);
                if (color != null) {
                    PM_WindowExport.this.colorFG = color;
                }
                PM_WindowExport.this.labelTestFgBg.setForeground(PM_WindowExport.this.colorFG);
            }
        };
        this.buttonColorFG.addActionListener(actionListener5);
        this.buttonColorBG = new JButton("Hintergrund");
        jPanel10.add(this.buttonColorBG);
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "W\u00e4hle Hintergrundfarbe", PM_WindowExport.this.colorBG);
                if (color != null) {
                    PM_WindowExport.this.colorBG = color;
                }
                PM_WindowExport.this.labelTestFgBg.setBackground(PM_WindowExport.this.colorBG);
            }
        };
        this.buttonColorBG.addActionListener(actionListener6);
        this.labelTestFgBg = new JLabel("Schrift");
        this.labelTestFgBg.setOpaque(true);
        this.labelTestFgBg.setForeground(this.colorFG);
        this.labelTestFgBg.setBackground(this.colorBG);
        jPanel10.add(this.labelTestFgBg);
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        jPanel11.setBackground(this.colorRight);
        jPanel11.add(Box.createHorizontalStrut(n3));
        this.transparent = new JCheckBox();
        boolean bl = PM_All_InitValues.getInstance().getValueBoolean(this, "transparent");
        this.transparent.setSelected(bl);
        this.labelTransparent = new JLabel("Hintergrund transparent");
        jPanel11.add(this.labelTransparent);
        jPanel11.add(this.transparent);
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PM_WindowExport.this.transparent.isSelected()) {
                    PM_WindowExport.this.buttonColorBG.setEnabled(false);
                    PM_WindowExport.this.labelTestFgBg.setBackground(PM_WindowExport.this.colorRight);
                } else {
                    PM_WindowExport.this.buttonColorBG.setEnabled(true);
                    PM_WindowExport.this.labelTestFgBg.setBackground(PM_WindowExport.this.colorBG);
                }
            }
        };
        this.transparent.addActionListener(actionListener7);
        JPanel jPanel12 = new JPanel(new FlowLayout(0));
        jPanel12.setBackground(this.colorRight);
        jPanel12.add(Box.createHorizontalStrut(this.ident));
        this.checkBoxOverscan = new JCheckBox("Overscan ");
        this.checkBoxOverscan.setBackground(this.colorRight);
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowExport.this.testOverscanColor.setEnabled(PM_WindowExport.this.checkBoxOverscan.isSelected());
                PM_WindowExport.this.overscanX.setEnabled(PM_WindowExport.this.checkBoxOverscan.isSelected());
                PM_WindowExport.this.overscanY.setEnabled(PM_WindowExport.this.checkBoxOverscan.isSelected());
            }
        };
        this.checkBoxOverscan.addActionListener(actionListener8);
        jPanel12.add(this.checkBoxOverscan);
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        jPanel13.setBackground(this.colorRight);
        jPanel13.add(new JLabel("X"));
        int n4 = 0;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, n4, n4 + 50, 1);
        this.overscanX = new JSpinner(spinnerNumberModel);
        jPanel13.add(this.overscanX);
        jPanel13.add(new JLabel("Y"));
        int n5 = 0;
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(n5, n5, n5 + 50, 1);
        this.overscanY = new JSpinner(spinnerNumberModel2);
        jPanel13.add(this.overscanY);
        jPanel13.add(new JLabel("Test"));
        this.testOverscanColor = new JCheckBox();
        jPanel13.add(this.testOverscanColor);
        jPanel12.add(jPanel13);
        int n6 = PM_All_InitValues.getInstance().getValueInt(this, "overscanX");
        int n7 = PM_All_InitValues.getInstance().getValueInt(this, "overscanY");
        this.overscanX.setValue(n6);
        this.overscanY.setValue(n7);
        this.eigenUnveraendert.setSelected(true);
        this.checkBoxCut.setEnabled(false);
        this.checkBoxCut.setEnabled(false);
        this.checkBoxRatio.setEnabled(false);
        this.checkBoxRotateMirror.setEnabled(false);
        this.checkBoxSolution.setEnabled(false);
        this.checkBoxPicText.setEnabled(false);
        this.checkBoxOverscan.setEnabled(false);
        JPanel jPanel14 = new JPanel();
        jPanel14.setBackground(this.colorRight);
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        jPanel14.setAlignmentY(0.0f);
        jPanel14.add(jPanel);
        jPanel14.add(jPanel2);
        jPanel14.add(jPanel5);
        jPanel14.add(jPanel6);
        jPanel14.add(jPanel7);
        jPanel14.add(jPanel8);
        jPanel14.add(jPanel9);
        jPanel14.add(jPanel10);
        jPanel14.add(jPanel11);
        jPanel14.add(jPanel12);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.eigenUnveraendert);
        buttonGroup.add(this.eigenVeraendert);
        this.titleProperties = BorderFactory.createTitledBorder(this.border, "Eigenschaften");
        jPanel14.setBorder(this.titleProperties);
        JPanel jPanel15 = new JPanel(new FlowLayout(0));
        jPanel15.setBackground(this.colorRight);
        jPanel15.add(jPanel14);
        return jPanel15;
    }

    private void setPictureNamesChanged(boolean bl) {
        if (bl) {
            this.ausgabeBildName.setText(this.neuerBildName);
            this.ausgabeBildName.setBackground(Color.WHITE);
            this.lfdNummer.setText(this.neueLfdNummer);
            if (PM_Utils.stringToInt(this.neueLfdNummer) == 0) {
                this.lfdNummer.setText("0001");
            }
            this.lfdNummer.setBackground(Color.WHITE);
        } else {
            this.ausgabeBildName.setText("");
            this.ausgabeBildName.setBackground(Color.LIGHT_GRAY);
            this.neueLfdNummer = this.lfdNummer.getText().trim();
            this.lfdNummer.setText("");
            this.lfdNummer.setBackground(Color.LIGHT_GRAY);
        }
        this.ausgabeBildName.setEnabled(bl);
        this.lfdNummer.setEnabled(bl);
    }

    private void setPictureChanged(boolean bl) {
        this.checkBoxCut.setEnabled(bl);
        this.checkBoxRatio.setEnabled(bl);
        this.checkBoxRotateMirror.setEnabled(bl);
        this.checkBoxSolution.setEnabled(bl);
        this.checkBoxPicText.setEnabled(bl);
        this.checkBoxOverscan.setEnabled(bl);
        if (bl) {
            this.overscanX.setEnabled(this.checkBoxOverscan.isSelected());
            this.overscanY.setEnabled(this.checkBoxOverscan.isSelected());
        }
        this.cbAufloesung.setEnabled(bl);
        this.cbSeite.setEnabled(bl);
        this.buttonColorFG.setEnabled(bl);
        this.buttonColorBG.setEnabled(bl);
    }

    private void doExport() {
        List<PM_Picture> list = this.getIndexView().getPictureListDarstellen();
        if (list.isEmpty()) {
            return;
        }
        PM_Export pM_Export = null;
        if (this.eigenUnveraendert.isSelected()) {
            pM_Export = new PM_ExportUnchanged(this.windowMain, this);
        }
        if (this.eigenVeraendert.isSelected()) {
            pM_Export = new PM_ExportChanged(this.windowMain, this);
        }
        if (pM_Export == null) {
            return;
        }
        if (this.ausgabeNameVeraendert.isSelected()) {
            pM_Export.setBildName(this.ausgabeBildName.getText());
            pM_Export.setStartLfdBildNummer(PM_Utils.stringToInt(this.lfdNummer.getText()));
        }
        pM_Export.setMitMetadaten(this.mitMetadaten.isSelected());
        pM_Export.schreibenBilder(list);
    }

    private void doDeleteIrreversible() {
        List<PM_Picture> list = this.getIndexView().getPictureListDarstellen();
        if (list.isEmpty()) {
            return;
        }
        if (!this.windowMain.getWindowRechts().getWindowSequenz().requestToClose()) {
            return;
        }
        String string = String.format(PM_MSG.getMsg("winExpDialogDel"), list.size());
        int n = JOptionPane.showConfirmDialog(this, string, PM_MSG.getMsg("winExpDialogMsg"), 0, 3);
        if (n == 1) {
            return;
        }
        PM_MetadataContainer.getInstance().flush();
        PM_DatabaseLucene.getInstance().flush();
        PM_SequencesInout.getInstance().flush();
        PM_ExportDelete pM_ExportDelete = new PM_ExportDelete(this.windowMain, this);
        pM_ExportDelete.deletePictures(list);
        String string2 = String.format(PM_MSG.getMsg("winExpDialogDelEnd"), list.size());
        JOptionPane.showConfirmDialog(null, string2, PM_MSG.getMsg("winExpDialogMsg"), -1, 1);
        this.windowMain.rereadAllThumbs();
        PM_MetadataContainer.getInstance().flush();
        PM_DatabaseLucene.getInstance().flush();
        PM_SequencesInout.getInstance().flush();
        pM_ExportDelete.fireDeleteListener(null);
    }

    private Vector<String> getSeitenVerhaeltnisse() {
        this.seitenVerhaeltnisse = new Vector();
        this.seitenVerhaeltnisse.add("unver\u00e4ndert");
        return this.seitenVerhaeltnisse;
    }

    public double getSeitenVerhaeltniss() {
        int n = this.cbSeite.getSelectedIndex();
        if (n <= 0) {
            return 0.0;
        }
        String string = this.seitenVerhaeltnisse.elementAt(n);
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            return 0.0;
        }
        int n2 = PM_Utils.stringToInt(stringArray[0].trim());
        int n3 = PM_Utils.stringToInt(stringArray[1].trim());
        if (n2 == 0 || n3 == 0) {
            return 0.0;
        }
        double d = (double)n3 / (double)n2;
        return d;
    }

    private void doEigenUnveraendert() {
        this.setPictureChanged(false);
        this.getIndexView().setDrehenAusschneiden(false);
        this.getIndexView().setGlobalCutSize(0.0);
        this.getIndexView().setPaintBildText(false);
        this.getIndexView().repaintViewport();
    }

    private void doEigenVeraendert() {
        this.setPictureChanged(true);
        this.getIndexView().setAusschneiden(this.checkBoxCut.isSelected());
        this.getIndexView().setDrehenSpiegeln(this.checkBoxRotateMirror.isSelected());
        this.getIndexView().setGlobalCutSize(this.getSeitenVerhaeltniss());
        this.getIndexView().setPaintBildText(this.checkBoxPicText.isSelected());
        this.getIndexView().rereadAllPictureViewThumbnail();
    }

    class ComboBoxListener
    implements ActionListener {
        ComboBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PM_WindowExport.this.eigenVeraendert.isSelected()) {
                PM_WindowExport.this.doEigenVeraendert();
            }
        }
    }
}

