/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.NullOutputStream;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import junit.framework.TestCase;

public class MetadataTest
extends TestCase {
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$GpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;

    public MetadataTest(String string) {
        super(string);
    }

    public void testSetAndGetSingleTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        directory.setInt(37378, 1);
        MetadataTest.assertEquals((int)1, (int)directory.getInt(37378));
    }

    public void testSetSameTagMultpleTimes() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        directory.setInt(37378, 1);
        directory.setInt(37378, 2);
        MetadataTest.assertEquals((String)"setting the tag with a different value should override old value", (int)2, (int)directory.getInt(37378));
    }

    public void testGetDirectory() throws Exception {
        Metadata metadata = new Metadata();
        MetadataTest.assertTrue((boolean)(metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory) instanceof ExifDirectory));
    }

    public void testSetAndGetMultipleTagsInSingleDirectory() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        directory.setString(37378, "Tag Value");
        directory.setString(33423, "Another tag");
        MetadataTest.assertEquals((String)"Tag Value", (String)directory.getString(37378));
        MetadataTest.assertEquals((String)"Another tag", (String)directory.getString(33423));
    }

    public void testSetAndGetMultipleTagsInMultilpeDirectories() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        Directory directory2 = metadata.getDirectory(class$com$drew$metadata$exif$GpsDirectory == null ? (class$com$drew$metadata$exif$GpsDirectory = MetadataTest.class$("com.drew.metadata.exif.GpsDirectory")) : class$com$drew$metadata$exif$GpsDirectory);
        directory.setString(37378, "ExifAperture");
        directory.setString(33423, "ExifBatteryLevel");
        directory2.setString(6, "GpsAltitude");
        directory2.setString(24, "GpsDestBearing");
        MetadataTest.assertEquals((String)"ExifAperture", (String)directory.getString(37378));
        MetadataTest.assertEquals((String)"ExifBatteryLevel", (String)directory.getString(33423));
        MetadataTest.assertEquals((String)"GpsAltitude", (String)directory2.getString(6));
        MetadataTest.assertEquals((String)"GpsDestBearing", (String)directory2.getString(24));
    }

    public void testContainsTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        MetadataTest.assertTrue((!directory.containsTag(37378) ? 1 : 0) != 0);
        directory.setString(37378, "Tag Value");
        MetadataTest.assertTrue((boolean)directory.containsTag(37378));
    }

    public void testGetNonExistantTag() throws Exception {
        Metadata metadata = new Metadata();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        MetadataTest.assertEquals(null, (String)directory.getString(37378));
    }

    public void testHasErrors() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        MetadataTest.assertTrue((String)"exif error", (boolean)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).hasErrors());
        metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/withExif.jpg"));
        MetadataTest.assertTrue((String)"no errors", (!metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).hasErrors() ? 1 : 0) != 0);
    }

    public void testGetErrors() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        Iterator iterator = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).getErrors();
        MetadataTest.assertTrue((boolean)iterator.hasNext());
        String string = (String)iterator.next();
        MetadataTest.assertEquals((String)"Exif data segment must contain at least 14 bytes", (String)string);
        MetadataTest.assertTrue((!iterator.hasNext() ? 1 : 0) != 0);
    }

    public void testGetErrorCount() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/exif/test/badExif.jpg"));
        MetadataTest.assertEquals((int)1, (int)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).getErrorCount());
    }

    public void testMetadataSerializable() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/test/withIptcExifGps.jpg"));
        new ObjectOutputStream(new NullOutputStream()).writeObject(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerializeAndRestore() throws Exception {
        Metadata metadata = JpegMetadataReader.readMetadata(new File("src/com/drew/metadata/test/withIptcExifGps.jpg"));
        File file = File.createTempFile("test", "ser");
        try {
            new ObjectOutputStream(new FileOutputStream(file)).writeObject(metadata);
            Metadata metadata2 = (Metadata)new ObjectInputStream(new FileInputStream(file)).readObject();
            MetadataTest.assertTrue((boolean)metadata2.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = MetadataTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory));
            MetadataTest.assertTrue((boolean)metadata2.containsDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = MetadataTest.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory));
        }
        finally {
            file.delete();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

