/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg.test;

import com.drew.metadata.MetadataException;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDescriptor;
import com.drew.metadata.jpeg.JpegDirectory;
import junit.framework.TestCase;

public class JpegDescriptorTest
extends TestCase {
    private JpegDirectory _directory;
    private JpegDescriptor _descriptor;

    public JpegDescriptorTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this._directory = new JpegDirectory();
        this._descriptor = new JpegDescriptor(this._directory);
    }

    public void testGetComponentDataDescription_InvalidComponentNumber() throws Exception {
        try {
            this._descriptor.getComponentDataDescription(1);
            JpegDescriptorTest.fail((String)"Excepted exception");
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    public void testGetImageWidthDescription() throws Exception {
        this._directory.setInt(3, 123);
        JpegDescriptorTest.assertEquals((String)"123 pixels", (String)this._descriptor.getImageWidthDescription());
        JpegDescriptorTest.assertEquals((String)"123 pixels", (String)this._directory.getDescription(3));
    }

    public void testGetImageHeightDescription() throws Exception {
        this._directory.setInt(1, 123);
        JpegDescriptorTest.assertEquals((String)"123 pixels", (String)this._descriptor.getImageHeightDescription());
        JpegDescriptorTest.assertEquals((String)"123 pixels", (String)this._directory.getDescription(1));
    }

    public void testGetDataPrecisionDescription() throws Exception {
        this._directory.setInt(0, 8);
        JpegDescriptorTest.assertEquals((String)"8 bits", (String)this._descriptor.getDataPrecisionDescription());
        JpegDescriptorTest.assertEquals((String)"8 bits", (String)this._directory.getDescription(0));
    }

    public void testGetComponentDescription() throws MetadataException {
        JpegComponent jpegComponent = new JpegComponent(1, 34, 0);
        this._directory.setObject(6, jpegComponent);
        JpegDescriptorTest.assertEquals((String)"Y component: Quantization table 0, Sampling factors 2 horiz/2 vert", (String)this._directory.getDescription(6));
        JpegDescriptorTest.assertEquals((String)"Y component: Quantization table 0, Sampling factors 2 horiz/2 vert", (String)this._descriptor.getComponentDataDescription(0));
    }
}

