/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import java.io.File;
import junit.framework.TestCase;

public class ExifReaderTest
extends TestCase {
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public ExifReaderTest(String string) {
        super(string);
    }

    public void testLoadFujiFilmJpeg() throws Exception {
        String string = "src/com/drew/metadata/exif/test/withExif.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((String)"80", (String)directory.getDescription(34855));
    }

    public void testLoadJpegWithoutExifData() throws Exception {
        String string = "src/com/drew/metadata/exif/test/noExif.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        ExifReaderTest.assertTrue((!metadata.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory) ? 1 : 0) != 0);
    }

    public void testLoadJpegWithBadExifData() throws Exception {
        String string = "src/com/drew/metadata/exif/test/badExif.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        ExifReaderTest.assertEquals((int)0, (int)metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).getTagCount());
    }

    public void testCrashRegressionTest() throws Exception {
        String string = "src/com/drew/metadata/exif/test/crash01.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        ExifReaderTest.assertTrue((metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory).getTagCount() > 0 ? 1 : 0) != 0);
    }

    public void testUserComment() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((String)"Here we add a EXIF comment", (String)directory.getString(37510));
    }

    public void testThumbnailOffset() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((int)192, (int)directory.getInt(513));
    }

    public void testThumbnailLength() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((int)2970, (int)directory.getInt(514));
    }

    public void testDateTime() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((String)"2002:11:27 18:00:35", (String)directory.getString(306));
    }

    public void testXResolution() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        Rational rational = directory.getRational(282);
        ExifReaderTest.assertEquals((int)72, (int)rational.getNumerator());
        ExifReaderTest.assertEquals((int)1, (int)rational.getDenominator());
    }

    public void testYResolution() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        Rational rational = directory.getRational(283);
        ExifReaderTest.assertEquals((int)72, (int)rational.getNumerator());
        ExifReaderTest.assertEquals((int)1, (int)rational.getDenominator());
    }

    public void testCompression() throws Exception {
        String string = "src/com/drew/metadata/exif/test/manuallyAddedThumbnail.jpg";
        Metadata metadata = new ExifReader(new File(string)).extract();
        Directory directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReaderTest.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        ExifReaderTest.assertEquals((int)6, (int)directory.getInt(259));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

