/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import jdomain.util.Log;
import jdomain.util.LogListener;
import jdomain.util.ResourceLoader;

public class LogPanel
extends JPanel
implements LogListener {
    private static final long serialVersionUID = 0L;
    private static final int TYPE_DEBUG = 0;
    private static final int TYPE_INFO = 1;
    private static final int TYPE_WARNING = 2;
    private static final int TYPE_ERROR = 3;
    private static final int TYPE_EXCEPTION = 4;
    private Font logFont = new Font("SansSerif", 0, 10);
    private final JList logList = new JList(new DefaultListModel());

    public LogPanel() {
        super(new BorderLayout(0, 0));
        this.setBackground(Color.WHITE);
        this.logList.setVisibleRowCount(8);
        this.logList.setCellRenderer(new CellRenderer());
        this.add((Component)new JScrollPane(this.logList), "Center");
        this.logList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3 && LogPanel.this.logList.getModel().getSize() > 0) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    String string = "Clear Messages";
                    if (Locale.getDefault().toString().equals("de")) {
                        string = "Nachrichten L\u00f6schen";
                    }
                    jPopupMenu.add(new AbstractAction(this, string, ResourceLoader.getImage("jdomain/util/images/eraser.gif")){
                        private static final long serialVersionUID = 1L;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            1.access$100(this.this$1).clear();
                        }
                    });
                    jPopupMenu.show(LogPanel.this.logList, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            static /* synthetic */ LogPanel access$100(1 var0) {
                return var0.LogPanel.this;
            }
        });
        Log.addLogListener(this);
    }

    public void close() {
    }

    public void clear() {
        this.logList.setModel(new DefaultListModel());
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.logList.addListSelectionListener(listSelectionListener);
    }

    public void removeSelectionListener(ListSelectionListener listSelectionListener) {
        this.logList.removeListSelectionListener(listSelectionListener);
    }

    private void addElement(final LogMessage logMessage) {
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultListModel defaultListModel = (DefaultListModel)LogPanel.this.logList.getModel();
                defaultListModel.addElement(logMessage);
                LogPanel.this.logList.ensureIndexIsVisible(defaultListModel.size() - 1);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void debug(String string) {
        this.addElement(new LogMessage(0, string));
    }

    public void error(String string) {
        this.addElement(new LogMessage(3, string));
    }

    public void exception(Throwable throwable) {
        this.addElement(new LogMessage(4, throwable.toString()));
    }

    public void info(String string) {
        this.addElement(new LogMessage(1, string));
    }

    public void warning(String string, Object object) {
        this.addElement(new LogMessage(2, string + " [" + object + "]", object));
    }

    public void warning(String string) {
        this.addElement(new LogMessage(2, string));
    }

    public Object getSelection() {
        LogMessage logMessage = (LogMessage)this.logList.getSelectedValue();
        if (logMessage == null) {
            return null;
        }
        return logMessage.obj;
    }

    private final class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public CellRenderer() {
            this.setFont(LogPanel.this.logFont);
            this.setBorder(new EmptyBorder(0, 4, 0, 4));
            this.setIconTextGap(8);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = 18;
            return dimension;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LogMessage logMessage = (LogMessage)object;
            this.setText(logMessage.message);
            if (bl) {
                this.setOpaque(true);
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setOpaque(false);
                switch (logMessage.type) {
                    case 0: {
                        this.setForeground(Color.GRAY);
                        this.setIcon(null);
                        break;
                    }
                    case 1: {
                        this.setForeground(Color.BLUE);
                        this.setIcon(ResourceLoader.getImage("jdomain/util/images/info_small.png"));
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.setForeground(Color.RED);
                        this.setIcon(ResourceLoader.getImage("jdomain/util/images/error_small.png"));
                        break;
                    }
                    case 2: {
                        this.setForeground(Color.MAGENTA);
                        this.setIcon(ResourceLoader.getImage("jdomain/util/images/warning_small.png"));
                    }
                }
                if (logMessage.obj != null) {
                    this.setIcon(ResourceLoader.getImage("jdomain/util/images/object_small.png"));
                }
            }
            return this;
        }
    }

    private class LogMessage {
        public final int type;
        public final String message;
        public final Object obj;

        public LogMessage(int n, String string) {
            this(n, string, null);
        }

        public LogMessage(int n, String string, Object object) {
            this.type = n;
            this.message = string;
            this.obj = object;
        }
    }
}

