/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import jdomain.util.gui.BrowserFilter;
import jdomain.util.gui.FileBrowserUI;
import jdomain.util.gui.StandardMainFrame;

public class FileBrowser
extends JFileChooser
implements WindowFocusListener,
PropertyChangeListener {
    private static final long serialVersionUID = 0L;
    public static final BrowserFilter ALL_FILES_FILTER = new BrowserFilter("All Files", new String[]{".*"}){

        protected boolean doAccept(File file) {
            return true;
        }
    };
    private JDialog dialog;
    private String openPath = System.getProperty("user.dir");
    private boolean previewing = true;
    private String savePath = this.openPath;

    public FileBrowser() {
        this.setAcceptAllFileFilterUsed(false);
        this.addPropertyChangeListener("SelectedFileChangedProperty", this);
    }

    public final String getOpenDir() {
        return this.openPath;
    }

    public final void setOpenDir(String string) {
        this.openPath = string;
    }

    public final String getSaveDir() {
        return this.savePath;
    }

    public final void setSaveDir(String string) {
        this.savePath = string;
    }

    protected String adjustFilename(String string, BrowserFilter browserFilter) {
        while (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    protected final JDialog createDialog(Component component) {
        this.dialog = super.createDialog(component);
        return this.dialog;
    }

    protected boolean endsWithSelectedExtension(String string) {
        BrowserFilter browserFilter = (BrowserFilter)this.getFileFilter();
        int n = string.length();
        Iterator iterator = browserFilter.extensions.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            int n2 = string2.length();
            if (!string.substring(n - n2).equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    protected boolean hasValidExtension(File file, BrowserFilter browserFilter) {
        String string = file.toString().trim();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return !string2.endsWith(".");
    }

    private final void hideViewer() {
        if (this.previewing) {
            this.previewing = false;
            ((FileBrowserUI)this.getUI()).hideViewer();
        }
    }

    public final File open(StandardMainFrame standardMainFrame, String string, BrowserFilter[] browserFilterArray, BrowserFilter browserFilter, boolean bl) {
        this.prepareDialog(standardMainFrame, string, browserFilterArray, browserFilter, bl, this.openPath);
        int n = this.showOpenDialog(standardMainFrame);
        if (n == 0) {
            File file = this.getSelectedFile();
            this.openPath = file.getParent();
            return file;
        }
        return null;
    }

    private final void prepareDialog(StandardMainFrame standardMainFrame, String string, BrowserFilter[] browserFilterArray, BrowserFilter browserFilter, boolean bl, String string2) {
        if (bl) {
            this.showViewer();
        } else {
            this.hideViewer();
        }
        this.resetChoosableFileFilters();
        if (browserFilter == null && (browserFilterArray == null || browserFilterArray.length == 0)) {
            this.addChoosableFileFilter(ALL_FILES_FILTER);
        } else {
            if (browserFilterArray != null) {
                int n = browserFilterArray.length;
                for (int i = 0; i < n; ++i) {
                    this.addChoosableFileFilter(browserFilterArray[i]);
                }
            }
            if (browserFilter != null) {
                this.setFileFilter(browserFilter);
            }
        }
        this.setDialogTitle(string);
        this.setCurrentDirectory(new File(string2));
        if (bl) {
            this.resetViewer();
        }
    }

    public final File save(StandardMainFrame standardMainFrame, String string, BrowserFilter[] browserFilterArray, BrowserFilter browserFilter, boolean bl) {
        this.prepareDialog(standardMainFrame, string, browserFilterArray, browserFilter, bl, this.savePath);
        int n = this.showSaveDialog(standardMainFrame);
        if (n == 0) {
            File file = this.getSelectedFile();
            this.savePath = file.getParent();
            BrowserFilter browserFilter2 = (BrowserFilter)this.getFileFilter();
            if (!this.hasValidExtension(file, browserFilter2)) {
                file = new File(this.adjustFilename(file.toString(), browserFilter2));
            }
            return file;
        }
        return null;
    }

    private void resetViewer() {
        ((FileBrowserUI)this.getUI()).rebuildViewer();
    }

    private final void showViewer() {
        if (!this.previewing) {
            this.previewing = true;
            ((FileBrowserUI)this.getUI()).showViewer();
        }
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ((FileBrowserUI)this.getUI()).selectionChanged(propertyChangeEvent);
    }
}

