/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import jdomain.util.Log;

public final class Util {
    private Util() {
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).trim().length() == 0;
        }
        return false;
    }

    public static String shortClassName(Object object) {
        if (object == null) {
            return "null";
        }
        return Util.shortClassName(object.getClass());
    }

    public static String shortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }

    public static String getFileExtension(File file) {
        return Util.getFileExtension(file.toString());
    }

    public static Object createInstance(Class clazz, Object[] objectArray) {
        try {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            int n = objectArray.length;
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            Constructor constructor = clazz.getConstructor(classArray);
            if (constructor == null) {
                return null;
            }
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }

    public static boolean delay(long l) {
        try {
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Log.exception(interruptedException);
            return false;
        }
    }

    public static boolean isIn(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static Exception close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                return exception;
            }
        }
        return null;
    }

    public static Exception close(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                return exception;
            }
        }
        return null;
    }

    public static Exception close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                return exception;
            }
        }
        return null;
    }

    public static Exception close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                return exception;
            }
        }
        return null;
    }

    public static Exception close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception exception) {
                return exception;
            }
        }
        return null;
    }

    public static StrippedHTMLString stripHTMLCode(String string) {
        boolean bl = false;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>\\", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("<")) {
                if (string2.equals("\\")) {
                    stringBuffer.append(string3);
                } else {
                    bl = true;
                    n = n2;
                }
            } else if (string3.equals(">")) {
                if (string2.equals("\\")) {
                    stringBuffer.append(string3);
                } else if (bl) {
                    bl = false;
                    n = -1;
                } else {
                    stringBuffer.append(string3);
                }
            } else if (!bl) {
                stringBuffer.append(string3);
            }
            n2 += string3.length();
        }
        return new StrippedHTMLString(string, stringBuffer.toString(), n);
    }

    public static String asBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Util.hexString(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static int asInt(String string) {
        return Util.asInt(string, 10);
    }

    public static int asInt(String string, int n) {
        return Util.asInt(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int asInt(String string, int n, int n2, int n3) {
        if (Util.isNumber(string, n, n2, n3)) {
            return Integer.parseInt(string, n);
        }
        return 0;
    }

    public static String binaryString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(n));
        if (stringBuffer.length() < n2) {
            while (stringBuffer.length() < n2) {
                stringBuffer.insert(0, '0');
            }
        } else {
            while (stringBuffer.length() > n2) {
                stringBuffer.deleteCharAt(0);
            }
        }
        return stringBuffer.toString();
    }

    public static String binaryString(int n) {
        return Util.binaryString(n, 8);
    }

    public static String hexString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String hexString(int n) {
        return Util.hexString(n, 2);
    }

    public static String string(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public static boolean isNumber(String string) {
        return Util.isNumber(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static boolean isMinMax(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static boolean isNumber(String string, int n) {
        return Util.isNumber(string, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static boolean isNumber(String string, int n, int n2) {
        return Util.isNumber(string, 10, n, n2);
    }

    public static boolean isNumber(String string, int n, int n2, int n3) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        try {
            int n4 = Integer.parseInt(string, n);
            return n4 >= n2 && n4 <= n3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static class StrippedHTMLString {
        public final String source;
        public final String stripped;
        public final boolean endsInHTML;
        public final String trailingHTML;

        protected StrippedHTMLString(String string, String string2, int n) {
            this.source = string;
            this.stripped = string2;
            this.endsInHTML = n != -1;
            this.trailingHTML = this.endsInHTML ? this.source.substring(n) : null;
        }

        public String toString() {
            return "\nsource: '" + this.source + "'" + "\nstripped: '" + this.stripped + "'\ntrailingHTML: " + (this.endsInHTML ? "'" + this.trailingHTML + "'" : "<empty>");
        }
    }
}

