/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.util.Util;
import jdomain.util.gui.WidgetFactory;

public final class RotateDialog
extends DrawDialog
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private final JTextField angleField = new JTextField(6);

    public RotateDialog() {
        super("Rotation Dialog");
        this.setModal(true);
        this.setUndecorated(true);
        this.angleField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.angleField.setText("180");
        this.angleField.getDocument().addDocumentListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        JLabel jLabel = new JLabel("<html><b>Please enter the rotation angle:</b></html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel("Rotation angle:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.angleField, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.setDefaultBorder();
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
    }

    public Double getRotationAngle() {
        int n = Util.asInt(this.angleField.getText().trim());
        if (n % 360 == 0) {
            return null;
        }
        return new Double(Math.toRadians(n));
    }

    private void checkInput() {
        String string = this.angleField.getText().trim();
        this.getApproveButton().setEnabled(Util.isNumber(string, -360, 360));
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }
}

