/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FramePanel;
import jdomain.jdraw.gui.Tool;

public final class PreviewPanel
extends DrawPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final PreviewPanel INSTANCE = new PreviewPanel();
    private FramePanel framePanel;

    private PreviewPanel() {
        this.setOpaque(true);
    }

    public int getGrid() {
        return 1;
    }

    private void detach() {
        if (this.framePanel != null) {
            this.framePanel.getScrollPane().getViewport().removeChangeListener(this);
        }
    }

    private void attach() {
        this.framePanel.getScrollPane().getViewport().addChangeListener(this);
    }

    public DrawPanel getDrawPanel() {
        return this.framePanel.getDrawPanel();
    }

    protected void setClip(Frame frame) {
        this.detach();
        this.clip = frame;
        this.framePanel = Tool.getCurrentFramePanel();
        this.attach();
        this.setViewpointFromFramePanel();
        this.getParentViewport().revalidate();
    }

    public boolean showGrid() {
        return false;
    }

    private JViewport getParentViewport() {
        return (JViewport)this.getParent();
    }

    public final Dimension getPreferredSize() {
        if (this.clip == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.clip.getWidth(), this.clip.getHeight());
    }

    private void setViewpointFromFramePanel() {
        JViewport jViewport = this.framePanel.getScrollPane().getViewport();
        Point point = jViewport.getViewPosition();
        int n = Tool.getGrid();
        point.x /= n;
        point.y /= n;
        Dimension dimension = this.getPreferredSize();
        JViewport jViewport2 = this.getParentViewport();
        Dimension dimension2 = jViewport2.getExtentSize();
        if (dimension2.width >= dimension.width) {
            point.x = 0;
        } else if (point.x + dimension2.width - 1 > dimension.width) {
            point.x = dimension.width - dimension2.width;
        }
        if (dimension2.height >= dimension.height) {
            point.y = 0;
        } else if (point.y + dimension2.height - 1 > dimension.height) {
            point.y = dimension.height - dimension2.height;
        }
        jViewport2.setViewPosition(point);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setViewpointFromFramePanel();
    }
}

