/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jdomain.jdraw.gui.ColourEditor;
import jdomain.jdraw.gui.ColourPanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.gui.AntialiasPanel;

public final class GradientPanel
extends AntialiasPanel {
    private static final long serialVersionUID = 1L;
    private static final int NORTH = 0;
    private static final int NORTH_HALF = 1;
    private static final int WEST = 10;
    private static final int WEST_HALF = 11;
    private static final int NORTH_EAST = 20;
    private static final int NORTH_EAST_HALF = 21;
    private static final int NORTH_WEST = 30;
    private static final int NORTH_WEST_HALF = 31;
    public static final GradientPanel INSTANCE = new GradientPanel();
    private GradientTile selectedTile;
    private final ButtonGroup gradientGroup = new ButtonGroup();
    private boolean cycle = false;
    private boolean invert = false;
    private final JPanel firstColour;
    private final JPanel secondColour;
    private final MListener mListener = new MListener();

    private GradientPanel() {
        super(new BorderLayout(0, 0));
        this.firstColour = this.createColourPanel(Color.white);
        this.secondColour = this.createColourPanel(Color.black);
        this.add((Component)this.firstColour, "West");
        this.add((Component)this.secondColour, "East");
        JPanel jPanel = new JPanel(new GridLayout(0, 4, 1, 1));
        GradientTile gradientTile = new GradientTile(0);
        gradientTile.setSelected(true);
        this.selectedTile = gradientTile;
        jPanel.add(gradientTile);
        jPanel.add(new GradientTile(10));
        jPanel.add(new GradientTile(30));
        jPanel.add(new GradientTile(20));
        jPanel.add(new GradientTile(1));
        jPanel.add(new GradientTile(11));
        jPanel.add(new GradientTile(31));
        jPanel.add(new GradientTile(21));
        jPanel.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.add((Component)jPanel, "Center");
        AntialiasPanel antialiasPanel = new AntialiasPanel(new BorderLayout(0, 0));
        JCheckBox jCheckBox = new JCheckBox("Cycle");
        jCheckBox.setFont(MainFrame.DEFAULT_FONT);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPanel.this.cycle = !GradientPanel.this.cycle;
                GradientPanel.this.repaint();
            }
        });
        antialiasPanel.add((Component)jCheckBox, "West");
        JCheckBox jCheckBox2 = new JCheckBox("Invert");
        jCheckBox2.setHorizontalAlignment(4);
        jCheckBox2.setFont(MainFrame.DEFAULT_FONT);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GradientPanel.this.invert = !GradientPanel.this.invert;
                GradientPanel.this.repaint();
            }
        });
        antialiasPanel.add((Component)jCheckBox2, "East");
        antialiasPanel.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.add((Component)antialiasPanel, "South");
        this.setBorder(new TitledBorder("Gradient Fill"));
    }

    private JPanel createColourPanel(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setPreferredSize(ColourPanel.DIMENSION);
        jPanel.setBorder(ColourPanel.PLAIN_BORDER);
        jPanel.addMouseListener(this.mListener);
        return jPanel;
    }

    public final GradientPaint createGradient(Dimension dimension) {
        return this.createGradient(dimension, this.selectedTile.direction);
    }

    public final GradientPaint createGradient(Rectangle rectangle) {
        return this.createGradient(rectangle, this.selectedTile.direction);
    }

    private final GradientPaint createGradient(Rectangle rectangle, int n) {
        Point point;
        Point point2;
        Color color = this.firstColour.getBackground();
        Color color2 = this.secondColour.getBackground();
        switch (n) {
            case 0: {
                point2 = new Point(rectangle.x, rectangle.y);
                point = new Point(rectangle.x, rectangle.y + rectangle.height - 1);
                break;
            }
            case 1: {
                point2 = new Point(rectangle.x, rectangle.y);
                point = new Point(rectangle.x, rectangle.y + rectangle.height / 2);
                break;
            }
            case 10: {
                point2 = new Point(rectangle.x, rectangle.y + rectangle.height / 2);
                point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height / 2);
                break;
            }
            case 11: {
                point2 = new Point(rectangle.x, rectangle.y + rectangle.height / 2);
                point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                break;
            }
            case 30: {
                point2 = new Point(rectangle.x, rectangle.y);
                point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                break;
            }
            case 31: {
                point2 = new Point(rectangle.x, rectangle.y);
                point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                break;
            }
            case 20: {
                point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
                point = new Point(rectangle.x, rectangle.y + rectangle.height - 1);
                break;
            }
            case 21: {
                point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
                point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                Assert.fail("gui: invalid direction " + n);
                return null;
            }
        }
        Color color3 = this.invert ? color2 : color;
        Color color4 = this.invert ? color : color2;
        return new GradientPaint(point2, color3, point, color4, this.cycle);
    }

    private final GradientPaint createGradient(Dimension dimension, int n) {
        return this.createGradient(new Rectangle(0, 0, dimension.width, dimension.height), n);
    }

    private final class GradientTile
    extends JToggleButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final int direction;

        public GradientTile(int n) {
            GradientPanel.this.gradientGroup.add(this);
            this.direction = n;
            Dimension dimension = ColourPanel.DIMENSION;
            this.setPreferredSize(dimension);
            this.addActionListener(this);
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            graphics2D.setPaint(GradientPanel.this.createGradient(dimension, this.direction));
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            if (this.getBorder() != null) {
                super.paintBorder(graphics);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                GradientPanel.this.selectedTile = this;
                Log.debug("selected: " + this);
            }
        }
    }

    private final class MListener
    extends MouseAdapter {
        private MListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JPanel jPanel = (JPanel)mouseEvent.getSource();
                ColourEditor colourEditor = ColourEditor.INSTANCE;
                colourEditor.setColour(jPanel.getBackground());
                colourEditor.open();
                if (colourEditor.getResult() == 1) {
                    jPanel.setBackground(colourEditor.getColour());
                    GradientPanel.this.repaint();
                }
            }
        }
    }
}

