/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.action.ToggleLocalPaletteAction;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FramePanel;
import jdomain.jdraw.gui.GridListener;
import jdomain.jdraw.gui.MouseHandler;
import jdomain.jdraw.gui.PalettePanel;
import jdomain.jdraw.gui.PreviewPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.ResourceLoader;

public final class FolderPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static int grid;
    private static final ArrayList GRID_LISTENERS;
    public static final FolderPanel INSTANCE;
    public static final int MAX_GRID = 25;
    public static final int MIN_GRID = 1;
    private final JTabbedPane frameFolder = new JTabbedPane();
    private final ImageIcon frameIcon = ResourceLoader.getImage("jdomain/jdraw/images/frame.png", 16);
    private Picture picture;
    private boolean justUpdating = false;
    private boolean showGrid = true;
    static /* synthetic */ Class class$jdomain$jdraw$action$RemoveFrameAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleLocalPaletteAction;

    private FolderPanel() {
        super(new BorderLayout(0, 0));
        this.add((Component)this.frameFolder, "Center");
        this.frameFolder.addChangeListener(this);
        this.frameFolder.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        this.frameFolder.setTabPlacement(3);
        this.frameFolder.setTabLayoutPolicy(1);
        FolderPanel.setGrid(15);
    }

    public static int getGrid() {
        return grid;
    }

    public static void setGrid(int n) {
        if (n == grid) {
            return;
        }
        Assert.isTrue(n >= 1 && n <= 25, "gui: grid out of range.");
        int n2 = grid;
        grid = n;
        Iterator iterator = GRID_LISTENERS.iterator();
        while (iterator.hasNext()) {
            ((GridListener)iterator.next()).gridChanged(n2, grid);
        }
    }

    private void addFrame(int n) {
        FramePanel framePanel = new FramePanel();
        framePanel.setFrame(this.picture.getFrame(n));
        this.frameFolder.insertTab("#" + String.valueOf(n + 1), this.frameIcon, framePanel, null, n);
        this.frameChanged();
    }

    public static void addGridListener(GridListener gridListener) {
        GRID_LISTENERS.add(gridListener);
    }

    public void changeFrameAdded(jdomain.jdraw.data.event.ChangeEvent changeEvent) {
        this.addFrame(changeEvent.getIntValue());
    }

    public void changeFrameRemoved(jdomain.jdraw.data.event.ChangeEvent changeEvent) {
        this.removeFrame(changeEvent.getIntValue());
    }

    public void changeFrameSet(jdomain.jdraw.data.event.ChangeEvent changeEvent) {
        FramePanel framePanel = (FramePanel)this.frameFolder.getComponentAt(changeEvent.getNewInt());
        this.frameFolder.setSelectedComponent(framePanel);
        this.frameChanged();
    }

    public Image createOffScreenImage() {
        Frame frame = Tool.getCurrentFrame();
        return this.createOffScreenImage(0, 0, frame.getWidth(), frame.getHeight());
    }

    public Image createOffScreenImage(int n, int n2, int n3, int n4) {
        DrawPanel drawPanel = Tool.getDrawPanel();
        Image image = drawPanel.createImage(n3, n4);
        Graphics graphics = image.getGraphics();
        Palette palette = Tool.getCurrentPalette();
        Picture picture = Tool.getPicture();
        Frame frame = this.getCurrentFrame();
        int n5 = picture.getBackground();
        if (frame.getTransparentColour() != -1) {
            n5 = frame.getTransparentColour();
        }
        Color color = palette.getColour(n5).getColour();
        graphics.setColor(color);
        graphics.translate(-n, -n2);
        graphics.fillRect(n, n2, n3, n4);
        int n6 = grid;
        grid = 1;
        drawPanel.paintClip(graphics, false);
        graphics.translate(n, n2);
        grid = n6;
        return image;
    }

    private void frameChanged() {
        MouseHandler.INSTANCE.frameChanged();
        PalettePanel.INSTANCE.setPalette(Tool.getCurrentPalette());
        PreviewPanel.INSTANCE.setClip(Tool.getCurrentFrame());
        int n = this.getFrameCount();
        DrawAction.getAction(class$jdomain$jdraw$action$RemoveFrameAction == null ? (class$jdomain$jdraw$action$RemoveFrameAction = FolderPanel.class$("jdomain.jdraw.action.RemoveFrameAction")) : class$jdomain$jdraw$action$RemoveFrameAction).setEnabled(n > 1);
        ((ToggleLocalPaletteAction)DrawAction.getAction(class$jdomain$jdraw$action$ToggleLocalPaletteAction == null ? (class$jdomain$jdraw$action$ToggleLocalPaletteAction = FolderPanel.class$("jdomain.jdraw.action.ToggleLocalPaletteAction")) : class$jdomain$jdraw$action$ToggleLocalPaletteAction)).adjustMenuItems();
        ImageIcon imageIcon = ResourceLoader.getImage("jdomain/jdraw/images/frame_inactive.png");
        ImageIcon imageIcon2 = ResourceLoader.getImage("jdomain/jdraw/images/frame.png");
        int n2 = Tool.getPicture().getCurrentFrameIndex();
        for (int i = 0; i < n; ++i) {
            if (i == n2) {
                this.frameFolder.setIconAt(i, imageIcon2);
                continue;
            }
            this.frameFolder.setIconAt(i, imageIcon);
        }
        this.getCurrentFramePanel().revalidateFrame();
    }

    public Frame getCurrentFrame() {
        return Tool.getCurrentFrame();
    }

    public FramePanel getCurrentFramePanel() {
        return (FramePanel)this.frameFolder.getComponentAt(this.picture.getCurrentFrameIndex());
    }

    public int getFrameCount() {
        return this.frameFolder.getTabCount();
    }

    public Picture getPicture() {
        return this.picture;
    }

    private void removeFrame(int n) {
        this.frameFolder.removeTabAt(n);
        if (--n == -1) {
            n = 0;
        }
        this.picture.setCurrentFrame(n);
        int n2 = this.getFrameCount();
        for (int i = 0; i < n2; ++i) {
            this.frameFolder.setTitleAt(i, "#" + String.valueOf(i + 1));
        }
        this.frameChanged();
    }

    private void removeFramePanels() {
        int n = this.frameFolder.getTabCount();
        for (int i = 0; i < n; ++i) {
            FramePanel framePanel = (FramePanel)this.frameFolder.getComponentAt(0);
            this.frameFolder.removeTabAt(0);
            FolderPanel.removeGridListener(framePanel.getLayeredPane());
        }
    }

    public static void removeGridListener(GridListener gridListener) {
        GRID_LISTENERS.remove(gridListener);
    }

    public void setPicture(Picture picture) {
        this.justUpdating = picture == this.picture;
        int n = this.frameFolder.getSelectedIndex();
        this.picture = picture;
        this.setVisible(false);
        this.removeFramePanels();
        int n2 = this.picture.getFrameCount();
        for (int i = 0; i < n2; ++i) {
            FramePanel framePanel = new FramePanel();
            framePanel.setFrame(this.picture.getFrame(i));
            this.frameFolder.addTab("#" + String.valueOf(i + 1), this.frameIcon, framePanel);
        }
        if (this.justUpdating) {
            this.frameFolder.setSelectedIndex(n);
            this.justUpdating = false;
        }
        this.frameChanged();
        this.setVisible(true);
    }

    public void setShowGrid(boolean bl) {
        if (bl != this.showGrid) {
            this.showGrid = bl;
            this.repaint();
        }
    }

    public boolean showGrid() {
        return grid > 1 && this.showGrid;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.justUpdating) {
            return;
        }
        int n = this.frameFolder.getSelectedIndex();
        if (n != -1 && n < this.getPicture().getFrameCount()) {
            this.getPicture().setCurrentFrame(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        GRID_LISTENERS = new ArrayList();
        INSTANCE = new FolderPanel();
    }
}

