/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import jdomain.jdraw.gui.DrawMouseListener;
import jdomain.jdraw.gui.Tool;

public abstract class FloatingClip
extends JPanel
implements DrawMouseListener {
    private boolean isActive = false;
    private Integer layer;

    public FloatingClip(int n) {
        this(new Integer(n));
        this.setOpaque(false);
    }

    public FloatingClip(Integer n) {
        this.layer = n;
        this.setOpaque(false);
    }

    public Integer getLayer() {
        return this.layer;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected void activate() {
        if (!this.isActive) {
            this.isActive = true;
        }
    }

    protected void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.setBounds(-100, -100, 0, 0);
        }
    }

    public abstract String getName();

    public void defineClip(Rectangle rectangle) {
        this.setBounds(rectangle);
        this.activate();
    }

    public void defineClip(int n, int n2, int n3, int n4) {
        this.defineClip(new Rectangle(n, n2, n3, n4));
    }

    protected static Point toFramePoint(int n, int n2) {
        int n3 = Tool.getGrid();
        return new Point(n /= n3, n2 /= n3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.isActive()) {
            super.paint(graphics);
        }
    }
}

