/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.Tool;

public class DrawPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color TRANS_COL = new Color(0, 0, 0, 0);
    protected Clip clip;

    public DrawPanel() {
        this.setOpaque(false);
    }

    public Clip getClip() {
        return this.clip;
    }

    public int getGrid() {
        return Tool.getGrid();
    }

    protected void setClip(Clip clip) {
        this.clip = clip;
        this.setPreferredSize(this.getPreferredSize());
    }

    public boolean showGrid() {
        return FolderPanel.INSTANCE.showGrid();
    }

    public final void paintClip(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Palette palette = Tool.getCurrentPalette();
        int n = Tool.getPicture().getTransparent();
        boolean bl2 = this.showGrid();
        int n2 = this.clip.getWidth();
        int n3 = this.clip.getHeight();
        int n4 = this.getGrid();
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n7 = this.clip.getPixel(j, i);
                if (n7 == n) {
                    if (bl) {
                        graphics2D.setColor(TRANS_COL);
                        graphics2D.fillRect(n5, n6, n4, n4);
                    }
                } else {
                    graphics2D.setColor(palette.getColour(n7).getColour());
                    graphics2D.fillRect(n5, n6, n4, n4);
                }
                if (bl2) {
                    graphics2D.setColor(Color.darkGray);
                    graphics2D.drawRect(n5, n6, n4, n4);
                }
                n5 += n4;
            }
            n5 = 0;
            n6 += n4;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.setBounds(0, 0, dimension.width, dimension.height);
    }

    public final void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.clip == null) {
            return;
        }
        this.paintClip(graphics, false);
    }

    public Dimension getPreferredSize() {
        if (this.clip == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.getGrid() * this.clip.getWidth() + 1, this.getGrid() * this.clip.getHeight() + 1);
    }
}

