/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.IconReader;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;

public final class IconWriter {
    private static final int ICON_HEADER_SIZE = 40;
    private static final int FILE_HEADER_SIZE = 6;
    private static final int DICTIONARY_ENTRY_SIZE = 16;
    private final OutputStream out;
    private final Picture picture;
    private int bytesWritten = 0;
    private final ArrayList icons = new ArrayList();

    private IconWriter(OutputStream outputStream, Picture picture) {
        this.out = outputStream;
        this.picture = picture;
    }

    public static boolean writeIcon(Picture picture, String string) {
        try {
            IconWriter iconWriter = new IconWriter(new FileOutputStream(string), picture);
            iconWriter.writeIcon();
            return true;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIcon() throws Exception {
        try {
            this.writeHeader();
            this.writeIconEntries();
            this.writeIconData();
            this.icons.clear();
        }
        finally {
            Util.close(this.out);
        }
    }

    private void writeHeader() throws Exception {
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(this.picture.getFrameCount());
    }

    private void writeIconEntries() throws Exception {
        IconEntry iconEntry;
        int n;
        int n2 = this.picture.getFrameCount();
        for (n = 0; n < n2; ++n) {
            iconEntry = new IconEntry(this.picture.getFrame(n));
            this.icons.add(iconEntry);
        }
        n = 6 + n2 * 16;
        for (int i = 0; i < n2; ++i) {
            iconEntry = (IconEntry)this.icons.get(i);
            iconEntry.writeDictionaryEntry(n);
            Log.debug("icon #" + (i + 1) + " offset: " + n);
            n += iconEntry.getSize();
        }
    }

    private void writeIconData() throws Exception {
        int n = this.picture.getFrameCount();
        for (int i = 0; i < n; ++i) {
            IconEntry iconEntry = (IconEntry)this.icons.get(i);
            iconEntry.writeData();
        }
    }

    private void writeInt(int n) throws Exception {
        this.out.write(n);
        this.out.write(n >> 8);
        this.bytesWritten += 2;
    }

    private void writeByte(int n) throws Exception {
        this.out.write(n);
        ++this.bytesWritten;
    }

    private void writeByte(byte[] byArray) throws Exception {
        this.bytesWritten += byArray.length;
        this.out.write(byArray);
    }

    private void writeDWord(int n) throws Exception {
        int n2 = n & 0xFFFF;
        int n3 = n >> 16 & 0xFFFF;
        this.writeInt(n2);
        this.writeInt(n3);
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Log.addLogListener(simpleLogListener);
        Picture picture = IconReader.readIcon("C:/Temp/test.ico");
        IconWriter.writeIcon(picture, "C:/Temp/testout.ico");
    }

    private final class IconEntry {
        public final Palette pal;
        public final Frame frame;
        public final int width;
        public final int height;
        public final int numColours;
        public final int reserved = 0;
        public final int numPlanes = 1;
        public final int bitsPerPixel;
        public final int dataSize;
        public final byte[] bitMap;
        public final byte[] andMap;
        public final boolean hasAlpha;
        private int offset = 0;
        public final ArrayList colours = new ArrayList();

        public IconEntry(Frame frame) throws Exception {
            int n;
            this.frame = frame;
            this.pal = this.frame.getPalette();
            this.width = this.frame.getSettings().getIconWidth();
            this.height = this.frame.getSettings().getIconHeight();
            this.hasAlpha = this.hasAlpha();
            int n2 = this.frame.getPalette().size();
            if (this.frame.getTransparentColour() != -1) {
                --n2;
            }
            int n3 = 0;
            if (!this.hasAlpha) {
                if (n2 <= 2) {
                    this.bitsPerPixel = 1;
                    n3 = 8;
                } else if (n2 <= 16) {
                    this.bitsPerPixel = 4;
                    n3 = 2;
                } else if (n2 <= 256) {
                    this.bitsPerPixel = 8;
                    n3 = 1;
                } else {
                    this.bitsPerPixel = 24;
                    n3 = 1;
                }
            } else {
                this.bitsPerPixel = 32;
                n3 = 1;
            }
            this.numColours = 1 << this.bitsPerPixel;
            Assert.isTrue(n3 != 0, "gio: internal error. div = 0");
            int n4 = this.width * this.height;
            if (this.bitsPerPixel <= 8) {
                n = n4 / n3;
                if (n4 % n3 != 0) {
                    ++n;
                }
            } else {
                n = this.bitsPerPixel == 24 ? n4 * 3 : n4 * 4;
            }
            this.bitMap = new byte[n];
            int n5 = n4 / 8;
            if (n4 % 8 != 0) {
                ++n5;
            }
            this.andMap = new byte[n5];
            this.dataSize = this.getSize();
            if (Log.DEBUG) {
                Log.debug("IconEntry");
                Log.debug("   bitsPerPixel: " + this.bitsPerPixel);
                Log.debug("   width:        " + this.width);
                Log.debug("   height:       " + this.height);
                Log.debug("   colours:      " + this.numColours);
                Log.debug("   size:         " + this.dataSize);
            }
            this.createData();
        }

        private boolean hasAlpha() {
            int n = this.pal.size();
            for (int i = 0; i < n; ++i) {
                Color color = this.pal.getColour(i).getColour();
                if (color.getAlpha() == 255) continue;
                return true;
            }
            return false;
        }

        private void writeDictionaryEntry(int n) throws Exception {
            this.offset = n;
            IconWriter.this.writeByte(this.width);
            IconWriter.this.writeByte(this.height);
            IconWriter.this.writeByte(this.numColours);
            IconWriter.this.writeByte(0);
            IconWriter.this.writeInt(1);
            IconWriter.this.writeInt(this.bitsPerPixel);
            IconWriter.this.writeDWord(this.dataSize);
            IconWriter.this.writeDWord(n);
        }

        public void writeData() throws Exception {
            Assert.isTrue(this.offset == IconWriter.this.bytesWritten, "gio: wrong position.bytesWritten=" + IconWriter.this.bytesWritten + ", offset=" + this.offset);
            IconWriter.this.writeDWord(40);
            IconWriter.this.writeDWord(this.width);
            IconWriter.this.writeDWord(this.height * 2);
            IconWriter.this.writeInt(1);
            IconWriter.this.writeInt(this.bitsPerPixel);
            IconWriter.this.writeDWord(0);
            IconWriter.this.writeDWord(this.bitMap.length);
            IconWriter.this.writeDWord(0);
            IconWriter.this.writeDWord(0);
            IconWriter.this.writeDWord(0);
            IconWriter.this.writeDWord(0);
            if (Log.DEBUG) {
                Log.debug("\nIcon Data");
                Log.debug("   bitsPerPixel: " + this.bitsPerPixel);
                Log.debug("   width:        " + this.width);
                Log.debug("   height:       " + this.height * 2);
                Log.debug("   bitmapSize:   " + this.bitMap.length);
                Log.debug("   colourCount:  " + this.numColours);
            }
            if (this.bitsPerPixel <= 8) {
                int n = this.frame.getTransparentColour();
                boolean bl = n != -1;
                int n2 = this.pal.size();
                int n3 = bl ? this.numColours + 1 : this.numColours;
                for (int i = 0; i < n3; ++i) {
                    if (i == n) continue;
                    Color color = i < n2 ? this.pal.getColour(i).getColour() : Color.black;
                    IconWriter.this.writeByte(color.getBlue());
                    IconWriter.this.writeByte(color.getGreen());
                    IconWriter.this.writeByte(color.getRed());
                    IconWriter.this.writeByte(0);
                }
            }
            IconWriter.this.writeByte(this.bitMap);
            IconWriter.this.writeByte(this.andMap);
        }

        public void createData() {
            this.createAndMask();
            switch (this.bitsPerPixel) {
                case 1: {
                    Arrays.fill(this.bitMap, (byte)1);
                    break;
                }
                case 4: {
                    this.createData4();
                    break;
                }
                case 8: {
                    this.createData8();
                    break;
                }
                case 24: {
                    this.createDataTrueColour24bit();
                    break;
                }
                case 32: {
                    this.createDataTrueColour32bit();
                    break;
                }
                default: {
                    Assert.fail("gio: cannot handle icons with bitsPerPixel=" + this.bitsPerPixel);
                }
            }
        }

        public int getSize() {
            return 40 + this.bitMap.length + this.andMap.length + (this.bitsPerPixel <= 8 ? this.numColours * 4 : 0);
        }

        private void createAndMask() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.frame.getTransparentColour();
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n5 = this.frame.getPixel(j, i);
                    if (n5 == n4) {
                        ++n3;
                    }
                    if (++n2 == 8) {
                        this.andMap[n] = (byte)n3;
                        n3 = 0;
                        ++n;
                        n2 = 0;
                        continue;
                    }
                    n3 <<= 1;
                }
            }
            if (n2 > 0) {
                this.andMap[n] = (byte)n3;
            }
        }

        private void createData4() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = this.frame.getTransparentColour();
            boolean bl = n4 != -1;
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n5 = this.frame.getPixel(j, i);
                    if (bl && n5 > n4) {
                        --n5;
                    }
                    n3 += n5;
                    if ((n2 += 4) == 8) {
                        this.bitMap[n] = (byte)n3;
                        n3 = 0;
                        ++n;
                        n2 = 0;
                        continue;
                    }
                    n3 <<= 4;
                }
            }
            if (n2 > 0) {
                this.bitMap[++n] = (byte)n3;
            }
        }

        private void createData8() {
            int n = 0;
            int n2 = this.frame.getTransparentColour();
            boolean bl = n2 != -1;
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n3 = this.frame.getPixel(j, i);
                    if (bl && n3 > n2) {
                        --n3;
                    }
                    this.bitMap[n] = (byte)n3;
                    ++n;
                }
            }
        }

        private void createDataTrueColour24bit() {
            int n = 0;
            int n2 = this.frame.getTransparentColour();
            int n3 = 0;
            if (n2 != -1 && n2 == 0) {
                n3 = 1;
            }
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n4 = this.frame.getPixel(j, i);
                    if (n4 == n2) {
                        n4 = n3;
                    }
                    Color color = this.pal.getColour(n4).getColour();
                    this.bitMap[n] = (byte)color.getBlue();
                    this.bitMap[n + 1] = (byte)color.getGreen();
                    this.bitMap[n + 2] = (byte)color.getRed();
                    n += 3;
                }
            }
        }

        private void createDataTrueColour32bit() {
            int n = 0;
            int n2 = this.frame.getTransparentColour();
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n3 = this.frame.getPixel(j, i);
                    Color color = this.pal.getColour(n3).getColour();
                    this.bitMap[n] = (byte)color.getBlue();
                    this.bitMap[n + 1] = (byte)color.getGreen();
                    this.bitMap[n + 2] = (byte)color.getRed();
                    this.bitMap[n + 3] = n3 == n2 ? (byte)0 : (byte)color.getAlpha();
                    n += 4;
                }
            }
        }
    }
}

