/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.GIFReader;
import jdomain.jdraw.gio.ImageReader;
import jdomain.jdraw.gui.DrawBrowser;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.PixelTool;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Log;
import jdomain.util.Util;

public final class InsertAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private Picture picture;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetPixelToolAction;

    protected InsertAction() {
        super("Insert Image...");
        this.setToolTipText("Inserts an image into the current frame");
    }

    public static boolean isJDraw(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".jd");
    }

    public static boolean isGIF(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".gif");
    }

    public static boolean isPNG(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n);
        return string2.equalsIgnoreCase(".png");
    }

    public boolean prepareAction() {
        this.picture = null;
        File file = DrawBrowser.INSTANCE.openImage();
        if (file != null) {
            this.fileName = file.getAbsolutePath();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Picture readJDraw(String string) {
        Picture picture;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(string));
            picture = (Picture)objectInputStream.readObject();
        }
        catch (Exception exception) {
            Picture picture2;
            try {
                Log.exception(exception);
                picture2 = null;
            }
            catch (Throwable throwable) {
                Util.close(objectInputStream);
                throw throwable;
            }
            Util.close(objectInputStream);
            return picture2;
        }
        Util.close(objectInputStream);
        return picture;
    }

    public void startAction() {
        this.picture = InsertAction.isGIF(this.fileName) ? GIFReader.readGIF(this.fileName) : (InsertAction.isJDraw(this.fileName) ? this.readJDraw(this.fileName) : ImageReader.readImage(this.fileName));
    }

    public void finishAction() {
        if (this.picture != null) {
            int n = this.picture.getWidth();
            int n2 = this.picture.getHeight();
            Picture picture = MainFrame.INSTANCE.getPicture();
            n = Math.max(picture.getWidth(), n);
            n2 = Math.max(picture.getHeight(), n2);
            if (n != picture.getWidth() || n2 != picture.getHeight()) {
                picture.setSize(n, n2);
            }
            Palette palette = picture.getCurrentPalette();
            Frame frame = this.picture.getFrame(0);
            frame.addIndex(palette.size());
            Palette palette2 = frame.getPalette();
            int n3 = palette2.size();
            for (int i = 0; i < n3; ++i) {
                palette.addColour(palette2.getColour(i).getColour());
            }
            picture.getCurrentFrame().pasteClip(frame, 0, 0);
            UndoManager.INSTANCE.reset();
            ToolPanel.INSTANCE.setCurrentTool(PixelTool.INSTANCE, DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = InsertAction.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction));
            Log.info("Inserted.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

