/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class IconEdit1 {
    static final Color BACKGROUND = new Color(204, 204, 204);
    static final int BIT_MASK = 1;
    static final int BYTE_MASK = 255;
    static final String COPYRIGHT_NOTICE = "Copyright (c) 2007 by Keith Fenske.  Released under GNU Public License.";
    static final String CURRENT_COPY = "IconCopy";
    static final String CURRENT_PASTE = "IconPaste";
    static final String EMPTY_STATUS = "Click to paint.  Right (control) click to erase.  Shift click to select.";
    static final Color GRID_COLOR = new Color(204, 255, 255);
    static final int NIBBLE_MASK = 15;
    static final String PROGRAM_TITLE = "Simple Icon Editor for *.ICO Files in Windows - by: Keith Fenske";
    static final int[][] SIXTEEN_COLORS = new int[][]{{0, 0, 0}, {128, 0, 0}, {0, 128, 0}, {128, 128, 0}, {0, 0, 128}, {128, 0, 128}, {0, 128, 128}, {192, 192, 192}, {128, 128, 128}, {255, 0, 0}, {0, 255, 0}, {255, 255, 0}, {0, 0, 255}, {255, 0, 255}, {0, 255, 255}, {255, 255, 255}};
    static JButton colorButton;
    static JColorChooser colorChooser;
    static JDialog colorDialog;
    static JButton exitButton;
    static JFileChooser fileChooser;
    static JButton fileClearButton;
    static JButton fileOpenButton;
    static JButton fileSaveButton;
    static String hiddenText;
    static FileFilter iconFilter;
    static JFrame mainFrame;
    static JButton menuButton;
    static JMenuItem menuDelete;
    static JMenuItem menuErase;
    static JMenuItem menuGridBack;
    static JMenuItem menuGridHide;
    static JMenuItem menuGridNorm;
    static JMenuItem menuMoveDown;
    static JMenuItem menuMoveUp;
    static JMenuItem menuNew16;
    static JMenuItem menuNew24;
    static JMenuItem menuNew32;
    static JMenuItem menuNew48;
    static JMenuItem menuNew64;
    static JMenuItem menuNewSize;
    static JMenuItem menuText;
    static ButtonGroup menuGridGroup;
    static JMenu menuGridSub;
    static JPopupMenu menuPopup;
    static Color selectColor;
    static JButton selectDialog;
    static JLabel statusDialog;
    static JTabbedPane tabbedPanel;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 1) {
            IconEdit1.showHelp();
            System.exit(-1);
        } else if (stringArray.length == 1 && (((String)(object = stringArray[0].toLowerCase())).equals("?") || ((String)object).equals("-?") || ((String)object).equals("/?") || ((String)object).equals("-h") || ((String)object).equals("/h") || ((String)object).equals("-help") || ((String)object).equals("/help"))) {
            IconEdit1.showHelp();
            System.exit(0);
        }
        IconEdit1User iconEdit1User = new IconEdit1User("main");
        fileChooser = new JFileChooser();
        iconFilter = new IconEdit1Filter();
        fileChooser.setFileFilter(iconFilter);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        hiddenText = "This icon file was created by the IconEdit1 Java application on " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".";
        object = new JPanel(new FlowLayout(1, 20, 0));
        ((JComponent)object).setBackground(BACKGROUND);
        menuButton = new JButton("Icon Menu");
        menuButton.addActionListener(iconEdit1User);
        menuButton.setMnemonic(77);
        menuButton.setToolTipText("Add, delete, or move icon tabs.");
        ((Container)object).add(menuButton);
        fileClearButton = new JButton("Clear All Icons");
        fileClearButton.addActionListener(iconEdit1User);
        fileClearButton.setMnemonic(67);
        fileClearButton.setToolTipText("Clear current icons, all sizes.");
        ((Container)object).add(fileClearButton);
        fileOpenButton = new JButton("Open Icon File...");
        fileOpenButton.addActionListener(iconEdit1User);
        fileOpenButton.setMnemonic(79);
        fileOpenButton.setToolTipText("Read icon/icons from a file.");
        ((Container)object).add(fileOpenButton);
        fileSaveButton = new JButton("Save Icon File...");
        fileSaveButton.addActionListener(iconEdit1User);
        fileSaveButton.setMnemonic(83);
        fileSaveButton.setToolTipText("Save this/these icons to a file.");
        ((Container)object).add(fileSaveButton);
        exitButton = new JButton("Exit");
        exitButton.addActionListener(iconEdit1User);
        exitButton.setMnemonic(88);
        exitButton.setToolTipText("Close this program.");
        ((Container)object).add(exitButton);
        Box box = Box.createVerticalBox();
        box.setBackground(BACKGROUND);
        box.add(Box.createVerticalStrut(15));
        box.add((Component)object);
        box.add(Box.createVerticalStrut(3));
        menuPopup = new JPopupMenu();
        menuNew16 = new JMenuItem("New 16x16 Icon");
        menuNew16.addActionListener(iconEdit1User);
        menuPopup.add(menuNew16);
        menuNew24 = new JMenuItem("New 24x24 Icon");
        menuNew24.addActionListener(iconEdit1User);
        menuPopup.add(menuNew24);
        menuNew32 = new JMenuItem("New 32x32 Icon");
        menuNew32.addActionListener(iconEdit1User);
        menuPopup.add(menuNew32);
        menuNew48 = new JMenuItem("New 48x48 Icon");
        menuNew48.addActionListener(iconEdit1User);
        menuPopup.add(menuNew48);
        menuNew64 = new JMenuItem("New 64x64 Icon");
        menuNew64.addActionListener(iconEdit1User);
        menuPopup.add(menuNew64);
        menuNewSize = new JMenuItem("New Icon Size...");
        menuNewSize.addActionListener(iconEdit1User);
        menuPopup.add(menuNewSize);
        menuPopup.addSeparator();
        menuDelete = new JMenuItem("Delete Selected Icon");
        menuDelete.addActionListener(iconEdit1User);
        menuPopup.add(menuDelete);
        menuPopup.addSeparator();
        menuMoveUp = new JMenuItem("Move Selected Up");
        menuMoveUp.addActionListener(iconEdit1User);
        menuMoveUp.setMnemonic(85);
        menuPopup.add(menuMoveUp);
        menuMoveDown = new JMenuItem("Move Selected Down");
        menuMoveDown.addActionListener(iconEdit1User);
        menuMoveDown.setMnemonic(68);
        menuMoveDown.setDisplayedMnemonicIndex(14);
        menuPopup.add(menuMoveDown);
        menuPopup.addSeparator();
        menuErase = new JMenuItem("Erase Selected Color");
        menuErase.addActionListener(iconEdit1User);
        menuPopup.add(menuErase);
        menuText = new JMenuItem("Set Hidden Text...");
        menuText.addActionListener(iconEdit1User);
        menuPopup.add(menuText);
        menuGridGroup = new ButtonGroup();
        menuGridSub = new JMenu("Show Gridlines");
        menuGridSub.setMnemonic(71);
        menuGridBack = new JRadioButtonMenuItem("Background Color", false);
        menuGridBack.addActionListener(iconEdit1User);
        menuGridGroup.add(menuGridBack);
        menuGridSub.add(menuGridBack);
        menuGridHide = new JRadioButtonMenuItem("Hide Gridlines", false);
        menuGridHide.addActionListener(iconEdit1User);
        menuGridGroup.add(menuGridHide);
        menuGridSub.add(menuGridHide);
        menuGridNorm = new JRadioButtonMenuItem("Normal (Light Cyan)", true);
        menuGridNorm.addActionListener(iconEdit1User);
        menuGridGroup.add(menuGridNorm);
        menuGridSub.add(menuGridNorm);
        menuPopup.add(menuGridSub);
        tabbedPanel = new JTabbedPane(2);
        tabbedPanel.setBackground(BACKGROUND);
        colorChooser = new JColorChooser();
        colorChooser.getSelectionModel().addChangeListener(iconEdit1User);
        colorDialog = JColorChooser.createDialog(mainFrame, "Select Color", false, colorChooser, null, null);
        colorDialog.setLocation(400, 200);
        colorDialog.setVisible(true);
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBackground(BACKGROUND);
        statusDialog = new JLabel(COPYRIGHT_NOTICE, 2);
        jPanel.add((Component)statusDialog, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setBackground(BACKGROUND);
        selectDialog = new JButton("RGB (255,255,255)");
        selectDialog.addActionListener(iconEdit1User);
        selectDialog.setFocusable(false);
        selectDialog.setToolTipText("Selected color for painting.");
        IconEdit1.getSelectedColor();
        jPanel2.add(selectDialog);
        jPanel2.add(Box.createHorizontalStrut(15));
        colorButton = new JButton("Show Colors");
        colorButton.addActionListener(iconEdit1User);
        colorButton.setMnemonic(72);
        colorButton.setToolTipText("Show color selection tool.");
        jPanel2.add(colorButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.setBackground(BACKGROUND);
        jPanel3.add(Box.createVerticalStrut(1), "North");
        jPanel3.add(Box.createHorizontalStrut(15), "West");
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add(Box.createHorizontalStrut(15), "East");
        jPanel3.add(Box.createVerticalStrut(7), "South");
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        jPanel4.setBackground(BACKGROUND);
        jPanel4.add((Component)box, "North");
        jPanel4.add(Box.createHorizontalStrut(1), "West");
        jPanel4.add((Component)tabbedPanel, "Center");
        jPanel4.add(Box.createHorizontalStrut(6), "East");
        jPanel4.add((Component)jPanel3, "South");
        mainFrame = new JFrame(PROGRAM_TITLE);
        JPanel jPanel5 = (JPanel)mainFrame.getContentPane();
        jPanel5.setBackground(BACKGROUND);
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add((Component)jPanel4, "Center");
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocation(50, 50);
        mainFrame.setSize(700, 500);
        mainFrame.validate();
        mainFrame.setVisible(true);
        InputMap inputMap = jPanel5.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(67, 2), CURRENT_COPY);
        inputMap.put(KeyStroke.getKeyStroke(86, 2), CURRENT_PASTE);
        ActionMap actionMap = jPanel5.getActionMap();
        actionMap.put(CURRENT_COPY, new IconEdit1User(CURRENT_COPY));
        actionMap.put(CURRENT_PASTE, new IconEdit1User(CURRENT_PASTE));
        if (stringArray.length > 0) {
            IconEdit1.readIconFile(new File(stringArray[0]));
        } else {
            IconEdit1.clearFileIcons();
        }
    }

    static boolean canWriteFile(File file) {
        boolean bl;
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(mainFrame, file.getName() + " is a directory or folder.\nPlease select a normal file.");
            bl = false;
        } else if (file.isHidden()) {
            JOptionPane.showMessageDialog(mainFrame, file.getName() + " is a hidden or protected file.\nPlease select a normal file.");
            bl = false;
        } else if (!file.isFile()) {
            bl = true;
        } else if (file.canWrite()) {
            bl = JOptionPane.showConfirmDialog(mainFrame, file.getName() + " already exists.\nDo you want to replace this with a new file?") == 0;
        } else {
            JOptionPane.showMessageDialog(mainFrame, file.getName() + " is locked or write protected.\nCan't write to this file.");
            bl = false;
        }
        return bl;
    }

    static void clearFileIcons() {
        tabbedPanel.removeAll();
        tabbedPanel.addTab("16 x 16", new IconEdit1Icon(16));
        tabbedPanel.addTab("24 x 24", new IconEdit1Icon(24));
        tabbedPanel.addTab("32 x 32", new IconEdit1Icon(32));
        tabbedPanel.addTab("48 x 48", new IconEdit1Icon(48));
        tabbedPanel.addTab("64 x 64", new IconEdit1Icon(64));
    }

    static boolean colorsAreWebSafe(Color[][] colorArray) {
        boolean bl = true;
        for (int i = 0; i < colorArray.length; ++i) {
            for (int j = 0; j < colorArray[i].length; ++j) {
                int n = colorArray[i][j].getBlue();
                int n2 = colorArray[i][j].getGreen();
                int n3 = colorArray[i][j].getRed();
                if (n % 51 == 0 && n2 % 51 == 0 && n3 % 51 == 0) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    static boolean colorsAreWindows16(Color[][] colorArray) {
        boolean bl = true;
        for (int i = 0; i < colorArray.length; ++i) {
            for (int j = 0; j < colorArray[i].length; ++j) {
                int n = colorArray[i][j].getBlue();
                int n2 = colorArray[i][j].getGreen();
                int n3 = colorArray[i][j].getRed();
                boolean bl2 = false;
                for (int k = 0; k < SIXTEEN_COLORS.length; ++k) {
                    if (n3 != SIXTEEN_COLORS[k][0] || n2 != SIXTEEN_COLORS[k][1] || n != SIXTEEN_COLORS[k][2]) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    static void createNewIconSize() {
        String string = JOptionPane.showInputDialog(mainFrame, "Enter an icon size from 8 to 255 pixels:", "32");
        if (string != null) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 8 || n > 255) {
                JOptionPane.showMessageDialog(mainFrame, "Please enter an integer from 8 to 255 for the icon size,\nwithout extra spaces or punctuation (decimal point, etc).");
            } else {
                tabbedPanel.addTab(n + " x " + n, new IconEdit1Icon(n));
                tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
            }
        }
    }

    static void eraseSelectedColor() {
        int n = tabbedPanel.getSelectedIndex();
        if (n < 0) {
            statusDialog.setText("Can't erase colors if no icon tab is selected.");
        } else {
            int n2 = 0;
            IconEdit1Icon iconEdit1Icon = (IconEdit1Icon)tabbedPanel.getComponentAt(n);
            for (int i = 0; i < iconEdit1Icon.size; ++i) {
                for (int j = 0; j < iconEdit1Icon.size; ++j) {
                    if (!iconEdit1Icon.colors[i][j].equals(selectColor)) continue;
                    if (iconEdit1Icon.isOpaque[i][j]) {
                        ++n2;
                    }
                    iconEdit1Icon.colors[i][j] = Color.BLACK;
                    iconEdit1Icon.isOpaque[i][j] = false;
                }
            }
            iconEdit1Icon.repaint();
            if (n2 > 1) {
                statusDialog.setText("Found and erased/replaced " + n2 + " pixels/squares.");
            } else if (n2 > 0) {
                statusDialog.setText("Found and erased/replaced only one pixel/square.");
            } else {
                statusDialog.setText("Sorry, no pixels/squares have the RGB color (" + selectColor.getRed() + "," + selectColor.getGreen() + "," + selectColor.getBlue() + ").");
            }
        }
    }

    static Color getCloseColor(int n, Color color) {
        Color color2;
        if (n == 4) {
            int n2 = IconEdit1.getCloseWin16Index(color);
            color2 = new Color(SIXTEEN_COLORS[n2][0], SIXTEEN_COLORS[n2][1], SIXTEEN_COLORS[n2][2]);
        } else {
            color2 = n == 8 ? new Color((int)(((double)color.getRed() + 25.5) / 51.0) * 51, (int)(((double)color.getGreen() + 25.5) / 51.0) * 51, (int)(((double)color.getBlue() + 25.5) / 51.0) * 51) : color;
        }
        return color2;
    }

    static int getCloseWin16Index(Color color) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 999999999;
        int n5 = color.getBlue();
        int n6 = color.getGreen();
        int n7 = color.getRed();
        int n8 = -1;
        for (int i = 0; i < SIXTEEN_COLORS.length; ++i) {
            int n9 = SIXTEEN_COLORS[i][2];
            int n10 = SIXTEEN_COLORS[i][1];
            int n11 = SIXTEEN_COLORS[i][0];
            int n12 = (n5 - n9) * (n5 - n9) + (n6 - n10) * (n6 - n10) + (n7 - n11) * (n7 - n11);
            if (n12 >= n4) continue;
            n3 = n9;
            n4 = n12;
            n2 = n10;
            n = n11;
            n8 = i;
        }
        return n8;
    }

    static void getSelectedColor() {
        selectColor = colorChooser.getColor();
        int n = selectColor.getBlue();
        int n2 = selectColor.getGreen();
        int n3 = selectColor.getRed();
        selectDialog.setBackground(selectColor);
        selectDialog.setForeground(new Color((n3 + 128) % 256, (n2 + 128) % 256, (n + 128) % 256));
        selectDialog.setText("RGB (" + n3 + "," + n2 + "," + n + ")");
    }

    static void readIconFile(File file) {
        File file2;
        if (file == null) {
            fileChooser.setDialogTitle("Open Icon File...");
            if (fileChooser.showOpenDialog(mainFrame) != 0) {
                return;
            }
            file2 = fileChooser.getSelectedFile();
        } else {
            fileChooser.setCurrentDirectory(file);
            fileChooser.setSelectedFile(file);
            file2 = file;
        }
        long l = file2.length();
        boolean bl = false;
        String string = "";
        tabbedPanel.removeAll();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
            block2: for (int i = 0; i < 1; ++i) {
                if (l < 6L) {
                    bl = true;
                    string = "File too small for icon header: fileSize " + l + ".";
                    break;
                }
                int n = IconEdit1.readIconUnsignedShort(randomAccessFile);
                int n2 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                int n3 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                if (n != 0 || n2 != 1 && n2 != 2 || n3 < 1 || n3 > 99) {
                    bl = true;
                    string = "Unsupported icon header: idReserved " + n + ", idType " + n2 + ", idCount " + n3 + ".";
                    break;
                }
                if (l < (long)(n3 * 16 + 6)) {
                    bl = true;
                    string = "File too small for icon directory: fileSize " + l + ", idCount " + n3 + ".";
                    break;
                }
                for (int j = 0; j < n3; ++j) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    Color[] colorArray;
                    randomAccessFile.seek(j * 16 + 6);
                    int n12 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                    int n13 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                    int n14 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                    int n15 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                    int n16 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                    int n17 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                    int n18 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    long l2 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    if (n13 != n12 || n13 < 8 || n13 > 255) {
                        bl = true;
                        string = "Unsupported icon size: index " + j + ", bHeight " + n13 + ", bWidth " + n12 + ".";
                        continue block2;
                    }
                    if (l < (long)n18 + l2) {
                        bl = true;
                        string = "File too small for icon data: index " + j + ", dwImageOffset 0x" + Long.toHexString(l2) + ", dwBytesInRes " + n18 + ".";
                        continue block2;
                    }
                    randomAccessFile.seek(l2);
                    int n19 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n20 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n21 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n22 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                    int n23 = IconEdit1.readIconUnsignedShort(randomAccessFile);
                    int n24 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n25 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n26 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n27 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n28 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    int n29 = IconEdit1.readIconUnsignedInt(randomAccessFile);
                    if (n19 != 40 || n20 != n12 || n21 != 2 * n13 || n22 != 1) {
                        bl = true;
                        string = "Icon entry doesn't match header: index " + j + ", biWidth " + n20 + ", biHeight " + n21 + ".";
                        continue block2;
                    }
                    IconEdit1Icon iconEdit1Icon = new IconEdit1Icon(n12);
                    if (n23 == 1 && (n14 == 0 || n14 == 2)) {
                        colorArray = new Color[2];
                        for (n11 = 0; n11 < 2; ++n11) {
                            n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n9 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n8 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n7 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            colorArray[n11] = new Color(n8, n9, n10);
                        }
                        n6 = (n12 + 31) / 32 * 4 - (n12 + 7) / 8;
                        for (n5 = n12 - 1; n5 >= 0; --n5) {
                            n11 = -1;
                            n10 = 0;
                            for (n4 = 0; n4 < n12; ++n4) {
                                if (n11 < 0) {
                                    n11 = 7;
                                    n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                }
                                iconEdit1Icon.colors[n5][n4] = colorArray[n10 >> n11 & 1];
                                iconEdit1Icon.isOpaque[n5][n4] = true;
                                --n11;
                            }
                            for (n9 = 0; n9 < n6; ++n9) {
                                IconEdit1.readIconUnsignedByte(randomAccessFile);
                            }
                        }
                    } else if (n23 == 4 && (n14 == 0 || n14 == 16)) {
                        colorArray = new Color[16];
                        for (n11 = 0; n11 < 16; ++n11) {
                            n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n9 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n8 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n7 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            colorArray[n11] = new Color(n8, n9, n10);
                        }
                        n6 = (n12 + 7) / 8 * 4 - (n12 + 1) / 2;
                        for (n5 = n12 - 1; n5 >= 0; --n5) {
                            n11 = -1;
                            n10 = 0;
                            for (n4 = 0; n4 < n12; ++n4) {
                                if (n11 < 0) {
                                    n11 = 4;
                                    n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                }
                                iconEdit1Icon.colors[n5][n4] = colorArray[n10 >> n11 & 0xF];
                                iconEdit1Icon.isOpaque[n5][n4] = true;
                                n11 -= 4;
                            }
                            for (n9 = 0; n9 < n6; ++n9) {
                                IconEdit1.readIconUnsignedByte(randomAccessFile);
                            }
                        }
                    } else if (n23 == 8 && n14 == 0) {
                        colorArray = new Color[256];
                        for (n11 = 0; n11 < 256; ++n11) {
                            n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n9 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n8 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            n7 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            colorArray[n11] = new Color(n8, n9, n10);
                        }
                        n6 = (n12 + 3) / 4 * 4 - n12;
                        for (n5 = n12 - 1; n5 >= 0; --n5) {
                            for (n4 = 0; n4 < n12; ++n4) {
                                n11 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                iconEdit1Icon.colors[n5][n4] = colorArray[n11];
                                iconEdit1Icon.isOpaque[n5][n4] = true;
                            }
                            for (n11 = 0; n11 < n6; ++n11) {
                                IconEdit1.readIconUnsignedByte(randomAccessFile);
                            }
                        }
                    } else if (n23 == 24 && n14 == 0) {
                        n6 = (n12 * 3 + 3) / 4 * 4 - n12 * 3;
                        for (n5 = n12 - 1; n5 >= 0; --n5) {
                            for (n4 = 0; n4 < n12; ++n4) {
                                n11 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                n9 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                iconEdit1Icon.colors[n5][n4] = new Color(n9, n10, n11);
                                iconEdit1Icon.isOpaque[n5][n4] = true;
                            }
                            for (n11 = 0; n11 < n6; ++n11) {
                                IconEdit1.readIconUnsignedByte(randomAccessFile);
                            }
                        }
                    } else if (n23 == 32 && n14 == 0) {
                        for (n5 = n12 - 1; n5 >= 0; --n5) {
                            for (n4 = 0; n4 < n12; ++n4) {
                                n11 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                n9 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                n8 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                                iconEdit1Icon.colors[n5][n4] = new Color(n9, n10, n11);
                                iconEdit1Icon.isOpaque[n5][n4] = true;
                            }
                        }
                    } else {
                        bl = true;
                        string = "Unsupported color depth: index " + j + ", biBitCount " + n23 + ", bColorCount " + n14 + ".";
                        continue block2;
                    }
                    n6 = (n12 + 31) / 32 * 4 - (n12 + 7) / 8;
                    for (n5 = n12 - 1; n5 >= 0; --n5) {
                        n11 = -1;
                        n10 = 0;
                        for (n4 = 0; n4 < n12; ++n4) {
                            if (n11 < 0) {
                                n11 = 7;
                                n10 = IconEdit1.readIconUnsignedByte(randomAccessFile);
                            }
                            if ((n10 >> n11 & 1) == 1) {
                                iconEdit1Icon.colors[n5][n4] = Color.BLACK;
                                iconEdit1Icon.isOpaque[n5][n4] = false;
                            }
                            --n11;
                        }
                        for (n9 = 0; n9 < n6; ++n9) {
                            IconEdit1.readIconUnsignedByte(randomAccessFile);
                        }
                    }
                    if (IconEdit1.colorsAreWindows16(iconEdit1Icon.colors)) {
                        iconEdit1Icon.colorDepth = 4;
                        iconEdit1Icon.depthBit4.setSelected(true);
                    } else if (IconEdit1.colorsAreWebSafe(iconEdit1Icon.colors)) {
                        iconEdit1Icon.colorDepth = 8;
                        iconEdit1Icon.depthBit8.setSelected(true);
                    } else {
                        iconEdit1Icon.colorDepth = 24;
                        iconEdit1Icon.depthBit24.setSelected(true);
                    }
                    tabbedPanel.addTab(n12 + " x " + n12, iconEdit1Icon);
                }
            }
            randomAccessFile.close();
            mainFrame.setTitle("Icon Editor - " + file2.getName());
        }
        catch (IOException iOException) {
            bl = true;
            string = "Can't read from input file:\n" + iOException.getMessage();
        }
        if (bl) {
            mainFrame.setTitle(PROGRAM_TITLE);
            IconEdit1.clearFileIcons();
            JOptionPane.showMessageDialog(mainFrame, string);
        }
    }

    static int readIconUnsignedByte(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.read() & 0xFF;
    }

    static int readIconUnsignedInt(RandomAccessFile randomAccessFile) throws IOException {
        return (IconEdit1.readIconUnsignedByte(randomAccessFile) | IconEdit1.readIconUnsignedByte(randomAccessFile) << 8 | IconEdit1.readIconUnsignedByte(randomAccessFile) << 16 | IconEdit1.readIconUnsignedByte(randomAccessFile) << 24) & Integer.MAX_VALUE;
    }

    static int readIconUnsignedShort(RandomAccessFile randomAccessFile) throws IOException {
        return (IconEdit1.readIconUnsignedByte(randomAccessFile) | IconEdit1.readIconUnsignedByte(randomAccessFile) << 8) & 0xFFFF;
    }

    static void showHelp() {
        System.err.println();
        System.err.println(PROGRAM_TITLE);
        System.err.println();
        System.err.println("This is a graphical application.  There are no options.  The only parameter");
        System.err.println("that you may give on the command line is a single icon file name.");
        System.err.println();
        System.err.println(COPYRIGHT_NOTICE);
    }

    static void userButton(String string, ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == colorButton) {
            statusDialog.setText(EMPTY_STATUS);
            colorDialog.setVisible(true);
        } else if (object == exitButton) {
            System.exit(0);
        } else if (object == fileClearButton) {
            statusDialog.setText(EMPTY_STATUS);
            if (JOptionPane.showConfirmDialog(mainFrame, "Erase all icons, all sizes?") == 0) {
                IconEdit1.clearFileIcons();
                fileChooser.setSelectedFile(new File(""));
                mainFrame.setTitle(PROGRAM_TITLE);
            }
        } else if (object == fileOpenButton) {
            statusDialog.setText(EMPTY_STATUS);
            IconEdit1.readIconFile(null);
        } else if (object == fileSaveButton) {
            statusDialog.setText(EMPTY_STATUS);
            IconEdit1.writeIconFile();
        } else if (object == menuButton) {
            statusDialog.setText(EMPTY_STATUS);
            menuPopup.show(menuButton, 0, menuButton.getHeight());
        } else if (object == menuDelete) {
            int n = tabbedPanel.getSelectedIndex();
            if (n < 0) {
                statusDialog.setText("Can't delete selected icon if no icon tab is selected.");
            } else {
                tabbedPanel.remove(n);
            }
        } else if (object == menuErase) {
            IconEdit1.eraseSelectedColor();
        } else if (object == menuGridBack || object == menuGridHide || object == menuGridNorm) {
            int n = tabbedPanel.getSelectedIndex();
            if (n >= 0) {
                tabbedPanel.getComponentAt(n).repaint();
            }
        } else if (object == menuMoveDown) {
            int n = tabbedPanel.getSelectedIndex();
            if (n < 0) {
                statusDialog.setText("Can't move selected icon if no icon tab is selected.");
            } else if (n >= tabbedPanel.getTabCount() - 1) {
                statusDialog.setText("Can't move last icon tab down any further.");
            } else {
                Component component = tabbedPanel.getComponentAt(n);
                String string2 = tabbedPanel.getTitleAt(n);
                tabbedPanel.removeTabAt(n);
                tabbedPanel.insertTab(string2, null, component, null, n + 1);
                tabbedPanel.setSelectedIndex(n + 1);
            }
        } else if (object == menuMoveUp) {
            int n = tabbedPanel.getSelectedIndex();
            if (n < 0) {
                statusDialog.setText("Can't move selected icon if no icon tab is selected.");
            } else if (n < 1) {
                statusDialog.setText("Can't move first icon tab up any further.");
            } else {
                Component component = tabbedPanel.getComponentAt(n);
                String string3 = tabbedPanel.getTitleAt(n);
                tabbedPanel.removeTabAt(n);
                tabbedPanel.insertTab(string3, null, component, null, n - 1);
                tabbedPanel.setSelectedIndex(n - 1);
            }
        } else if (object == menuNew16) {
            tabbedPanel.addTab("16 x 16", new IconEdit1Icon(16));
            tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
        } else if (object == menuNew24) {
            tabbedPanel.addTab("24 x 24", new IconEdit1Icon(24));
            tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
        } else if (object == menuNew32) {
            tabbedPanel.addTab("32 x 32", new IconEdit1Icon(32));
            tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
        } else if (object == menuNew48) {
            tabbedPanel.addTab("48 x 48", new IconEdit1Icon(48));
            tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
        } else if (object == menuNew64) {
            tabbedPanel.addTab("64 x 64", new IconEdit1Icon(64));
            tabbedPanel.setSelectedIndex(tabbedPanel.getTabCount() - 1);
        } else if (object == menuNewSize) {
            IconEdit1.createNewIconSize();
        } else if (object == menuText) {
            String string4 = JOptionPane.showInputDialog(mainFrame, "Enter a text string that will be hidden inside new icon files.  The current text is:", hiddenText);
            if (string4 != null) {
                hiddenText = string4;
            }
        } else if (object == selectDialog) {
            colorButton.requestFocusInWindow();
            statusDialog.setText(EMPTY_STATUS);
            colorDialog.setVisible(true);
        } else if (string.equals(CURRENT_COPY)) {
            int n = tabbedPanel.getSelectedIndex();
            if (n < 0) {
                statusDialog.setText("Can't copy selected icon if no icon tab is selected.");
            } else {
                statusDialog.setText(EMPTY_STATUS);
                ((IconEdit1Icon)tabbedPanel.getComponentAt(n)).copyThisIcon();
            }
        } else if (string.equals(CURRENT_PASTE)) {
            int n = tabbedPanel.getSelectedIndex();
            if (n < 0) {
                statusDialog.setText("Can't paste selected icon if no icon tab is selected.");
            } else {
                statusDialog.setText(EMPTY_STATUS);
                ((IconEdit1Icon)tabbedPanel.getComponentAt(n)).pasteThisIcon();
            }
        } else {
            System.err.println("Error in userButton(): unknown ActionEvent: " + actionEvent);
        }
    }

    static void writeIconFile() {
        int n;
        int n2;
        int n3;
        int n4 = tabbedPanel.getTabCount();
        if (n4 == 0) {
            JOptionPane.showMessageDialog(mainFrame, "There are no icon tabs open, so there is nothing to save.");
            return;
        }
        byte[][] byArrayArray = new byte[n4][];
        IconEdit1Icon[] iconEdit1IconArray = new IconEdit1Icon[n4];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            IconEdit1Icon iconEdit1Icon = (IconEdit1Icon)tabbedPanel.getComponentAt(i);
            boolean bl = true;
            for (n10 = 0; n10 < iconEdit1Icon.size; ++n10) {
                for (n9 = 0; n9 < iconEdit1Icon.size; ++n9) {
                    if (!iconEdit1Icon.isOpaque[n10][n9]) continue;
                    bl = false;
                    break;
                }
                if (!bl) break;
            }
            if (bl) continue;
            iconEdit1IconArray[n5] = iconEdit1Icon;
            if (!iconEdit1Icon.depthWarning) {
                int n11;
                if (IconEdit1.colorsAreWindows16(iconEdit1Icon.colors)) {
                    if (iconEdit1Icon.colorDepth != 4) {
                        n11 = JOptionPane.showConfirmDialog(mainFrame, "Icon #" + (i + 1) + " at " + iconEdit1Icon.size + "x" + iconEdit1Icon.size + " should be saved with a 16-color palette.  Change this?");
                        iconEdit1Icon.depthWarning = true;
                        if (n11 == 2) {
                            return;
                        }
                        if (n11 == 0) {
                            iconEdit1Icon.colorDepth = 4;
                            iconEdit1Icon.depthBit4.setSelected(true);
                        }
                    }
                } else if (IconEdit1.colorsAreWebSafe(iconEdit1Icon.colors)) {
                    if (iconEdit1Icon.colorDepth != 8) {
                        n11 = JOptionPane.showConfirmDialog(mainFrame, "Icon #" + (i + 1) + " at " + iconEdit1Icon.size + "x" + iconEdit1Icon.size + " should be saved with a 256-color palette.  Change this?");
                        iconEdit1Icon.depthWarning = true;
                        if (n11 == 2) {
                            return;
                        }
                        if (n11 == 0) {
                            iconEdit1Icon.colorDepth = 8;
                            iconEdit1Icon.depthBit8.setSelected(true);
                        }
                    }
                } else if (iconEdit1Icon.colorDepth != 24) {
                    n11 = JOptionPane.showConfirmDialog(mainFrame, "Icon #" + (i + 1) + " at " + iconEdit1Icon.size + "x" + iconEdit1Icon.size + " should be saved with 24-bit RGB colors.  Change this?");
                    iconEdit1Icon.depthWarning = true;
                    if (n11 == 2) {
                        return;
                    }
                    if (n11 == 0) {
                        iconEdit1Icon.colorDepth = 24;
                        iconEdit1Icon.depthBit24.setSelected(true);
                    }
                }
            }
            int n12 = 40;
            if (iconEdit1Icon.colorDepth == 4) {
                n12 += 64;
                n8 = iconEdit1Icon.size * ((iconEdit1Icon.size + 7) / 8 * 4);
            } else if (iconEdit1Icon.colorDepth == 8) {
                n12 += 1024;
                n8 = iconEdit1Icon.size * ((iconEdit1Icon.size + 3) / 4 * 4);
            } else {
                n12 += 0;
                n8 = iconEdit1Icon.size * ((iconEdit1Icon.size * 3 + 3) / 4 * 4);
            }
            byte[] byArray = new byte[n12 += (n8 += iconEdit1Icon.size * ((iconEdit1Icon.size + 31) / 32 * 4))];
            n3 = IconEdit1.writeIconUnsignedInt(byArray, 0, 40);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, iconEdit1Icon.size);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, iconEdit1Icon.size * 2);
            n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, 1);
            n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, iconEdit1Icon.colorDepth);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, 0);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, n8);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, 0);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, 0);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, 0);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, 0);
            if (iconEdit1Icon.colorDepth == 4) {
                for (n2 = 0; n2 < SIXTEEN_COLORS.length; ++n2) {
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, SIXTEEN_COLORS[n2][2]);
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, SIXTEEN_COLORS[n2][1]);
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, SIXTEEN_COLORS[n2][0]);
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                }
                n7 = (iconEdit1Icon.size + 7) / 8 * 4 - (iconEdit1Icon.size + 1) / 2;
                for (n10 = iconEdit1Icon.size - 1; n10 >= 0; --n10) {
                    n2 = 4;
                    n = 0;
                    for (n9 = 0; n9 < iconEdit1Icon.size; ++n9) {
                        if (n2 < 0) {
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n);
                            n2 = 4;
                            n = 0;
                        }
                        if (iconEdit1Icon.isOpaque[n10][n9]) {
                            n |= IconEdit1.getCloseWin16Index(iconEdit1Icon.colors[n10][n9]) << n2;
                        }
                        n2 -= 4;
                    }
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n);
                    for (n6 = 0; n6 < n7; ++n6) {
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                    }
                }
            } else if (iconEdit1Icon.colorDepth == 8) {
                for (n2 = 0; n2 <= 255; n2 += 51) {
                    for (n = 0; n <= 255; n += 51) {
                        for (n6 = 0; n6 <= 255; n6 += 51) {
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n6);
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n2);
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n);
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                        }
                    }
                }
                for (n2 = 0; n2 < 160; ++n2) {
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                }
                n7 = (iconEdit1Icon.size + 3) / 4 * 4 - iconEdit1Icon.size;
                for (n10 = iconEdit1Icon.size - 1; n10 >= 0; --n10) {
                    for (n9 = 0; n9 < iconEdit1Icon.size; ++n9) {
                        if (iconEdit1Icon.isOpaque[n10][n9]) {
                            n2 = (int)(((double)iconEdit1Icon.colors[n10][n9].getGreen() + 25.5) / 51.0) * 36;
                            n2 += (int)(((double)iconEdit1Icon.colors[n10][n9].getRed() + 25.5) / 51.0) * 6;
                            n2 += (int)(((double)iconEdit1Icon.colors[n10][n9].getBlue() + 25.5) / 51.0);
                        } else {
                            n2 = 0;
                        }
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n2);
                    }
                    for (n2 = 0; n2 < n7; ++n2) {
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                    }
                }
            } else {
                n7 = (iconEdit1Icon.size * 3 + 3) / 4 * 4 - iconEdit1Icon.size * 3;
                for (n10 = iconEdit1Icon.size - 1; n10 >= 0; --n10) {
                    for (n9 = 0; n9 < iconEdit1Icon.size; ++n9) {
                        if (iconEdit1Icon.isOpaque[n10][n9]) {
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1Icon.colors[n10][n9].getBlue());
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1Icon.colors[n10][n9].getGreen());
                            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1Icon.colors[n10][n9].getRed());
                            continue;
                        }
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                    }
                    for (n2 = 0; n2 < n7; ++n2) {
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                    }
                }
            }
            n7 = (iconEdit1Icon.size + 31) / 32 * 4 - (iconEdit1Icon.size + 7) / 8;
            for (n10 = iconEdit1Icon.size - 1; n10 >= 0; --n10) {
                n2 = 7;
                n = 0;
                for (n9 = 0; n9 < iconEdit1Icon.size; ++n9) {
                    if (n2 < 0) {
                        n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n);
                        n2 = 7;
                        n = 0;
                    }
                    if (!iconEdit1Icon.isOpaque[n10][n9]) {
                        n |= 1 << n2;
                    }
                    --n2;
                }
                n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, n);
                for (n6 = 0; n6 < n7; ++n6) {
                    n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
                }
            }
            if (n3 != byArray.length) {
                System.err.println("Icon #" + (i + 1) + " image data has wrong size: bufferIndex " + n3 + ", thisImageData.length " + byArray.length + ".");
            }
            byArrayArray[n5] = byArray;
            ++n5;
        }
        if (n5 == 0) {
            JOptionPane.showMessageDialog(mainFrame, "All icons are empty (completely transparent).  There is nothing to save.");
            return;
        }
        byte[] byArray = new byte[n5 * 16 + 6];
        n3 = IconEdit1.writeIconUnsignedShort(byArray, 0, 0);
        n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, 1);
        n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, n5);
        int n13 = byArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1IconArray[n2].size);
            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1IconArray[n2].size);
            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, iconEdit1IconArray[n2].colorDepth == 4 ? 16 : 0);
            n3 = IconEdit1.writeIconUnsignedByte(byArray, n3, 0);
            n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, 1);
            n3 = IconEdit1.writeIconUnsignedShort(byArray, n3, iconEdit1IconArray[n2].colorDepth);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, byArrayArray[n2].length);
            n3 = IconEdit1.writeIconUnsignedInt(byArray, n3, n13);
            n13 += byArrayArray[n2].length;
        }
        if (n3 != byArray.length) {
            System.err.println("Icon file header has wrong size: bufferIndex " + n3 + ", fileHeader.length " + byArray.length + ".");
        }
        fileChooser.setDialogTitle("Save Icon File...");
        if (fileChooser.showSaveDialog(mainFrame) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            if (IconEdit1.canWriteFile(file)) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                int n14 = byArray.length;
                for (n2 = 0; n2 < n5; ++n2) {
                    fileOutputStream.write(byArrayArray[n2]);
                    n14 += byArrayArray[n2].length;
                }
                for (n2 = (n14 + 15) / 16 * 16 - n14; n2 > 0; --n2) {
                    fileOutputStream.write(0);
                    ++n14;
                }
                if (hiddenText.length() > 0) {
                    byte[] byArray2 = hiddenText.getBytes();
                    fileOutputStream.write(byArray2);
                    for (n = ((n14 += byArray2.length) + 15) / 16 * 16 - n14; n > 0; --n) {
                        fileOutputStream.write(0);
                        ++n14;
                    }
                }
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(mainFrame, "Can't write to output file: " + iOException.getMessage());
        }
    }

    static int writeIconUnsignedByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
        return n + 1;
    }

    static int writeIconUnsignedInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
        return n + 4;
    }

    static int writeIconUnsignedShort(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        return n + 2;
    }
}

