/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.util.ExprParser;
import groove.verify.FormulaParser;
import groove.verify.ParseException;
import java.util.Stack;

public class Formula {
    private final FormulaParser.Token token;
    private final Formula arg1;
    private final Formula arg2;
    private final String prop;
    public static final String OPEN_ATOM = "$open";
    public static final String FINAL_ATOM = "$open";

    Formula(FormulaParser.Token kind, Formula arg1, Formula arg2, String prop) {
        this.token = kind;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.prop = prop;
    }

    Formula(FormulaParser.Token operator) {
        this(operator, null, null, null);
        assert (operator.getArity() == 0 && operator != FormulaParser.Token.ATOM);
    }

    Formula(FormulaParser.Token operator, Formula arg) {
        this(operator, arg, null, null);
        assert (operator.getArity() == 1);
    }

    Formula(FormulaParser.Token token, Formula arg1, Formula arg2) {
        this(token, arg1, arg2, null);
        assert (token.getArity() == 2);
    }

    private Formula(String prop) {
        this(FormulaParser.Token.ATOM, null, null, prop);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.arg1 == null ? 0 : this.arg1.hashCode());
        result = 31 * result + (this.arg2 == null ? 0 : this.arg2.hashCode());
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        result = 31 * result + (this.prop == null ? 0 : this.prop.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Formula other = (Formula)obj;
        if (this.token != other.token) {
            return false;
        }
        if (this.arg1 != null && !this.arg1.equals(other.arg1)) {
            return false;
        }
        if (this.arg2 != null && !this.arg2.equals(other.arg2)) {
            return false;
        }
        return this.prop == null || this.prop.equals(other.prop);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.toString(result);
        return result.toString();
    }

    private void toString(StringBuffer b) {
        switch (this.getToken().getArity()) {
            case 0: {
                if (this.getToken() == FormulaParser.Token.ATOM) {
                    String text = this.getProp();
                    if (this.isAtom(text)) {
                        b.append(this.getProp());
                        break;
                    }
                    b.append(ExprParser.toQuoted(text, '\''));
                    break;
                }
                b.append((Object)this.getToken());
                break;
            }
            case 1: {
                b.append((Object)this.getToken());
                if (this.getArg1().getToken().getPriority() < this.getToken().getPriority()) {
                    this.getArg1().toParString(b);
                    break;
                }
                if (Character.isLetter(this.getToken().toString().charAt(0))) {
                    b.append(' ');
                }
                this.getArg1().toString(b);
                break;
            }
            default: {
                assert (this.getToken().getArity() == 2);
                boolean arg1Par = this.getArg1().getToken().getPriority() <= this.getToken().getPriority();
                boolean arg2Par = this.getArg2().getToken().getPriority() < this.getToken().getPriority();
                boolean opLetter = Character.isLetter(this.getToken().toString().charAt(0));
                if (arg1Par) {
                    this.getArg1().toParString(b);
                } else {
                    this.getArg1().toString(b);
                }
                if (opLetter && !arg1Par) {
                    b.append(' ');
                }
                b.append((Object)this.getToken());
                if (opLetter && !arg2Par) {
                    b.append(' ');
                }
                if (arg2Par) {
                    this.getArg2().toParString(b);
                    break;
                }
                this.getArg2().toString(b);
            }
        }
    }

    private void toParString(StringBuffer b) {
        b.append('(');
        this.toString(b);
        b.append(')');
    }

    public final String toTree() {
        StringBuilder result = new StringBuilder();
        this.toTree(new Stack<Boolean>(), result);
        result.append('\n');
        return result.toString();
    }

    private final void toTree(Stack<Boolean> indent, StringBuilder result) {
        switch (this.getToken().getArity()) {
            case 2: {
                result.append((Object)((Object)this.getToken()) + "+-");
                indent.push(true);
                this.getArg1().toTree(indent, result);
                result.append('\n');
                Formula.addIndent(indent, result);
                indent.pop();
                indent.push(false);
                this.getArg2().toTree(indent, result);
                indent.pop();
                break;
            }
            case 1: {
                result.append((Object)((Object)this.getToken()) + "--");
                indent.push(false);
                this.getArg1().toTree(indent, result);
                indent.pop();
                break;
            }
            case 0: {
                if (this.getToken() != FormulaParser.Token.ATOM) break;
                result.append(this.getToken() == FormulaParser.Token.ATOM ? this.getProp() : this.getToken());
            }
        }
    }

    private static final void addIndent(Stack<Boolean> indent, StringBuilder result) {
        int i = 0;
        while (i < indent.size()) {
            boolean b = (Boolean)indent.get(i);
            result.append(b ? (i == indent.size() - 1 ? " +--" : " |  ") : "    ");
            ++i;
        }
    }

    public FormulaParser.Token getToken() {
        return this.token;
    }

    public Formula getArg1() {
        return this.arg1;
    }

    public Formula getArg2() {
        return this.arg2;
    }

    public String getProp() {
        return this.prop;
    }

    public boolean isCtlFormula() {
        switch (this.getToken()) {
            case ATOM: 
            case TRUE: 
            case FALSE: {
                return true;
            }
            case NOT: {
                return this.getArg1().isCtlFormula();
            }
            case OR: 
            case AND: 
            case IMPLIES: 
            case FOLLOWS: 
            case EQUIV: {
                return this.getArg1().isCtlFormula() && this.getArg2().isCtlFormula();
            }
            case FORALL: 
            case EXISTS: {
                Formula arg = this.getArg1();
                switch (arg.getToken()) {
                    case NEXT: {
                        return arg.getArg1().isCtlFormula();
                    }
                    case UNTIL: {
                        return arg.getArg1().isCtlFormula() && arg.getArg2().isCtlFormula();
                    }
                }
                return false;
            }
        }
        return false;
    }

    public Formula toCtlFormula() throws ParseException {
        switch (this.getToken()) {
            case ATOM: 
            case TRUE: 
            case FALSE: {
                return this;
            }
            case NOT: {
                return Formula.Not(this.getArg1().toCtlFormula());
            }
            case OR: 
            case AND: 
            case IMPLIES: 
            case FOLLOWS: 
            case EQUIV: {
                return new Formula(this.getToken(), this.getArg1().toCtlFormula(), this.getArg2().toCtlFormula());
            }
            case NEXT: 
            case UNTIL: 
            case ALWAYS: 
            case EVENTUALLY: {
                throw new ParseException("Temporal operator '%s' should be nested inside path quantifier in CTL formula", new Object[]{this.getToken()});
            }
            case W_UNTIL: 
            case RELEASE: 
            case S_RELEASE: {
                throw new ParseException("Temporal operator '%s' not allowed in CTL formula", new Object[]{this.getToken()});
            }
            case FORALL: 
            case EXISTS: {
                FormulaParser.Token subKind = this.getArg1().getToken();
                Formula subArg1 = this.getArg1().getArg1();
                Formula subArg2 = this.getArg1().getArg2();
                switch (subKind) {
                    case NEXT: {
                        return new Formula(this.getToken(), Formula.Next(subArg1.toCtlFormula()));
                    }
                    case ALWAYS: {
                        FormulaParser.Token dual = this.getToken() == FormulaParser.Token.EXISTS ? FormulaParser.Token.FORALL : FormulaParser.Token.EXISTS;
                        return Formula.Not(new Formula(dual, Formula.Until(Formula.True(), Formula.Not(subArg1.toCtlFormula()))));
                    }
                    case EVENTUALLY: {
                        return new Formula(this.getToken(), Formula.Until(Formula.True(), subArg1.toCtlFormula()));
                    }
                    case UNTIL: {
                        return new Formula(this.getToken(), Formula.Until(subArg1.toCtlFormula(), subArg2.toCtlFormula()));
                    }
                    case W_UNTIL: 
                    case RELEASE: 
                    case S_RELEASE: {
                        throw new ParseException("Temporal operator '%s' not allowed in CTL formula", new Object[]{subKind});
                    }
                }
                throw new ParseException("Path quantifier '%s' must have nested temporal operator in CTL formula", new Object[]{this.getToken()});
            }
        }
        throw new ParseException("Unknown temporal operator %s", new Object[]{this.getToken()});
    }

    public gov.nasa.ltl.trans.Formula<String> toLtlFormula() throws ParseException {
        gov.nasa.ltl.trans.Formula<String> arg1 = this.getArg1() == null ? null : this.getArg1().toLtlFormula();
        gov.nasa.ltl.trans.Formula<String> arg2 = this.getArg2() == null ? null : this.getArg2().toLtlFormula();
        switch (this.getToken()) {
            case FORALL: 
            case EXISTS: {
                throw new ParseException("Path quantifier '%s' not allowed in LTL formula", new Object[]{this.getToken()});
            }
            case ATOM: {
                return gov.nasa.ltl.trans.Formula.Proposition((Object)this.getProp());
            }
            case TRUE: {
                return gov.nasa.ltl.trans.Formula.True();
            }
            case FALSE: {
                return gov.nasa.ltl.trans.Formula.False();
            }
            case NOT: {
                return gov.nasa.ltl.trans.Formula.Not(arg1);
            }
            case OR: {
                return gov.nasa.ltl.trans.Formula.Or(arg1, arg2);
            }
            case AND: {
                return gov.nasa.ltl.trans.Formula.And(arg1, arg2);
            }
            case NEXT: {
                return gov.nasa.ltl.trans.Formula.Next(arg1);
            }
            case RELEASE: {
                return gov.nasa.ltl.trans.Formula.WRelease(arg1, arg2);
            }
            case S_RELEASE: {
                return gov.nasa.ltl.trans.Formula.Release(arg1, arg2);
            }
            case UNTIL: {
                return gov.nasa.ltl.trans.Formula.Until(arg1, arg2);
            }
            case W_UNTIL: {
                return gov.nasa.ltl.trans.Formula.WUntil(arg1, arg2);
            }
            case ALWAYS: {
                return gov.nasa.ltl.trans.Formula.Always(arg1);
            }
            case EVENTUALLY: {
                return gov.nasa.ltl.trans.Formula.Eventually(arg1);
            }
            case EQUIV: {
                return Formula.And(Formula.Implies(this.getArg1(), this.getArg2()), Formula.Follows(this.getArg1(), this.getArg2())).toLtlFormula();
            }
            case FOLLOWS: {
                return Formula.Or(this.getArg1(), Formula.Not(this.getArg2())).toLtlFormula();
            }
            case IMPLIES: {
                return Formula.Or(Formula.Not(this.getArg1()), this.getArg2()).toLtlFormula();
            }
        }
        throw new ParseException("Unknown temporal operator %s", new Object[]{this.getToken()});
    }

    public boolean isAtom(String text) {
        boolean result;
        boolean bl = result = text.length() > 0;
        if (result) {
            result = Character.isJavaIdentifierStart(text.charAt(0));
            int i = 1;
            while (result && i < text.length()) {
                result = Character.isJavaIdentifierPart(text.charAt(i));
                ++i;
            }
        }
        return result;
    }

    public static Formula Atom(String prop) {
        return new Formula(prop);
    }

    public static final Formula True() {
        return new Formula(FormulaParser.Token.TRUE);
    }

    public static final Formula False() {
        return new Formula(FormulaParser.Token.FALSE);
    }

    public static Formula Not(Formula f) {
        return new Formula(FormulaParser.Token.NOT, f);
    }

    public static Formula And(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.AND, f1, f2);
    }

    public static Formula Or(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.OR, f1, f2);
    }

    public static Formula Implies(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.IMPLIES, f1, f2);
    }

    public static Formula Follows(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.FOLLOWS, f1, f2);
    }

    public static Formula Equiv(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.EQUIV, f1, f2);
    }

    public static Formula Until(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.UNTIL, f1, f2);
    }

    public static Formula Next(Formula f) {
        return new Formula(FormulaParser.Token.NEXT, f);
    }

    public static Formula Release(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.RELEASE, f1, f2);
    }

    public static Formula WUntil(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.W_UNTIL, f1, f2);
    }

    public static Formula SRelease(Formula f1, Formula f2) {
        return new Formula(FormulaParser.Token.S_RELEASE, f1, f2);
    }

    public static Formula Always(Formula f) {
        return new Formula(FormulaParser.Token.ALWAYS, f);
    }

    public static Formula Eventually(Formula f) {
        return new Formula(FormulaParser.Token.EVENTUALLY, f);
    }

    public static Formula Forall(Formula f) {
        return new Formula(FormulaParser.Token.FORALL, f);
    }

    public static Formula Exists(Formula f) {
        return new Formula(FormulaParser.Token.EXISTS, f);
    }
}

