/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.AbstractNestedIterator;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MapSet<K, E>
extends AbstractSet<E>
implements Set<E> {
    private final Map<K, Set<E>> map = new HashMap<K, Set<E>>();
    private int size;

    @Override
    public Iterator<E> iterator() {
        return new AbstractNestedIterator<E>(){
            private final Iterator<Set<E>> setIterator;
            {
                this.setIterator = MapSet.this.map.values().iterator();
            }

            @Override
            protected Iterator<E> nextIterator() {
                return Collections.unmodifiableSet(this.setIterator.next()).iterator();
            }

            @Override
            protected boolean hasNextIterator() {
                return this.setIterator.hasNext();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        K key = this.getKey(o);
        if (key != null) {
            result = this.map.get(key).contains(o);
        }
        return result;
    }

    @Override
    public boolean add(E e) {
        boolean result;
        K key = this.getKey(e);
        Set<E> set = this.map.get(key);
        if (set == null) {
            set = new HashSet();
            this.map.put(key, set);
        }
        if (result = set.add(e)) {
            ++this.size;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = false;
        K key = this.getKey(o);
        Set<E> set = this.map.get(key);
        if (set != null && (result = set.remove(o)) && set.isEmpty()) {
            this.map.remove(key);
        }
        if (result) {
            --this.size;
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Set<E> get(K key) {
        return this.map.get(key);
    }

    protected abstract K getKey(Object var1);
}

