/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.FilterIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public abstract class CollectionView<T>
extends AbstractCollection<T> {
    protected final Collection<?> coll;

    public CollectionView(Collection<?> coll) {
        this.coll = coll;
    }

    @Override
    public int size() {
        int result = 0;
        for (Object elem : this.coll) {
            if (!this.approves(elem)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean contains(Object elem) {
        return this.approves(elem) && this.coll.contains(elem);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator<T>(this.coll.iterator()){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean approves(Object obj) {
                return CollectionView.this.approves(obj);
            }
        };
    }

    @Override
    public boolean add(Object elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object elem) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean approves(Object var1);
}

