/*
 * Decompiled with CFR 0.152.
 */
package groove.util.cache;

import groove.util.cache.CacheHolder;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class CacheReference<C>
extends SoftReference<C> {
    private final CacheHolder<C> holder;
    private boolean strong;
    private C referent;
    private final int incarnation;
    private final List<CacheReference<C>> strongNull;
    private final List<CacheReference<C>> softNull;
    private static List<Integer> frequencies = new ArrayList<Integer>();
    private static final CacheReference strongInstance = new CacheReference(true, 0, null);
    private static final CacheReference softInstance = new CacheReference(false, 0, null);
    private static int incarnationCount;
    private static int cacheCollectCount;
    private static int cacheClearCount;
    private static int createCount;
    private static final ReferenceQueue<Object> queue;

    static {
        queue = new ReferenceQueue();
    }

    protected CacheReference(CacheHolder<C> holder, C referent, CacheReference<C> template) {
        super(referent, queue);
        this.holder = holder;
        this.incarnation = template.incarnation + 1;
        CacheReference.incFrequency(this.incarnation);
        this.strong = template.strong;
        if (this.strong) {
            this.referent = referent;
        }
        this.strongNull = template.strongNull;
        this.softNull = template.softNull;
        CacheReference reference = (CacheReference)queue.poll();
        while (reference != null) {
            reference.updateCleared();
            ++cacheCollectCount;
            reference = (CacheReference)queue.poll();
        }
        if (holder != null) {
            ++createCount;
        }
    }

    protected CacheReference(boolean strong, int incarnation, CacheReference<C> template) {
        super(null, queue);
        this.holder = null;
        this.incarnation = incarnation;
        this.strong = strong;
        if (template == null) {
            this.strongNull = new ArrayList<CacheReference<C>>();
            this.softNull = new ArrayList<CacheReference<C>>();
        } else {
            this.strongNull = template.strongNull;
            this.softNull = template.softNull;
            assert (incarnation >= (strong ? this.strongNull : this.softNull).size());
        }
    }

    public final boolean isStrong() {
        return this.strong;
    }

    public final void setSoft() {
        if (this.holder != null) {
            assert (!this.strong || this.referent != null) : "Referent cannot be null for strong reference";
            this.strong = false;
            this.referent = null;
        }
    }

    public final int getIncarnation() {
        return this.incarnation;
    }

    @Override
    public final void clear() {
        super.clear();
        this.updateCleared();
    }

    public CacheReference<C> newReference(CacheHolder<C> holder, C cache) {
        return new CacheReference<C>(holder, cache, this);
    }

    public final CacheReference<C> newNullReference() {
        return this.getNullInstance(this.strong, 0);
    }

    public final CacheReference<C> getNullReference(boolean strong) {
        return this.getNullInstance(strong, this.incarnation);
    }

    private CacheReference<C> getNullInstance(boolean strong, int incarnation) {
        int i = this.strongNull.size();
        while (i <= incarnation) {
            this.strongNull.add(this.createNullInstance(true, i));
            this.softNull.add(this.createNullInstance(false, i));
            ++i;
        }
        return (strong ? this.strongNull : this.softNull).get(incarnation);
    }

    protected CacheReference<C> createNullInstance(boolean strong, int incarnation) {
        return new CacheReference<C>(strong, incarnation, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCleared() {
        if (this.holder != null) {
            CacheHolder<C> cacheHolder = this.holder;
            synchronized (cacheHolder) {
                if (this.holder.getCacheReference() == this) {
                    this.holder.setCacheReference(this.getNullInstance(this.strong, this.incarnation));
                    ++cacheClearCount;
                }
            }
        }
    }

    public static <C> CacheReference<C> newInstance() {
        return CacheReference.newInstance(true);
    }

    public static <C> CacheReference<C> newInstance(boolean strong) {
        return strong ? strongInstance : softInstance;
    }

    public static int getIncarnationCount() {
        return incarnationCount;
    }

    private static void incFrequency(int incarnation) {
        int i = frequencies.size();
        while (i <= incarnation) {
            frequencies.add(0);
            ++i;
        }
        frequencies.set(incarnation, frequencies.get(incarnation) + 1);
        if (incarnation > 1) {
            ++incarnationCount;
        }
    }

    public static int getFrequency(int incarnation) {
        return incarnation >= frequencies.size() ? 0 : frequencies.get(incarnation);
    }

    public static int getCreateCount() {
        return createCount;
    }

    public static int getClearCount() {
        return cacheClearCount;
    }

    public static int getCollectCount() {
        return cacheCollectCount;
    }
}

