/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.util.Fixable;

public class Pair<T, U>
implements Fixable {
    private int hashCode;
    private T one;
    private U two;

    public Pair(T one, U two) {
        this.one = one;
        this.two = two;
    }

    public T one() {
        return this.one;
    }

    public U two() {
        return this.two;
    }

    public T setOne(T one) {
        assert (!this.isFixed()) : "Can't set a value after the pair is fixed.";
        T result = this.one;
        this.one = one;
        return result;
    }

    public U setTwo(U two) {
        assert (!this.isFixed()) : "Can't set a value after the pair is fixed.";
        U result = this.two;
        this.two = two;
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.hashCode();
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.hashCode != 0;
    }

    @Override
    public void testFixed(boolean fixed) {
        assert (this.isFixed() == fixed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Pair && this.equalsOne((Pair)obj) && this.equalsTwo((Pair)obj);
    }

    protected boolean equalsOne(Pair<?, ?> other) {
        if (this.one == null) {
            return other.one == null;
        }
        return this.one.equals(other.one);
    }

    protected boolean equalsTwo(Pair<?, ?> other) {
        if (this.two == null) {
            return other.two == null;
        }
        return this.two.equals(other.two);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int firstHash = this.one == null ? 0 : this.one.hashCode();
            int secondHash = this.two == null ? 0 : this.two.hashCode();
            this.hashCode = firstHash ^ secondHash << 1;
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return String.format("<%s,%s>", this.one, this.two);
    }

    public static <TT, UU> Pair<TT, UU> newPair(TT one, UU two) {
        return new Pair<TT, UU>(one, two);
    }
}

