/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class History<T> {
    protected final List<T> log = new ArrayList<T>();
    protected int index = -1;
    private static final boolean DEBUG = false;

    public void clear() {
        this.log.clear();
        this.index = -1;
    }

    public boolean isEmpty() {
        return this.log.size() == 0;
    }

    public boolean hasNext() {
        return this.index < this.log.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public T next() {
        if (this.hasNext()) {
            ++this.index;
            return this.log.get(this.index);
        }
        throw new NoSuchElementException("No next element in history");
    }

    public T current() {
        if (!this.isEmpty()) {
            return this.log.get(this.index);
        }
        throw new NoSuchElementException("No current element in history");
    }

    public T previous() {
        if (this.hasPrevious()) {
            --this.index;
            return this.log.get(this.index);
        }
        throw new NoSuchElementException("No previous element in history");
    }

    public void replace(T element) {
        this.log.set(this.index, element);
        int i = this.log.size() - 1;
        while (i > this.index) {
            this.log.remove(i);
            --i;
        }
    }

    public void add(T element) {
        if (this.index < 0 || !element.equals(this.current())) {
            assert (this.index < this.log.size());
            ++this.index;
            if (this.index < this.log.size()) {
                this.replace(element);
            } else {
                this.log.add(element);
            }
        }
    }
}

