/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.util.CommandLineOption;
import groove.util.Groove;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandLineTool {
    public static final String OPTIONS_PREFIX = "-";
    public static final String ID_SEPARATOR = "#";
    public static final String LOG_FILE_EXTENSION = ".log";
    public static final int LOW_VERBOSITY = 0;
    public static final int MEDIUM_VERBOSITY = 1;
    public static final int HIGH_VERBOSITY = 2;
    protected static final char SPACE = ' ';
    protected static final char COLON = ':';
    protected static final char UNDERSCORE = '_';
    protected static final char DASH = '-';
    protected final OutputOption outputOption;
    protected final VerbosityOption verbosityOption;
    protected final LogOption logOption;
    protected final Date invocationTime = new Date();
    private int verbosity = 1;
    private boolean logging;
    private String logDirName;
    private PrintWriter logWriter;
    private final List<String> args;
    protected final ExtensionFilter logFilter = FileType.LOG_FILTER;
    protected final List<CommandLineOption> optionsList = new LinkedList<CommandLineOption>();
    protected final Map<String, CommandLineOption> activeOptions = new HashMap<String, CommandLineOption>();

    public CommandLineTool(boolean addOptions, String ... args) {
        this.args = new ArrayList<String>(Arrays.asList(args));
        this.outputOption = new OutputOption();
        this.verbosityOption = new VerbosityOption(this);
        this.logOption = new LogOption(this);
        if (addOptions) {
            if (this.supportsOutputOption()) {
                this.addOption(this.outputOption);
            }
            if (this.supportsVerbosityOption()) {
                this.addOption(this.verbosityOption);
            }
            if (this.supportsLogOption()) {
                this.addOption(this.logOption);
            }
        }
    }

    public CommandLineTool(String ... args) {
        this(true, args);
    }

    protected void addOption(CommandLineOption option) {
        this.optionsList.add(option);
    }

    protected void processArguments() {
        List<String> argsList = this.getArgs();
        while (argsList.size() > 0 && argsList.get(0).startsWith(OPTIONS_PREFIX)) {
            String optionName = argsList.get(0).substring(OPTIONS_PREFIX.length());
            argsList.remove(0);
            boolean validOption = false;
            Iterator<CommandLineOption> optionsIter = this.optionsList.iterator();
            while (!validOption && optionsIter.hasNext()) {
                String parameter;
                CommandLineOption option = optionsIter.next();
                if (!option.getName().equals(optionName)) continue;
                if (option.hasParameter()) {
                    parameter = argsList.get(0);
                    argsList.remove(0);
                } else {
                    parameter = null;
                }
                try {
                    option.parse(parameter);
                    validOption = true;
                }
                catch (IllegalArgumentException exc) {
                    this.printError(exc.getMessage(), true);
                }
                this.activeOptions.put(option.getName(), option);
            }
            if (validOption) continue;
            this.printError("Unknown option " + optionName, true);
        }
    }

    protected void startLog() {
        if (this.isLogging()) {
            try {
                String logFileName = this.logFilter.addExtension(this.getLogFileName());
                this.setLogWriter(new PrintWriter(new FileWriter(new File(this.getLogDirName(), logFileName))));
            }
            catch (IOException e) {
                this.printError("Can't create log file in " + this.getLogDirName() + ": " + e.getMessage(), false);
            }
        }
    }

    protected void endLog() {
        if (this.isLogging()) {
            this.getLogWriter().close();
        }
    }

    protected boolean supportsOutputOption() {
        return true;
    }

    protected boolean supportsVerbosityOption() {
        return true;
    }

    protected boolean supportsLogOption() {
        return true;
    }

    protected String getId() {
        return this.invocationTime.toString().replace(' ', '_').replace(':', '-');
    }

    protected String getUsageMessage() {
        return "Usage: " + this.getClass().getName() + " [options]";
    }

    protected String getOutputFileName() {
        if (this.isOptionActive(this.outputOption)) {
            return this.outputOption.getOutputFileName();
        }
        return null;
    }

    protected void setLogging(String logDirName) {
        this.logging = true;
        this.logDirName = logDirName;
    }

    protected String getLogFileName() {
        return String.valueOf(this.getClass().getName()) + ID_SEPARATOR + this.getId();
    }

    protected String getLogDirName() {
        return this.logDirName;
    }

    protected void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    protected PrintWriter getLogWriter() {
        return this.logWriter;
    }

    protected boolean isLogging() {
        return this.logging;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    protected List<String> getArgs() {
        return this.args;
    }

    protected void println() {
        System.out.println();
        if (this.logging) {
            this.logWriter.println();
        }
    }

    protected void println(String text) {
        System.out.println(text);
        if (this.logging) {
            this.logWriter.println(text);
        }
    }

    protected void printf(String text, Object ... args) {
        System.out.printf(text, args);
        if (this.logging) {
            this.logWriter.printf(text, args);
        }
    }

    protected void print(String text) {
        System.out.print(text);
        if (this.logging) {
            this.logWriter.print(text);
        }
    }

    protected void println(int verbosity) {
        if (this.getVerbosity() >= verbosity) {
            this.println();
        }
    }

    protected void println(String text, int verbosity) {
        if (this.getVerbosity() >= verbosity) {
            this.println(text);
        }
    }

    protected void print(String text, int verbosity) {
        if (this.getVerbosity() >= verbosity) {
            this.print(text);
        }
    }

    protected void printlnMedium(String text) {
        this.println(text, 1);
    }

    protected void printlnHigh(String text) {
        this.println(text, 2);
    }

    protected void printfMedium(String text, Object ... args) {
        if (this.verbosity >= 1) {
            this.printf(text, args);
        }
    }

    protected void printfHigh(String text, Object ... args) {
        if (this.verbosity >= 2) {
            this.printf(text, args);
        }
    }

    protected void printLog(String text) {
        if (this.logging) {
            this.logWriter.println(text);
        }
    }

    protected void printError(String message, boolean showHelp) {
        if (showHelp) {
            this.printHelp();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        System.err.println();
        System.err.println("Error: " + message);
        if (this.logWriter != null) {
            this.logWriter.close();
        }
        System.exit(0);
    }

    protected void printHelp() {
        System.out.println(this.getUsageMessage());
        if (this.optionsList.size() > 0) {
            System.out.println("Options: ");
        }
        String[] prefix = new String[this.optionsList.size()];
        int maxPrefixLength = 0;
        int i = 0;
        while (i < this.optionsList.size()) {
            CommandLineOption option = this.optionsList.get(i);
            prefix[i] = option.hasParameter() ? OPTIONS_PREFIX + option.getName() + " " + option.getParameterName() + " " : OPTIONS_PREFIX + option.getName() + " ";
            maxPrefixLength = Math.max(maxPrefixLength, prefix[i].length());
            ++i;
        }
        String emptyPrefix = Groove.pad("", maxPrefixLength);
        int i2 = 0;
        while (i2 < this.optionsList.size()) {
            CommandLineOption option = this.optionsList.get(i2);
            String[] description = option.getDescription();
            if (description.length > 0) {
                System.out.println(String.valueOf(Groove.pad(prefix[i2], maxPrefixLength)) + description[0]);
                int j = 1;
                while (j < description.length) {
                    System.out.println(String.valueOf(emptyPrefix) + description[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    protected boolean isOptionActive(CommandLineOption option) {
        return this.activeOptions.containsValue(option);
    }

    protected static class LogOption
    implements CommandLineOption {
        public static final String NAME = "l";
        public static final String PARAMETER_NAME = "dir";
        private final CommandLineTool tool;

        public LogOption(CommandLineTool tool) {
            this.tool = tool;
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Log the generation process, writing the file to the directory '" + this.getParameterName() + "'"};
        }

        @Override
        public String getParameterName() {
            return PARAMETER_NAME;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) {
            this.tool.setLogging(parameter);
        }
    }

    protected static class OutputOption
    implements CommandLineOption {
        public static final String NAME = "o";
        public static final String PARAMETER_NAME = "file";
        private String parameter;

        protected OutputOption() {
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) {
            this.parameter = parameter;
        }

        public String getOutputFileName() {
            return this.parameter;
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Save the result to '" + this.getParameterName() + "' (default format GXL)"};
        }

        @Override
        public String getParameterName() {
            return PARAMETER_NAME;
        }
    }

    public static class VerbosityOption
    implements CommandLineOption {
        public static final String NAME = "v";
        public static final String PARAMETER_NAME = "val";
        public static final int LOW_VERBOSITY = 0;
        public static final int MEDIUM_VERBOSITY = 1;
        public static final int HIGH_VERBOSITY = 2;
        public static final int DEFAULT_VERBOSITY = 1;
        private final CommandLineTool tool;

        public VerbosityOption(CommandLineTool tool) {
            this.tool = tool;
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Set the verbosity to '" + this.getParameterName() + "', in the range " + 0 + CommandLineTool.OPTIONS_PREFIX + 2 + " (default = " + 1 + ")"};
        }

        @Override
        public String getParameterName() {
            return PARAMETER_NAME;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) throws IllegalArgumentException {
            int verbosity = 1;
            try {
                verbosity = Integer.parseInt(parameter);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("verbosity value '" + parameter + "' must be numeric");
            }
            if (verbosity < 0 || verbosity > 2) {
                throw new IllegalArgumentException("'" + parameter + "' is outside the range of valid verbosity values");
            }
            this.tool.setVerbosity(verbosity);
        }
    }
}

