/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import java.util.Observable;

public class ChangeCount
extends Observable {
    private int value;
    public static final Tracker DUMMY_TRACKER = new DummyTracker();

    public void increase() {
        ++this.value;
        this.setChanged();
        this.notifyObservers();
    }

    public Tracker createTracker() {
        return new Tracker(this, null, null);
    }

    int getValue() {
        return this.value;
    }

    public static abstract class Derived<O> {
        private final Tracker tracker;
        private O value;

        public Derived(ChangeCount count) {
            this.tracker = count.createTracker();
        }

        public O getValue() {
            if (this.tracker.isStale() || this.value == null) {
                this.value = this.computeValue();
            }
            return this.value;
        }

        protected abstract O computeValue();
    }

    private static class DummyTracker
    extends Tracker {
        private DummyTracker() {
            super(new ChangeCount());
        }
    }

    public static class Tracker {
        private final ChangeCount count;
        private int last;

        private Tracker(ChangeCount model) {
            this.count = model;
            this.last = model.getValue() - 1;
        }

        public boolean isStale() {
            int current = this.count.getValue();
            boolean result = this.last < current;
            this.last = current;
            return result;
        }

        /* synthetic */ Tracker(ChangeCount changeCount, Tracker tracker, Tracker tracker2) {
            this(changeCount);
        }
    }
}

