/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.Grammar;
import groove.grammar.Rule;
import groove.grammar.RuleDependencies;
import groove.grammar.host.HostFactory;
import groove.grammar.rule.RuleToHostMap;
import groove.lts.RuleTransitionLabel;
import groove.transform.AbstractRuleEvent;
import groove.transform.BasicEvent;
import groove.transform.CompositeEvent;
import groove.transform.Proof;
import groove.transform.RuleEvent;
import groove.transform.RuleEventSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Record {
    private static int eventCount;
    private RuleDependencies dependencies;
    private final Grammar grammar;
    private final HostFactory hostFactory;
    private final RuleEventSet eventMap = new RuleEventSet();
    private final Map<RuleTransitionLabel, RuleTransitionLabel> labelMap = new HashMap<RuleTransitionLabel, RuleTransitionLabel>();
    private boolean checkIso = true;
    private boolean collapseStates = true;
    private RuleEvent.Reuse reuse = RuleEvent.Reuse.EVENT;
    private boolean copyGraphs = false;
    private boolean randomAccess = false;

    public static int getEventCount() {
        return eventCount;
    }

    public Record(Grammar grammar, HostFactory hostFactory) throws IllegalStateException {
        this.grammar = grammar;
        this.hostFactory = hostFactory;
        grammar.testFixed(true);
        this.checkIso = grammar.getProperties().isCheckIsomorphism();
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public HostFactory getFactory() {
        return this.hostFactory;
    }

    public RuleEvent getEvent(Proof proof) {
        return proof.newEvent(this);
    }

    public RuleEvent normaliseEvent(RuleEvent event) {
        RuleEvent result;
        if (this.getReuse() == RuleEvent.Reuse.EVENT && event instanceof AbstractRuleEvent) {
            result = this.eventMap.put((AbstractRuleEvent)event);
            if (result == null) {
                result = event;
                ++eventCount;
            }
        } else {
            result = event;
        }
        return result;
    }

    public RuleEvent createCompositeEvent(Rule rule, Collection<BasicEvent> eventSet) {
        return this.normaliseEvent(new CompositeEvent(this, rule, eventSet, this.getReuse()));
    }

    public BasicEvent createSimpleEvent(Rule rule, RuleToHostMap elementMap) {
        return (BasicEvent)this.normaliseEvent(new BasicEvent(rule, elementMap, this.getReuse()));
    }

    public RuleTransitionLabel normaliseLabel(RuleTransitionLabel prototype) {
        RuleTransitionLabel result = this.labelMap.get(prototype);
        if (result == null) {
            result = prototype;
            this.labelMap.put(result, prototype);
        }
        return result;
    }

    public Set<Rule> getEnabledRules(Rule enabler) {
        return this.getDependencies().getEnableds(enabler);
    }

    public Set<Rule> getDisabledRules(Rule disabler) {
        Set<Rule> result = this.getDependencies().getDisableds(disabler);
        assert (result != null) : String.format("Null rule dependencies for %s", disabler.getFullName());
        return result;
    }

    protected RuleDependencies getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new RuleDependencies(this.getGrammar());
        }
        return this.dependencies;
    }

    public void setCheckIso(boolean check) {
        this.checkIso = check;
    }

    public boolean isCheckIso() {
        return this.checkIso;
    }

    public void setCollapse(boolean collapse) {
        this.collapseStates = collapse;
    }

    public boolean isCollapse() {
        return this.collapseStates;
    }

    public void setReuseEvents(RuleEvent.Reuse reuse) {
        if (this.eventMap.isEmpty()) {
            this.reuse = reuse;
        }
    }

    public RuleEvent.Reuse getReuse() {
        return this.reuse;
    }

    public void setCopyGraphs(boolean copy) {
        this.copyGraphs = copy;
    }

    public boolean isCopyGraphs() {
        return this.copyGraphs || this.randomAccess;
    }

    public void setRandomAccess(boolean access) {
        this.randomAccess = access;
    }

    public boolean isRandomAccess() {
        return this.randomAccess;
    }
}

