/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin.graph;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologException;
import groove.grammar.host.HostGraph;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.lts.GraphState;

public abstract class GraphPrologCode
implements PrologCode {
    public static final AtomTerm GRAPH_ATOM = AtomTerm.get((String)"graph");
    public static final AtomTerm NODE_ATOM = AtomTerm.get((String)"node");
    public static final AtomTerm EDGE_ATOM = AtomTerm.get((String)"edge");

    public static final Graph getGraph(Term term) throws PrologException {
        if (term instanceof JavaObjectTerm) {
            JavaObjectTerm jot = (JavaObjectTerm)term;
            if (jot.value instanceof GraphState) {
                return ((GraphState)jot.value).getGraph();
            }
            if (jot.value instanceof Graph) {
                return (Graph)jot.value;
            }
            PrologException.domainError((AtomTerm)GRAPH_ATOM, (Term)term);
        } else {
            PrologException.typeError((AtomTerm)GRAPH_ATOM, (Term)term);
        }
        return null;
    }

    public static final HostGraph getHostGraph(Term term) throws PrologException {
        if (term instanceof JavaObjectTerm) {
            JavaObjectTerm jot = (JavaObjectTerm)term;
            if (jot.value instanceof GraphState) {
                return ((GraphState)jot.value).getGraph();
            }
            if (jot.value instanceof HostGraph) {
                return (HostGraph)jot.value;
            }
            PrologException.domainError((AtomTerm)GRAPH_ATOM, (Term)term);
        } else {
            PrologException.typeError((AtomTerm)GRAPH_ATOM, (Term)term);
        }
        return null;
    }

    public static final Edge getEdge(Term term) throws PrologException {
        if (term instanceof JavaObjectTerm) {
            JavaObjectTerm jot = (JavaObjectTerm)term;
            if (!(jot.value instanceof Edge)) {
                PrologException.domainError((AtomTerm)EDGE_ATOM, (Term)term);
            }
            return (Edge)jot.value;
        }
        PrologException.typeError((AtomTerm)EDGE_ATOM, (Term)term);
        return null;
    }

    public static final Node getNode(Term term) throws PrologException {
        if (term instanceof JavaObjectTerm) {
            JavaObjectTerm jot = (JavaObjectTerm)term;
            if (!(jot.value instanceof Node)) {
                PrologException.domainError((AtomTerm)NODE_ATOM, (Term)term);
            }
            return (Node)jot.value;
        }
        PrologException.typeError((AtomTerm)NODE_ATOM, (Term)term);
        return null;
    }

    public static final boolean hasOption(Interpreter interpreter, Term input, CompoundTermTag opt, Term[] values) throws PrologException {
        if (!(input instanceof CompoundTerm)) {
            return false;
        }
        CompoundTerm ct = (CompoundTerm)input;
        while (ct != null) {
            CompoundTerm entry = null;
            if (CompoundTerm.isListPair((Term)ct)) {
                if (ct.args[0] instanceof CompoundTerm) {
                    entry = (CompoundTerm)ct.args[0];
                }
                if (!(ct.args[1] instanceof CompoundTerm)) break;
                ct = (CompoundTerm)ct.args[1];
                if (entry == null) {
                    continue;
                }
            } else {
                entry = ct;
                ct = null;
            }
            if (entry.tag != opt) continue;
            int i = 0;
            while (i < opt.arity) {
                if (interpreter.simpleUnify(entry.args[i], values[i]) == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void install(Environment env) {
    }

    public void uninstall(Environment env) {
    }
}

