/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin;

import groove.annotation.Signature;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipPars;
import groove.prolog.builtin.GroovePredicates;

public class GraphPredicates
extends GroovePredicates {
    @Signature(value={"Graph", "+"})
    @ToolTipBody(value={"Fails if the first argument is not a Groove Graph"})
    public void is_graph_1() {
        this.s(":-build_in(is_graph/1,'groove.prolog.builtin.graph.Predicate_is_graph').");
    }

    @Signature(value={"Node", "+"})
    @ToolTipBody(value={"Fails if the first argument is not a Groove Node"})
    public void is_node_1() {
        this.s(":-build_in(is_node/1,'groove.prolog.builtin.graph.Predicate_is_node').");
    }

    @Signature(value={"Edge", "+"})
    @ToolTipBody(value={"Fails if the first argument is not a Groove Edge"})
    public void is_edge_1() {
        this.s(":-build_in(is_edge/1,'groove.prolog.builtin.graph.Predicate_is_edge').");
    }

    @Signature(value={"Graph", "?"})
    @ToolTipBody(value={"Retrieves the start graph"})
    @ToolTipPars(value={"the graph"})
    public void start_graph_1() {
        this.s(":-build_in(start_graph/1,'groove.prolog.builtin.graph.Predicate_start_graph').");
    }

    @Signature(value={"String", "?"})
    @ToolTipBody(value={"Retrieves the start graph name"})
    @ToolTipPars(value={"the graph name"})
    public void start_graph_name_1() {
        this.s(":-build_in(start_graph_name/1,'groove.prolog.builtin.graph.Predicate_start_graph_name').");
    }

    @Signature(value={"Graph", "Node", "+?"})
    @ToolTipBody(value={"Gets a node from a graph"})
    @ToolTipPars(value={"the graph", "the node"})
    public void graph_node_2() {
        this.s(":-build_in(graph_node/2,'groove.prolog.builtin.graph.Predicate_graph_node').");
    }

    @Signature(value={"Graph", "NodeSet", "+?"})
    @ToolTipBody(value={"Gets the complete node set of a graph"})
    @ToolTipPars(value={"the graph", "the list of nodes"})
    public void graph_node_set_2() {
        this.s(":-build_in(graph_node_set/2,'groove.prolog.builtin.graph.Predicate_graph_node_set').");
    }

    @Signature(value={"Graph", "Count", "+?"})
    @ToolTipBody(value={"Gets the number of nodes in a graph"})
    @ToolTipPars(value={"the graph", "the number of nodes"})
    public void graph_node_count_2() {
        this.s(":-build_in(graph_node_count/2,'groove.prolog.builtin.graph.Predicate_graph_node_count').");
    }

    @Signature(value={"Graph", "Edge", "+?"})
    @ToolTipBody(value={"Gets an edge from a graph"})
    @ToolTipPars(value={"the graph", "the edge"})
    public void graph_edge_2() {
        this.s(":-build_in(graph_edge/2,'groove.prolog.builtin.graph.Predicate_graph_edge').");
    }

    @Signature(value={"Graph", "EdgeSet", "+?"})
    @ToolTipBody(value={"Gets a set of edges from a graph"})
    @ToolTipPars(value={"the graph ", "the list of edges"})
    public void graph_edge_set_2() {
        this.s(":-build_in(graph_edge_set/2,'groove.prolog.builtin.graph.Predicate_graph_edge_set').");
    }

    @Signature(value={"Graph", "Count", "+?"})
    @ToolTipBody(value={"Gets the number of edges in a graph"})
    @ToolTipPars(value={"the graph", "the number of edges"})
    public void graph_edge_count_2() {
        this.s(":-build_in(graph_edge_count/2,'groove.prolog.builtin.graph.Predicate_graph_edge_count').");
    }

    @Signature(value={"Graph", "Node", "Edge", "++?"})
    @ToolTipBody(value={"Gets an edge from a node, can be incoming or outgoing"})
    @ToolTipPars(value={"the graph", "the node", "the edge"})
    public void node_edge_3() {
        this.s(":-build_in(node_edge/3,'groove.prolog.builtin.graph.Predicate_node_edge').");
    }

    @Signature(value={"Graph", "Node", "EdgeSet", "++?"})
    @ToolTipBody(value={"Gets the set of edges for a single node. Both incoming and outgoing edges."})
    @ToolTipPars(value={"the graph", "the node", "the list of edges"})
    public void node_edge_set_3() {
        this.s(":-build_in(node_edge_set/3,'groove.prolog.builtin.graph.Predicate_node_edge_set').");
    }

    @Signature(value={"Graph", "Node", "Edge", "++?"})
    @ToolTipBody(value={"Gets an outgoing edge from a node"})
    @ToolTipPars(value={"the graph", "the node", "list of outgoing edges"})
    public void node_out_edge_3() {
        this.s(":-build_in(node_out_edge/3,'groove.prolog.builtin.graph.Predicate_node_out_edge').");
    }

    @Signature(value={"Graph", "Node", "EdgeSet", "++?"})
    @ToolTipBody(value={"Gets the outgoing edges for a given node"})
    @ToolTipPars(value={"the graph", "the node", "list of outgoing edges"})
    public void node_out_edge_set_3() {
        this.s(":-build_in(node_out_edge_set/3,'groove.prolog.builtin.graph.Predicate_node_out_edge_set').");
    }

    @Signature(value={"Graph", "Label", "Edge", "++?"})
    @ToolTipBody(value={"Gets an edge with a given label"})
    @ToolTipPars(value={"the graph", "the label", "the edges"})
    public void label_edge_3() {
        this.s(":-build_in(label_edge/3,'groove.prolog.builtin.graph.Predicate_label_edge').");
    }

    @Signature(value={"Graph", "Label", "EdgeSet", "++?"})
    @ToolTipBody(value={"Gets the edge set of a graph with a given label"})
    @ToolTipPars(value={"the graph", "the label", "the list of edges"})
    public void label_edge_set_3() {
        this.s(":-build_in(label_edge_set/3,'groove.prolog.builtin.graph.Predicate_label_edge_set').");
    }

    @Signature(value={"Edge", "Node", "+?"})
    @ToolTipBody(value={"Gets the source node of an edge"})
    @ToolTipPars(value={"the edge", "the node"})
    public void edge_source_2() {
        this.s(":-build_in(edge_source/2,'groove.prolog.builtin.graph.Predicate_edge_source').");
    }

    @Signature(value={"Edge", "Node", "+?"})
    @ToolTipBody(value={"Gets the destination node of an edge (opposite of the source)"})
    @ToolTipPars(value={"the edge", "the node"})
    public void edge_target_2() {
        this.s(":-build_in(edge_target/2,'groove.prolog.builtin.graph.Predicate_edge_target').");
    }

    @Signature(value={"Edge", "Label", "+?"})
    @ToolTipBody(value={"Gets the label of the edge"})
    @ToolTipPars(value={"the edge", "the label/Atom"})
    public void edge_label_2() {
        this.s(":-build_in(edge_label/2,'groove.prolog.builtin.graph.Predicate_edge_label').");
    }

    @Signature(value={"Edge", "+"})
    @ToolTipBody(value={"Checks if the edge has a binary role"})
    public void edge_role_binary_1() {
        this.s(":-build_in(edge_role_binary/1,'groove.prolog.builtin.graph.Predicate_edge_role_binary').");
    }

    @Signature(value={"Edge", "+"})
    @ToolTipBody(value={"Checks if the edge has a flag role"})
    public void edge_role_flag_1() {
        this.s(":-build_in(edge_role_flag/1,'groove.prolog.builtin.graph.Predicate_edge_role_flag').");
    }

    @Signature(value={"Edge", "+"})
    @ToolTipBody(value={"Checks if the edge has a node type role"})
    public void edge_role_node_type_1() {
        this.s(":-build_in(edge_role_node_type/1,'groove.prolog.builtin.graph.Predicate_edge_role_node_type').");
    }

    @Signature(value={"Graph", "Edge", "+?"})
    @ToolTipBody(value={"Gets all binary edges in the graph"})
    public void graph_binary_2() {
        this.s("graph_binary(G,E) :- graph_edge(G,E), edge_role_binary(E).");
    }

    @Signature(value={"Graph", "Edge", "+?"})
    @ToolTipBody(value={"Gets all flag edges in the graph"})
    public void graph_flag_2() {
        this.s("graph_flag(G,E) :- graph_edge(G,E), edge_role_flag(E).");
    }

    @Signature(value={"Graph", "Edge", "+?"})
    @ToolTipBody(value={"Gets all node type edges in the graph"})
    public void graph_node_type_2() {
        this.s("graph_node_type(G,E) :- graph_edge(G,E), edge_role_node_type(E).");
    }

    @Signature(value={"Graph", "String", "++"})
    @ToolTipBody(value={"Succeeds if the graph has at least a node with the given node type"})
    public void has_node_type_2() {
        this.s("has_node_type(G,T) :- graph_node_type(G,E), edge_label(E,L), L == T.");
    }

    @ToolTipBody(value={"Gets the path from one node to an other"})
    @Signature(value={"Graph", "Node", "Node", "Path", "+++?"})
    @ToolTipPars(value={"the graph that contains the nodes", "the starting node", "the destination node", "list of edges that define the path"})
    public void node_path_4() {
        this.s("node_path(Graph,From,To,Path):-          ");
        this.s("        node_path(Graph,From,To,Path,[]).");
    }

    @Signature(value={"Graph", "Node", "Node", "Path", "Visited", "+++??"})
    @ToolTipBody(value={"Internal predicate which does all the processing for node_path/4", "Helper predicate, stop processing when the start node is reached"})
    public void node_path_5() {
        this.s("node_path(Graph,From,From,[],_).            ");
        this.s("node_path(Graph,From,To,[E|Path],Visited):- ");
        this.s("    node_out_edge(Graph,From,E),            ");
        this.s("    \\+ member(E,Visited),                  ");
        this.s("    edge_target(E,N),                       ");
        this.s("    From \\= N, % to abolish self edges     ");
        this.s("    node_path(Graph,N,To,Path,[E|Visited]). ");
    }

    @Signature(value={"Graph", "Node", "Labels", "+??"})
    @ToolTipBody(value={"Nodes from the graph that contain self edges with labels from the list.", "All the labels must be present, but more are allowed.", "<p>Example: start_graph(G),node_self_edges(G,Node,['Feature','includedFeature'])"})
    @ToolTipPars(value={"the graph to query", "the node", "the list of labels of the self edges"})
    public void node_self_edges_3() {
        this.s(":-build_in(node_self_edges/3,'groove.prolog.builtin.graph.Predicate_node_self_edges').");
    }

    @Signature(value={"Graph", "Node", "Labels", "+??"})
    @ToolTipBody(value={"Same as node_self_edges/3 except that that the list is exclusive, thus the node", "may not contain more edges"})
    @ToolTipPars(value={"the graph to query", "the node", "the list of labels of the self edges"})
    public void node_self_edges_excl_3() {
        this.s(":-build_in(node_self_edges_excl/3,'groove.prolog.builtin.graph.Predicate_node_self_edges_excl').");
    }

    @ToolTipBody(value={"Get the \"internal\" number of a node. Node numbers are volatile information,", "\"similar\" nodes in different graph states do not share the same number. You should", "not build algorithms around the usage of this predicate. Note, that all node", "forms contain numbers, this completely depends on the Groove implementation "})
    @Signature(value={"Node", "Integer", "+?"})
    @ToolTipPars(value={"the node", "the node number"})
    public void node_number_2() {
        this.s(":-build_in(node_number/2,'groove.prolog.builtin.graph.Predicate_node_number').");
    }

    @ToolTipBody(value={"Finds the node in the graph with a given number"})
    @Signature(value={"Graph", "Node", "Number", "+??"})
    public void node_number_3() {
        this.s("node_number(Graph,Node,Number):-graph_node(Graph,Node),node_number(Node,Number).");
    }
}

