/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.automaton.RegExpr;
import groove.grammar.host.HostEdge;
import groove.grammar.type.TypeGuard;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.RetePathMatch;
import groove.match.rete.SingleEdgePathChecker;

public class WildcardEdgePathChecker
extends SingleEdgePathChecker {
    public WildcardEdgePathChecker(ReteNetwork network, RegExpr.Wildcard expression, boolean isLoop) {
        super(network, expression, isLoop);
    }

    @Override
    protected RetePathMatch makeMatch(HostEdge edge) {
        RetePathMatch m;
        if (this.getExpression().allVarSet().size() > 0) {
            m = new RetePathMatch((ReteNetworkNode)this, edge);
            m.getValuation().put(this.getExpression().allVarSet().iterator().next(), edge.getType());
        } else {
            m = new RetePathMatch((ReteNetworkNode)this, edge);
        }
        return m;
    }

    @Override
    public void receive(ReteNetworkNode source, HostEdge gEdge, ReteNetworkNode.Action action) {
        if (!this.isGuarded() || this.getGuard().isSatisfied(gEdge.getType())) {
            super.receive(source, gEdge, action);
        }
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return this == node || node instanceof WildcardEdgePathChecker && this.getOwner().equals(node.getOwner()) && this.expression.equals(((WildcardEdgePathChecker)node).getExpression());
    }

    public boolean isGuarded() {
        return this.getGuard() != null;
    }

    public TypeGuard getGuard() {
        return ((RegExpr.Wildcard)this.getExpression()).getGuard();
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
    }
}

