/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.algebra.JavaIntAlgebra;
import groove.grammar.Condition;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.VariableNode;
import groove.graph.NodeComparator;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.ConditionChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.ReteSearchStrategy;
import groove.match.rete.ReteSimpleMatch;
import groove.match.rete.ReteStateSubscriber;
import groove.util.Visitor;
import groove.util.collect.TreeHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class QuantifierCountChecker
extends ReteNetworkNode
implements ReteStateSubscriber {
    private Condition condition;
    private RuleElement[] pattern;
    private Set<ReteSimpleMatch.ReteCountMatch> matches = new TreeHashSet<ReteSimpleMatch.ReteCountMatch>();
    private ReteSimpleMatch.ReteCountMatch dummyMatch;
    private ConditionChecker universalQuantifierChecker;
    private boolean updatesSent = false;
    private ReteSearchStrategy conditionMatcher = null;

    public QuantifierCountChecker(ReteNetwork network, Condition condition) {
        super(network);
        assert (condition.getOp() == Condition.Op.FORALL && condition.getCountNode() != null);
        this.condition = condition;
        this.makePattern();
        this.getPatternLookupTable();
        this.getOwner().getState().subscribe(this, true);
    }

    private void makePattern() {
        ArrayList<RuleNode> rootNodes = new ArrayList<RuleNode>();
        rootNodes.addAll(this.condition.getRoot().nodeSet());
        Collections.sort(rootNodes, NodeComparator.instance());
        this.pattern = new RuleElement[rootNodes.size() + 1];
        int i = 0;
        for (RuleNode n : rootNodes) {
            this.pattern[i++] = n;
        }
        this.pattern[i] = this.condition.getCountNode();
    }

    @Override
    public int demandOneMatch() {
        return 0;
    }

    @Override
    public boolean demandUpdate() {
        return false;
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return node instanceof QuantifierCountChecker && ((QuantifierCountChecker)node).condition.equals(this.condition);
    }

    public boolean equals(Object obj) {
        return obj instanceof ReteNetworkNode && this.equals((ReteNetworkNode)obj);
    }

    @Override
    public RuleElement[] getPattern() {
        return this.pattern;
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch match) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return 1;
    }

    public ConditionChecker getUniversalQuantifierChecker() {
        return this.universalQuantifierChecker;
    }

    public void setUniversalQuantifierChecker(ConditionChecker cc) {
        assert (cc.getCondition().equals(this.condition));
        this.universalQuantifierChecker = cc;
    }

    public VariableNode getCountNode() {
        return this.universalQuantifierChecker.getCondition().getCountNode();
    }

    public boolean invalidateCount() {
        boolean result;
        boolean bl = result = !this.matches.isEmpty();
        if (result) {
            for (ReteSimpleMatch reteSimpleMatch : this.matches) {
                reteSimpleMatch.dominoDelete(null);
            }
            this.matches.clear();
        }
        if (this.dummyMatch != null) {
            this.dummyMatch.dominoDelete(null);
            this.dummyMatch = null;
        }
        this.updatesSent = false;
        return result;
    }

    @Override
    public void clear() {
        this.matches.clear();
        this.dummyMatch = null;
        this.updatesSent = false;
        this.conditionMatcher = null;
    }

    @Override
    public List<? extends Object> initialize() {
        return null;
    }

    @Override
    public void updateBegin() {
    }

    @Override
    public void updateEnd() {
        if (!this.updatesSent) {
            this.calculateMatches();
            if (!this.matches.isEmpty()) {
                for (ReteSimpleMatch reteSimpleMatch : this.matches) {
                    this.passDownMatchToSuccessors(reteSimpleMatch);
                }
            }
            if (this.dummyMatch != null) {
                this.passDownMatchToSuccessors(this.dummyMatch);
            }
            this.updatesSent = true;
        }
    }

    private void calculateMatches() {
        this.matches.clear();
        Set<RuleToHostMap> activeAnchors = this.universalQuantifierChecker.getActiveConflictsetAnchors(false);
        if (this.conditionMatcher == null) {
            this.conditionMatcher = this.getOwner().getOwnerEngine().createMatcher(this.universalQuantifierChecker.getCondition(), null, null);
        }
        if (activeAnchors != null) {
            for (RuleToHostMap anchor : activeAnchors) {
                ReteSimpleMatch.ReteCountMatch m = this.getCountMatch(anchor);
                if (m == null) continue;
                this.matches.add(m);
            }
        } else {
            ReteSimpleMatch.ReteCountMatch m = this.getCountMatch(null);
            if (m != null) {
                this.matches.add(m);
            }
        }
        this.dummyMatch = this.condition.getCountNode().getConstant() == null ? new ReteSimpleMatch.ReteCountMatch((ReteNetworkNode)this, this.getOwner().getOwnerEngine().getNetwork().getHostFactory().createNodeFromJava(JavaIntAlgebra.instance, 0)) : null;
    }

    private ReteSimpleMatch.ReteCountMatch getCountMatch(RuleToHostMap anchor) {
        ReteSimpleMatch.ReteCountMatch countMatch = null;
        ArrayList matchList = new ArrayList();
        Visitor.Collector collector = Visitor.Collector.newCollector(matchList);
        this.conditionMatcher.traverse(this.getOwner().getOwnerEngine().getNetwork().getState().getHostGraph(), anchor, collector);
        ValueNode vn = this.getOwner().getOwnerEngine().getNetwork().getHostFactory().createNodeFromJava(JavaIntAlgebra.instance, matchList.size());
        if (this.getCountNode().getConstant() != null) {
            if (this.getCountNode().getConstant().getSymbol().equals(vn.getSymbol())) {
                countMatch = new ReteSimpleMatch.ReteCountMatch((ReteNetworkNode)this, this.getAnchorNodes(anchor), vn);
            }
        } else {
            countMatch = new ReteSimpleMatch.ReteCountMatch((ReteNetworkNode)this, this.getAnchorNodes(anchor), vn);
        }
        if (countMatch != null) {
            this.matches.add(countMatch);
        }
        return countMatch;
    }

    private HostNode[] getAnchorNodes(RuleToHostMap map) {
        HostNode[] result = new HostNode[this.pattern.length - 1];
        if (map != null) {
            int i = 0;
            while (i < this.pattern.length - 1) {
                HostNode hn = (HostNode)map.getNode((RuleNode)this.pattern[i]);
                assert (hn != null);
                result[i] = hn;
                ++i;
            }
        }
        return result;
    }

    public boolean isAnchored() {
        return !this.condition.getRoot().isEmpty();
    }

    public boolean isConstant() {
        return this.getCountNode().getConstant() != null;
    }
}

